@extends('layouts.admin')

@section('title', 'Feedback Management')
@section('header_title', 'Feedback Moderation')

@section('content')
<div class="space-y-6">
    <!-- Filters -->
    <div class="flex gap-2">
        @foreach(['pending' => 'Pending Review', 'approved' => 'Approved', 'rejected' => 'Rejected', 'all' => 'All Feedback'] as $key => $label)
            <a href="{{ route('admin.feedback.index', ['status' => $key]) }}" 
               class="px-4 py-2 rounded-xl text-xs font-bold transition-all {{ $status === $key ? 'bg-gray-900 text-white shadow-lg shadow-gray-900/20' : 'bg-white text-gray-500 hover:bg-gray-50 border border-gray-100' }}">
                {{ $label }}
            </a>
        @endforeach
    </div>

    <!-- Feedback List -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        @if($feedbacks->isNotEmpty())
            <div class="divide-y divide-gray-50">
                @foreach($feedbacks as $feedback)
                    <div class="p-6 hover:bg-gray-50/50 transition-colors">
                        <div class="flex items-start gap-4">
                            <!-- User Avatar -->
                            <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center text-gray-400 font-bold overflow-hidden flex-shrink-0">
                                @if($feedback->user->profile_photo)
                                    <img src="{{ $feedback->user->profile_photo_url }}" class="w-full h-full object-cover">
                                @else
                                    {{ substr($feedback->user->full_name, 0, 1) }}
                                @endif
                            </div>

                            <div class="flex-1 min-w-0">
                                <div class="flex items-center justify-between mb-1">
                                    <div class="flex items-center gap-2">
                                        <h4 class="font-bold text-gray-900 text-sm">{{ $feedback->user->full_name }}</h4>
                                        <span class="text-gray-300">•</span>
                                        <span class="text-xs text-gray-500">reviewed</span>
                                        <a href="{{ route('admin.businesses.show', $feedback->business) }}" class="text-xs font-bold text-primary hover:underline">{{ $feedback->business->name }}</a>
                                    </div>
                                    <span class="text-[10px] font-medium text-gray-400">{{ $feedback->created_at->diffForHumans() }}</span>
                                </div>

                                <!-- Sentiment Badge -->
                                <div class="mb-2">
                                    <span class="inline-flex items-center gap-1.5 px-2 py-0.5 rounded text-[10px] font-black uppercase tracking-wider 
                                        {{ $feedback->sentiment === 'positive' ? 'bg-emerald-50 text-emerald-600' : 
                                           ($feedback->sentiment === 'negative' ? 'bg-red-50 text-red-600' : 'bg-gray-100 text-gray-600') }}">
                                        @if($feedback->sentiment === 'positive') <i class="fa-solid fa-smile"></i>
                                        @elseif($feedback->sentiment === 'negative') <i class="fa-solid fa-frown"></i>
                                        @else <i class="fa-solid fa-meh"></i>
                                        @endif
                                        {{ $feedback->sentiment }}
                                    </span>
                                </div>

                                <p class="text-sm text-gray-600 leading-relaxed">{{ $feedback->message }}</p>
                            </div>

                            <!-- Actions -->
                            <div class="flex flex-col gap-2 flex-shrink-0 ml-4">
                                @if($feedback->moderation_status === 'pending')
                                    <form action="{{ route('admin.feedback.update-status', $feedback) }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="status" value="approved">
                                        <button type="submit" class="w-8 h-8 rounded-lg bg-emerald-50 text-emerald-600 hover:bg-emerald-100 flex items-center justify-center transition-colors" title="Approve">
                                            <i class="fa-solid fa-check text-xs"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.feedback.update-status', $feedback) }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="status" value="rejected">
                                        <button type="submit" class="w-8 h-8 rounded-lg bg-red-50 text-red-600 hover:bg-red-100 flex items-center justify-center transition-colors" title="Reject">
                                            <i class="fa-solid fa-xmark text-xs"></i>
                                        </button>
                                    </form>
                                @else
                                    <div class="px-3 py-1 rounded-lg text-xs font-bold uppercase border 
                                        {{ $feedback->moderation_status === 'approved' ? 'border-emerald-100 text-emerald-600 bg-emerald-50' : 'border-red-100 text-red-600 bg-red-50' }}">
                                        {{ $feedback->moderation_status }}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="p-6 border-t border-gray-50">
                {{ $feedbacks->links() }}
            </div>
        @else
            <div class="p-12 text-center">
                <div class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 text-gray-300">
                    <i class="fa-regular fa-comments text-2xl"></i>
                </div>
                <h3 class="text-lg font-bold text-gray-900">No feedback found</h3>
                <p class="text-gray-500 text-sm mt-1">There is no feedback matching the selected filter.</p>
            </div>
        @endif
    </div>
</div>
@endsection
