@extends('layouts.admin')

@section('title', 'Ad Moderation')
@section('header_title', 'Ad Moderation')

@section('content')
<div class="space-y-6">
    <!-- Filters & Search -->
    <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm">
        <form action="{{ route('admin.listings.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div class="md:col-span-2">
                <div class="relative">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by title or description..." 
                           class="w-full pl-10 pr-4 py-2.5 rounded-xl border border-gray-200 focus:border-primary focus:ring-2 focus:ring-primary/10 outline-none text-sm transition-all">
                    <i class="fa-solid fa-search absolute left-3.5 top-1/2 -translate-y-1/2 text-gray-400"></i>
                </div>
            </div>
            
            <div>
                <select name="status" class="w-full px-4 py-2.5 rounded-xl border border-gray-200 focus:border-primary outline-none text-sm bg-white">
                    <option value="">All Statuses</option>
                    <option value="published" {{ request('status') == 'published' ? 'selected' : '' }}>Published</option>
                    <option value="review" {{ request('status') == 'review' ? 'selected' : '' }}>In Review</option>
                    <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft (Unpublished)</option>
                </select>
            </div>
            
            <div class="flex gap-2">
                <button type="submit" class="flex-1 bg-primary text-white py-2.5 rounded-xl font-bold text-sm hover:bg-emerald-600 transition-all flex items-center justify-center gap-2">
                    <i class="fa-solid fa-filter"></i>
                    Filter
                </button>
                <a href="{{ route('admin.listings.index') }}" class="px-4 py-2.5 bg-gray-100 text-gray-600 rounded-xl font-bold text-sm hover:bg-gray-200 transition-all flex items-center justify-center">
                    <i class="fa-solid fa-rotate-left"></i>
                </a>
            </div>
        </form>
    </div>

    <!-- Listings Table -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        <div class="p-4 border-b border-gray-100 flex items-center justify-between bg-gray-50/50">
            <div class="flex items-center gap-3" x-data="{ count: 0 }">
                <span class="text-xs font-bold text-gray-500 uppercase tracking-wider">Bulk Actions:</span>
                <form action="{{ route('admin.listings.bulk-status') }}" method="POST" id="bulkActionForm" class="flex items-center gap-2">
                    @csrf
                    <input type="hidden" name="listings[]"> <!-- Populated via JS -->
                    <select name="status" class="px-3 py-1.5 rounded-lg border border-gray-200 text-xs font-bold focus:border-primary outline-none">
                        <option value="published">Mark as Published</option>
                        <option value="review">Mark as Review</option>
                        <option value="draft">Mark as Draft</option>
                        <option value="rejected">Mark as Rejected</option>
                    </select>
                    <button type="button" onclick="submitBulkAction()" class="px-3 py-1.5 bg-white border border-gray-200 text-gray-700 hover:text-primary hover:border-primary rounded-lg text-xs font-bold transition-all shadow-sm">
                        Apply
                    </button>
                </form>
            </div>
            <div class="text-xs text-gray-400">
                <span id="selectedCount">0</span> items selected
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full text-left text-sm">
                <thead class="bg-gray-50 text-[10px] font-black uppercase text-gray-400">
                    <tr>
                        <th class="px-6 py-4 w-10">
                            <input type="checkbox" id="selectAll" class="rounded border-gray-300 text-primary focus:ring-primary">
                        </th>
                        <th class="px-6 py-4">Listing</th>
                        <th class="px-6 py-4">Seller</th>
                        <th class="px-6 py-4">Price</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4 text-right">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    @forelse($listings as $listing)
                        <tr class="hover:bg-gray-50 transition-all group">
                            <td class="px-6 py-4">
                                <input type="checkbox" name="selected_listings[]" value="{{ $listing->id }}" class="listing-checkbox rounded border-gray-300 text-primary focus:ring-primary">
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-12 h-12 rounded-xl bg-gray-50 overflow-hidden border border-gray-100 shrink-0 group-hover:border-primary/20 transition-all">
                                        @if($listing->thumbnail_url)
                                            <img src="{{ $listing->thumbnail_url }}" class="w-full h-full object-cover">
                                        @else
                                            <div class="w-full h-full flex items-center justify-center text-gray-300">
                                                <i class="fa-solid fa-image"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="min-w-0">
                                        <a href="{{ route('listing.show', $listing->slug) }}" target="_blank" class="font-bold text-gray-800 truncate max-w-[200px] block hover:text-primary hover:underline decoration-2 underline-offset-2 transition-all" title="View Public Listing">{{ $listing->title }} <i class="fa-solid fa-external-link-alt text-[10px] opacity-50 ml-1"></i></a>
                                        <div class="text-[10px] font-medium text-gray-400 uppercase">{{ $listing->category }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                @if($listing->business)
                                    <a href="{{ route('admin.businesses.show', $listing->business) }}" class="group/seller">
                                        <div class="font-medium text-gray-700 group-hover/seller:text-primary transition-colors">{{ $listing->business->name }}</div>
                                        <div class="text-[10px] text-gray-400 group-hover/seller:text-primary/70">Business Account</div>
                                    </a>
                                @else
                                    <a href="{{ route('admin.users.show', $listing->createdBy) }}" class="group/seller">
                                        <div class="font-medium text-gray-700 group-hover/seller:text-primary transition-colors">{{ $listing->createdBy->full_name }}</div>
                                        <div class="text-[10px] text-gray-400 group-hover/seller:text-primary/70">Private Seller</div>
                                    </a>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-black text-gray-800">{{ number_format($listing->price_amount) }} UGX</div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="px-2 py-0.5 rounded text-[10px] font-black uppercase tracking-wider 
                                    {{ $listing->status === 'published' ? 'bg-emerald-50 text-emerald-600' : 
                                       ($listing->status === 'review' ? 'bg-orange-50 text-orange-600' : 
                                       ($listing->status === 'rejected' ? 'bg-red-50 text-red-600' : 'bg-gray-50 text-gray-500')) }}">
                                    {{ $listing->status }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="{{ route('admin.listings.show', $listing) }}" class="p-2 text-gray-400 hover:text-primary hover:bg-primary/5 rounded-lg transition-all" title="Manage Listing">
                                        <i class="fa-solid fa-cog"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-gray-400">
                                <i class="fa-solid fa-tags text-4xl mb-4 opacity-20"></i>
                                <p class="text-sm font-medium">No listings found matching your criteria.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const selectAll = document.getElementById('selectAll');
                const checkboxes = document.querySelectorAll('.listing-checkbox');
                const countDisplay = document.getElementById('selectedCount');
                
                function updateCount() {
                    const checked = document.querySelectorAll('.listing-checkbox:checked').length;
                    countDisplay.textContent = checked;
                }

                selectAll.addEventListener('change', function() {
                    checkboxes.forEach(cb => cb.checked = selectAll.checked);
                    updateCount();
                });

                checkboxes.forEach(cb => {
                    cb.addEventListener('change', function() {
                        updateCount();
                        if (!this.checked) {
                            selectAll.checked = false;
                        } else if (document.querySelectorAll('.listing-checkbox:checked').length === checkboxes.length) {
                            selectAll.checked = true;
                        }
                    });
                });
            });

            function submitBulkAction() {
                const checked = document.querySelectorAll('.listing-checkbox:checked');
                if (checked.length === 0) {
                    alert('Please select at least one listing.');
                    return;
                }

                if (!confirm('Are you sure you want to update the status of ' + checked.length + ' listings?')) {
                    return;
                }

                const form = document.getElementById('bulkActionForm');
                
                // Remove existing hidden inputs if any to avoid duplicates
                const existingInputs = form.querySelectorAll('input[name="listings[]"]');
                existingInputs.forEach(el => el.remove());

                // Append selected IDs
                checked.forEach(cb => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'listings[]';
                    input.value = cb.value;
                    form.appendChild(input);
                });

                form.submit();
            }
        </script>
        
        @if($listings->hasPages())
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-100">
                {{ $listings->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
