@extends('layouts.admin')

@section('title', 'User Details')
@section('header_title', 'User Profile: ' . $user->full_name)

@section('content')
<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Profile Info -->
    <div class="lg:col-span-1 space-y-6">
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8 text-center">
            <div class="w-32 h-32 rounded-3xl bg-gray-100 mx-auto mb-6 flex items-center justify-center text-gray-400 text-4xl font-bold overflow-hidden ring-4 ring-gray-50">
                @if($user->profile_photo)
                    <img src="{{ $user->profile_photo_url }}" class="w-full h-full object-cover">
                @else
                    {{ substr($user->full_name, 0, 1) }}
                @endif
            </div>
            <h2 class="text-xl font-black text-gray-800">{{ $user->full_name }}</h2>
            <p class="text-sm text-gray-400 font-medium uppercase tracking-widest mt-1">{{ $user->role }}</p>
            
            <div class="mt-6 flex items-center justify-center gap-2">
                <span class="px-3 py-1 rounded-full text-xs font-black uppercase {{ $user->status === 'active' ? 'bg-emerald-50 text-emerald-600' : 'bg-red-50 text-red-600' }}">
                    {{ $user->status }}
                </span>
                @if($user->email_verified_at)
                    <span class="px-3 py-1 rounded-full bg-blue-50 text-blue-600 text-xs font-black uppercase" title="Email Verified">
                        <i class="fa-solid fa-envelope-circle-check"></i>
                    </span>
                @endif
            </div>
        </div>

        <!-- Management Actions -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-6 space-y-6">
            <h3 class="font-bold text-gray-800 flex items-center gap-2">
                <i class="fa-solid fa-user-gear text-primary"></i>
                Account Management
            </h3>

            <!-- Status Form -->
            <form action="{{ route('admin.users.update-status', $user) }}" method="POST" class="space-y-3">
                @csrf
                <label class="text-[10px] font-black uppercase text-gray-400">Change Account Status</label>
                <div class="flex gap-2">
                    <select name="status" class="flex-1 bg-gray-50 border border-gray-100 rounded-xl px-4 py-2 text-sm font-semibold outline-none focus:ring-2 focus:ring-primary/10">
                        <option value="active" {{ $user->status === 'active' ? 'selected' : '' }}>Activate Account</option>
                        <option value="suspended" {{ $user->status === 'suspended' ? 'selected' : '' }}>Suspend Account</option>
                    </select>
                    <button type="submit" class="bg-gray-800 text-white px-4 rounded-xl hover:bg-gray-900 transition-all">
                        <i class="fa-solid fa-check"></i>
                    </button>
                </div>
            </form>

            <div class="border-t border-gray-50 my-6"></div>

            <!-- Role Form -->
            <form action="{{ route('admin.users.update-role', $user) }}" method="POST" class="space-y-3">
                @csrf
                <label class="text-[10px] font-black uppercase text-gray-400">Update User Role</label>
                <div class="flex gap-2">
                    <select name="role" class="flex-1 bg-gray-50 border border-gray-100 rounded-xl px-4 py-2 text-sm font-semibold outline-none focus:ring-2 focus:ring-primary/10">
                        <option value="user" {{ $user->role === 'user' ? 'selected' : '' }}>Standard User</option>
                        <option value="seller" {{ $user->role === 'seller' ? 'selected' : '' }}>Professional Seller</option>
                        <option value="admin" {{ $user->role === 'admin' ? 'selected' : '' }}>Administrator</option>
                    </select>
                    <button type="submit" class="bg-gray-800 text-white px-4 rounded-xl hover:bg-gray-900 transition-all">
                        <i class="fa-solid fa-check"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Details Content -->
    <div class="lg:col-span-2 space-y-8">
        <!-- Contact & Security -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8 grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
                <h3 class="font-bold text-gray-800 mb-4">Contact Information</h3>
                <div class="space-y-4">
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Email Address</div>
                            <div class="text-sm font-bold text-gray-700">{{ $user->email }}</div>
                        </div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-phone"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Phone Number</div>
                            <div class="text-sm font-bold text-gray-700">{{ $user->phone ?? 'Not provided' }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div>
                <h3 class="font-bold text-gray-800 mb-4">System Metadata</h3>
                <div class="space-y-4">
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-calendar"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Registered On</div>
                            <div class="text-sm font-bold text-gray-700">{{ $user->created_at->format('M d, Y @ H:i') }}</div>
                        </div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-hashtag"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">System ID</div>
                            <div class="text-sm font-bold text-gray-700">#{{ $user->id }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Linked Businesses -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-8 py-5 border-b border-gray-50 flex items-center justify-between">
                <h3 class="font-bold text-gray-800">Owned Businesses</h3>
                <span class="bg-gray-100 text-gray-600 px-3 py-1 rounded-full text-[10px] font-black">{{ $user->ownedBusinesses->count() }}</span>
            </div>
            @if($user->ownedBusinesses->isNotEmpty())
                <div class="divide-y divide-gray-50">
                    @foreach($user->ownedBusinesses as $business)
                        <div class="px-8 py-4 flex items-center justify-between">
                            <div class="flex items-center gap-4">
                                <a href="{{ route('admin.businesses.show', $business) }}" class="flex items-center gap-4 group hover:opacity-75 transition-opacity">
                                    <div class="w-10 h-10 rounded-xl bg-emerald-50 text-emerald-600 flex items-center justify-center font-bold group-hover:bg-emerald-100 transition-colors">
                                        {{ substr($business->name, 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 group-hover:text-primary transition-colors">{{ $business->name }}</div>
                                        <div class="text-[10px] font-medium text-gray-400 uppercase">{{ $business->business_category }}</div>
                                    </div>
                                </a>
                            </div>
                            <div class="flex items-center gap-3">
                                <span class="px-2 py-0.5 rounded text-[9px] font-black uppercase tracking-wider {{ $business->verification_status === 'verified' ? 'bg-emerald-50 text-emerald-600' : 'bg-orange-50 text-orange-600' }}">
                                    {{ $business->verification_status }}
                                </span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="px-8 py-10 text-center text-gray-400">
                    <p class="text-sm font-medium">This user does not own any businesses.</p>
                </div>
            @endif
        </div>

        <!-- Active Listings -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-8 py-5 border-b border-gray-50 flex items-center justify-between">
                <h3 class="font-bold text-gray-800">Recent Ads</h3>
                <span class="bg-gray-100 text-gray-600 px-3 py-1 rounded-full text-[10px] font-black tracking-widest">{{ $user->createdListings->count() }} TOTAL</span>
            </div>
            @if($user->createdListings->isNotEmpty())
                <div class="divide-y divide-gray-50">
                    @foreach($user->createdListings->take(10) as $listing)
                        <div class="px-8 py-4 flex items-center justify-between">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-xl bg-gray-50 overflow-hidden border border-gray-100">
                                    @if($listing->thumbnail_url)
                                        <img src="{{ $listing->thumbnail_url }}" class="w-full h-full object-cover">
                                    @else
                                        <div class="w-full h-full flex items-center justify-center text-gray-300">
                                            <i class="fa-solid fa-image"></i>
                                        </div>
                                    @endif
                                </div>
                                <div>
                                    <div class="font-bold text-gray-800 text-sm truncate max-w-[200px]">{{ $listing->title }}</div>
                                    <div class="text-[10px] font-bold text-primary">{{ number_format($listing->price_amount) }} UGX</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-[10px] font-black uppercase px-2 py-0.5 rounded {{ $listing->status === 'published' ? 'bg-emerald-50 text-emerald-600' : 'bg-gray-50 text-gray-400' }}">
                                    {{ $listing->status }}
                                </div>
                                <div class="text-[10px] text-gray-400 mt-1">{{ $listing->created_at->format('M d, Y') }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="px-8 py-10 text-center text-gray-400">
                    <p class="text-sm font-medium">This user has not posted any ads yet.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
