<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Reset Successful - {{ config('app.name') }}</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f3f4f6;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            max-width: 520px;
            width: 92%;
            margin: 20px;
            padding: 40px 28px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
            text-align: center;
        }
        .icon {
            width: 72px;
            height: 72px;
            border-radius: 50%;
            margin: 0 auto 18px;
            background: #10b981;
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 34px;
            font-weight: 900;
        }
        h1 {
            font-size: 22px;
            margin: 0 0 10px 0;
            color: #111827;
        }
        p {
            margin: 0;
            color: #6b7280;
            line-height: 1.6;
            font-size: 14px;
        }
        .btn {
            display: inline-block;
            margin-top: 18px;
            padding: 12px 16px;
            border-radius: 10px;
            background: #10b981;
            color: #fff;
            font-weight: 700;
            text-decoration: none;
            font-size: 14px;
        }
        .btn:hover {
            background: #059669;
        }
        .mono {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, 'Liberation Mono', 'Courier New', monospace;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon">✓</div>
        <h1>Password updated</h1>
        <p>Your password has been reset successfully for <span class="mono">{{ $email }}</span>.</p>
        <a class="btn" href="{{ rtrim(config('app.url'), '/') }}/login">Go to Login</a>
    </div>
</body>
</html>
