<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>You're Now the Owner</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #111827;
            background-color: #f9fafb;
        }
        .email-container { max-width: 620px; margin: 0 auto; background: #ffffff; }
        .header { background: #10b981; padding: 28px 24px; text-align: center; }
        .header h1 { color: #ffffff; font-size: 20px; font-weight: 700; margin-bottom: 6px; }
        .header p { color: #ecfdf5; font-size: 13px; }
        .content { padding: 28px 24px; }
        .greeting { font-size: 16px; font-weight: 600; margin-bottom: 14px; }
        .message { font-size: 14px; color: #374151; margin-bottom: 14px; line-height: 1.8; }
        .box { background: #ecfdf5; border: 1px solid #a7f3d0; border-radius: 10px; padding: 14px; margin: 18px 0; }
        .label { font-size: 11px; color: #065f46; text-transform: uppercase; letter-spacing: .06em; margin-bottom: 6px; }
        .value { font-size: 14px; color: #064e3b; font-weight: 700; }
        .footer { padding: 18px 24px; border-top: 1px solid #e5e7eb; color: #6b7280; font-size: 12px; }
    </style>
</head>
<body>
<div class="email-container">
    <div class="header">
        <h1>You're Now a Business Owner</h1>
        <p>{{ config('app.name') }}</p>
    </div>

    <div class="content">
        <div class="greeting">Hi {{ $newOwner->full_name ?? $newOwner->email }},</div>

        <div class="message">
            You have been assigned as the new owner of <strong>{{ $business->name }}</strong>.
        </div>

        <div class="box">
            <div class="label">Business</div>
            <div class="value">{{ $business->name }}</div>
        </div>

        <div class="box">
            <div class="label">Previous Owner</div>
            <div class="value">{{ $previousOwner->full_name ?? $previousOwner->email }} ({{ $previousOwner->email }})</div>
        </div>

        <div class="box">
            <div class="label">Requested By</div>
            <div class="value">{{ $actor->full_name ?? $actor->email }} ({{ $actor->email }})</div>
        </div>

        <div class="message">
            You can now manage the business profile, members, and listings from your account.
        </div>

        <div class="message" style="color:#6b7280;">
            Timestamp: {{ now()->toDayDateTimeString() }}
        </div>
    </div>

    <div class="footer">
        © {{ date('Y') }} {{ config('app.name') }}
    </div>
</div>
</body>
</html>
