<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'Admin Dashboard') | Yilick Admin</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        body { font-family: 'Inter', sans-serif; }
        .sidebar-link.active { background-color: rgba(16, 185, 129, 0.1); color: #10b981; border-right: 4px solid #10b981; }
        .custom-scrollbar::-webkit-scrollbar { width: 4px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #e5e7eb; border-radius: 10px; }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: #d1d5db; }
    </style>
    @stack('styles')
</head>
<body class="bg-gray-50 text-gray-900 custom-scrollbar" x-data="{ sidebarOpen: false }">
    <div class="flex min-h-screen relative">
        <!-- Mobile Overlay -->
        <div x-show="sidebarOpen" 
             @click="sidebarOpen = false"
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 bg-gray-900/80 z-30 md:hidden backdrop-blur-sm">
        </div>

        <!-- Sidebar -->
        <aside :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'" class="fixed inset-y-0 left-0 z-40 w-64 bg-white border-r border-gray-200 transition-transform duration-300 ease-in-out md:translate-x-0 md:sticky md:top-0 md:flex flex-col h-screen overflow-y-auto">
            <div class="p-6 border-b border-gray-100 flex items-center justify-between gap-3">
                <div class="flex items-center gap-3">
                    <img src="/assets/icons/logo.png" alt="YILICK" class="h-8 w-auto">
                    <span class="text-xs font-black uppercase tracking-tighter text-gray-400 bg-gray-50 px-2 py-0.5 rounded">Admin</span>
                </div>
                <!-- Close Button (Mobile) -->
                <button @click="sidebarOpen = false" class="md:hidden text-gray-400 hover:text-gray-600">
                    <i class="fa-solid fa-xmark text-xl"></i>
                </button>
            </div>
            
            <nav class="flex-1 overflow-y-auto p-4 space-y-2 custom-scrollbar">
                <a href="{{ route('admin.dashboard') }}" class="sidebar-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all">
                    <i class="fa-solid fa-chart-line w-5 text-center"></i>
                    <span>Dashboard</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <span class="text-[10px] font-bold text-gray-400 uppercase tracking-widest px-4">Management</span>
                </div>
                
                <a href="{{ route('admin.users.index') }}" class="sidebar-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all">
                    <i class="fa-solid fa-users w-5 text-center"></i>
                    <span>Users</span>
                </a>
                
                <a href="{{ route('admin.businesses.index') }}" class="sidebar-link {{ request()->routeIs('admin.businesses.*') && !request()->routeIs('admin.businesses.verifications') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all">
                    <i class="fa-solid fa-store w-5 text-center"></i>
                    <span>Businesses</span>
                </a>
                
                <a href="{{ route('admin.businesses.verifications') }}" class="sidebar-link {{ request()->routeIs('admin.businesses.verifications') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all flex justify-between items-center group">
                    <div class="flex items-center gap-3">
                        <i class="fa-solid fa-user-check w-5 text-center"></i>
                        <span>Verifications</span>
                    </div>
                    @php $pendingCount = \App\Models\Business::where('verification_status', 'pending')->count(); @endphp
                    @if($pendingCount > 0)
                        <span class="bg-vibrant-orange text-white text-[10px] font-black w-5 h-5 flex items-center justify-center rounded-full">{{ $pendingCount }}</span>
                    @endif
                </a>
                
                <a href="{{ route('admin.listings.index') }}" class="sidebar-link {{ request()->routeIs('admin.listings.*') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all">
                    <i class="fa-solid fa-tags w-5 text-center"></i>
                    <span>Listings</span>
                </a>
                
                <div class="pt-4 pb-2">
                    <span class="text-[10px] font-bold text-gray-400 uppercase tracking-widest px-4">System</span>
                </div>
                
                <a href="{{ route('admin.notifications.index') }}" class="group flex items-center gap-3 px-4 py-3 rounded-2xl transition-all duration-200 {{ request()->routeIs('admin.notifications.*') ? 'bg-primary text-white shadow-lg shadow-primary/30 font-bold' : 'text-gray-500 hover:bg-gray-50 hover:text-gray-900 font-medium' }}">
                    <i class="fa-solid fa-bell text-lg {{ request()->routeIs('admin.notifications.*') ? '' : 'text-gray-300 group-hover:text-primary transition-colors' }}"></i>
                    <span>Notifications</span>
                </a>

                <div class="pt-4 pb-2">
                    <div class="h-px bg-gray-100"></div>
                </div>

                <a href="{{ route('admin.settings.index') }}" class="group flex items-center gap-3 px-4 py-3 rounded-2xl transition-all duration-200 {{ request()->routeIs('admin.settings.*') ? 'bg-primary text-white shadow-lg shadow-primary/30 font-bold' : 'text-gray-500 hover:bg-gray-50 hover:text-gray-900 font-medium' }}">
                    <i class="fa-solid fa-cog text-lg {{ request()->routeIs('admin.settings.*') ? '' : 'text-gray-300 group-hover:text-primary transition-colors' }}"></i>
                    <span>System Settings</span>
                </a>
                
                <a href="{{ route('admin.categories.index') }}" class="sidebar-link {{ request()->routeIs('admin.categories.*') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all">
                    <i class="fa-solid fa-layer-group w-5 text-center"></i>
                    <span>Categories</span>
                </a>
                <a href="{{ route('admin.feedback.index') }}" class="sidebar-link {{ request()->routeIs('admin.feedback.*') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all">
                    <i class="fa-regular fa-comments w-5 text-center"></i>
                    <span>Feedback</span>
                </a>
                <a href="{{ route('admin.blog.index') }}" class="sidebar-link {{ request()->routeIs('admin.blog.*') ? 'active' : '' }} flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-semibold text-gray-600 hover:bg-gray-50 transition-all">
                    <i class="fa-solid fa-newspaper w-5 text-center"></i>
                    <span>Blog</span>
                </a>
            </nav>
            
            <div class="p-4 border-t border-gray-100">
                <div class="bg-gray-50 rounded-2xl p-4">
                    <a href="{{ route('admin.profile.index') }}" class="flex items-center gap-3 mb-3 hover:bg-white p-2 -m-2 rounded-xl transition-colors group">
                        <div class="w-10 h-10 rounded-xl bg-primary text-white flex items-center justify-center font-bold shadow-sm group-hover:shadow-md transition-all">
                            {{ substr(auth()->user()->full_name, 0, 1) }}
                        </div>
                        <div class="flex-1 overflow-hidden">
                            <div class="text-sm font-bold truncate text-gray-900 group-hover:text-primary transition-colors">{{ auth()->user()->full_name }}</div>
                            <div class="text-[10px] font-medium text-gray-400 uppercase">{{ auth()->user()->role }}</div>
                        </div>
                        <i class="fa-solid fa-chevron-right text-xs text-gray-300 group-hover:text-primary opacity-0 group-hover:opacity-100 transition-all"></i>
                    </a>
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button type="submit" class="w-full py-2 bg-white border border-gray-200 rounded-xl text-xs font-bold text-red-500 hover:bg-red-50 transition-all flex items-center justify-center gap-2">
                            <i class="fa-solid fa-right-from-bracket"></i>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 flex flex-col min-w-0 overflow-hidden">
            <!-- Header -->
            <header class="bg-white border-b border-gray-200 h-16 flex items-center justify-between px-6 sticky top-0 z-20">
                <div class="flex items-center gap-4">
                    <button class="md:hidden text-gray-600" @click="sidebarOpen = true">
                        <i class="fa-solid fa-bars text-xl"></i>
                    </button>
                    <h1 class="text-lg font-bold text-gray-800">@yield('header_title', 'Dashboard')</h1>
                </div>
                
                <div class="flex items-center gap-4">
                    <a href="{{ route('web.home') }}" class="text-sm font-semibold text-primary hover:underline flex items-center gap-1">
                        <i class="fa-solid fa-arrow-up-right-from-square text-xs"></i>
                        View Site
                    </a>
                </div>
            </header>

            <!-- Page Content -->
            <div class="flex-1 overflow-y-auto p-6 custom-scrollbar">
                @if(session('success'))
                    <div class="mb-6 bg-emerald-50 border border-emerald-100 text-emerald-600 px-4 py-3 rounded-2xl flex items-center gap-3">
                        <i class="fa-solid fa-circle-check"></i>
                        <span class="text-sm font-semibold">{{ session('success') }}</span>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="mb-6 bg-red-50 border border-red-100 text-red-600 px-4 py-3 rounded-2xl flex items-center gap-3">
                        <i class="fa-solid fa-circle-exclamation"></i>
                        <span class="text-sm font-semibold">{{ session('error') }}</span>
                    </div>
                @endif

                @yield('content')
            </div>
        </main>
    </div>
    
    @stack('scripts')
</body>
</html>
