<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $listing->title }} | Yilick</title>

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="{{ $listing->title }}">
    <meta property="og:description" content="{{ str($listing->description)->limit(160) }}">
    @if($imageUrl)
    <meta property="og:image" content="{{ $imageUrl }}">
    @endif

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{ url()->current() }}">
    <meta property="twitter:title" content="{{ $listing->title }}">
    <meta property="twitter:description" content="{{ str($listing->description)->limit(160) }}">
    @if($imageUrl)
    <meta property="twitter:image" content="{{ $imageUrl }}">
    @endif

    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            background-color: #f5f7fa;
            color: #1a202c;
            text-align: center;
            padding: 20px;
        }
        .container {
            max-width: 500px;
            background: white;
            padding: 30px;
            border-radius: 20px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.05);
        }
        img {
            max-width: 100%;
            height: auto;
            border-radius: 12px;
            margin-bottom: 20px;
        }
        h1 { margin: 0 0 10px 0; font-size: 24px; }
        p { color: #4a5568; margin-bottom: 30px; }
        .btn {
            background-color: #008080;
            color: white;
            padding: 15px 30px;
            border-radius: 30px;
            text-decoration: none;
            font-weight: bold;
            display: inline-block;
            transition: transform 0.2s;
        }
        .btn:active { transform: scale(0.95); }
    </style>
</head>
<body>
    <div class="container">
        @if($imageUrl)
        <img src="{{ $imageUrl }}" alt="{{ $listing->title }}">
        @endif
        <h1>{{ $listing->title }}</h1>
        <p>{{ str($listing->description)->limit(100) }}</p>
        
        <a href="{{ $appUrl }}" class="btn">Open in Yilick App</a>
    </div>

    <script>
        // Optional: Auto-redirect to app scheme if on mobile
        window.onload = function() {
            // setTimeout(function() {
            //     window.location.href = "{{ $appUrl }}";
            // }, 500);
        };
    </script>
</body>
</html>
