@extends('layouts.mobile')

@section('title', 'Processing Payment')

@section('content')
<div class="flex flex-col items-center justify-center min-h-[80vh] px-6 py-12 text-center">
    <!-- Animated Icon -->
    <div class="relative mb-8">
        <div class="w-20 h-20 border-4 border-emerald-100 border-t-emerald-500 rounded-full animate-spin"></div>
        <div class="absolute inset-0 flex items-center justify-center">
            <i class="fa-solid fa-mobile-screen text-2xl text-emerald-500 animate-bounce"></i>
        </div>
    </div>

    <!-- Instructions -->
    <h1 class="text-2xl font-bold text-gray-900 mb-4">Confirm Payment</h1>
    <p class="text-gray-600 mb-8 leading-relaxed">
        A payment prompt has been sent to your phone. <br>
        Please <span class="font-bold text-gray-900">enter your PIN</span> on your mobile device to complete the transaction.
    </p>

    <!-- Status Message -->
    <div id="status-badge" class="inline-flex items-center gap-2 px-4 py-2 bg-gray-100 rounded-full text-sm font-medium text-gray-500 mb-12">
        <i class="fa-solid fa-clock"></i>
        <span>Waiting for confirmation...</span>
    </div>

    <!-- Summary Details -->
    <div class="w-full max-w-sm bg-gray-50 rounded-2xl p-6 border border-gray-100 text-left">
        <div class="flex justify-between items-center mb-3">
            <span class="text-xs text-gray-400 uppercase tracking-wider">Package</span>
            <span class="font-bold text-gray-900">{{ $subscription->package->name }}</span>
        </div>
        <div class="flex justify-between items-center">
            <span class="text-xs text-gray-400 uppercase tracking-wider">Amount</span>
            <span class="font-bold text-emerald-600">UGX {{ number_format($subscription->amount_paid) }}</span>
        </div>
    </div>
</div>

@push('scripts')
<script>
    const transactionId = "{{ $subscription->transaction_id }}";
    const statusUrl = "{{ route('web.membership.status', ['transaction_id' => $subscription->transaction_id]) }}";
    const successUrl = "{{ route('web.membership.success', ['mode' => 'mobile']) }}";
    const failedUrl = "{{ route('web.membership.failed', ['mode' => 'mobile']) }}";

    let pollCount = 0;
    const maxPolls = 180; // 2 minutes with 1 sec interval or 60 with 2 sec

    async function checkStatus() {
        try {
            const response = await fetch(statusUrl);
            const data = await response.json();

            if (data.status === 'active') {
                window.location.href = successUrl;
                return;
            } else if (data.status === 'failed') {
                window.location.href = failedUrl;
                return;
            }

            pollCount++;
            if (pollCount < maxPolls) {
                setTimeout(checkStatus, 3000); // Poll every 3 seconds
            } else {
                window.location.href = failedUrl + "?error=timeout";
            }
        } catch (error) {
            console.error('Status check failed:', error);
            setTimeout(checkStatus, 5000); // Retry on error after 5 seconds
        }
    }

    // Start polling
    setTimeout(checkStatus, 2000);
</script>
@endpush
@endsection
