@extends('layouts.app')

@section('title', 'Yilick Journal - Expert Insights on Digital Commerce in Uganda')
@section('meta_description', 'Explore the Yilick Journal for deep-dive articles on Uganda\'s digital commerce, merchant success stories, AI business analytics, and the SafeTrade escrow revolution.')
@section('meta_keywords', 'yilick blog, digital trade uganda, ecommerce insights africa, safetrade escrow, merchant analytics, ugandan entrepreneurs, business growth tips')

@section('content')
<div class="bg-white min-h-screen">
    <!-- Feedback Messages -->
    @if(session('success'))
        <div class="fixed top-24 left-1/2 -translate-x-1/2 z-[100] w-full max-w-md px-4 pointer-events-none">
            <div class="bg-primary text-white p-6 rounded-3xl shadow-xl shadow-primary/20 flex items-center gap-4 animate-slide-in pointer-events-auto">
                <div class="w-10 h-10 rounded-2xl bg-white/20 flex items-center justify-center text-xl">
                    <i class="fa-solid fa-check"></i>
                </div>
                <div class="flex-1 font-bold">{{ session('success') }}</div>
            </div>
        </div>
    @endif

    <!-- Header Section -->
    <header class="relative pt-32 pb-24 overflow-hidden bg-emerald-50/50 border-b border-emerald-100/50">
        <div class="absolute inset-0 pointer-events-none">
            <div class="absolute top-0 right-0 w-[500px] h-[500px] bg-primary/5 rounded-full blur-[120px] -mr-64 -mt-64"></div>
            <div class="absolute bottom-0 left-0 w-[500px] h-[500px] bg-emerald-500/5 rounded-full blur-[120px] -ml-64 -mb-64"></div>
        </div>
        
        <div class="container mx-auto px-4 relative z-10 text-center">
            <span class="inline-block px-5 py-2 rounded-full bg-primary/10 text-primary text-[10px] font-black uppercase tracking-[0.2em] mb-8 border border-primary/20">The Yilick Journal</span>
            <h1 class="text-5xl md:text-7xl font-black text-gray-900 mb-8 tracking-tighter leading-[0.95]">Insights for the <br/><span class="text-primary italic">Modern Seller</span></h1>
            <p class="text-cool-gray text-lg md:text-xl max-w-2xl mx-auto leading-relaxed font-medium">
                Strategies, success stories, and product updates to help you navigate digital commerce in Uganda.
            </p>
        </div>
    </header>

    <!-- Navigation & Search -->
    <section class="sticky top-20 z-30 bg-white/80 backdrop-blur-xl border-b border-gray-100 py-4">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row items-center justify-between gap-6">
                <!-- Categories -->
                <div class="flex items-center gap-2 overflow-x-auto pb-2 md:pb-0 w-full md:w-auto scrollbar-hide">
                    <a href="{{ route('web.blog') }}" class="px-6 py-2.5 rounded-full {{ !request('category') ? 'bg-primary text-white' : 'bg-gray-50 text-gray-600 hover:bg-gray-100' }} font-bold whitespace-nowrap transition-colors">All Posts</a>
                    @foreach(['Business Tips', 'Product News', 'Success Stories'] as $cat)
                        <a href="{{ route('web.blog', ['category' => $cat]) }}" 
                           class="px-6 py-2.5 rounded-full {{ request('category') == $cat ? 'bg-primary text-white' : 'bg-gray-50 text-gray-600 hover:bg-gray-100' }} font-bold whitespace-nowrap transition-colors">
                            {{ $cat }}
                        </a>
                    @endforeach
                </div>

                <!-- Search -->
                <form action="{{ route('web.blog') }}" method="GET" class="relative w-full md:w-72">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search articles..." class="w-full pl-12 pr-4 py-3 bg-gray-50 border border-gray-100 rounded-2xl outline-none focus:ring-4 focus:ring-primary/5 focus:border-primary/20 transition-all font-medium">
                    <i class="fa-solid fa-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                </form>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-24">
        <div class="max-w-7xl mx-auto">
            
            @if($featuredPost && !request('search') && !request('category') && $posts->onFirstPage())
                <!-- Featured Article -->
                <section class="mb-24">
                    <a href="{{ route('web.blog.show', $featuredPost->slug) }}" class="group relative block aspect-[21/9] rounded-[48px] overflow-hidden shadow-2xl shadow-gray-200/50 border border-gray-100 bg-gray-50">
                        @if($featuredPost->featured_image)
                            <img src="{{ $featuredPost->featured_image }}" class="absolute inset-0 w-full h-full object-cover group-hover:scale-105 transition-transform duration-1000" alt="{{ $featuredPost->title }}">
                        @else
                            <div class="absolute inset-0 bg-primary/5"></div>
                        @endif
                        <div class="absolute inset-0 bg-gradient-to-t from-gray-900/90 via-gray-900/40 to-transparent"></div>
                        <div class="absolute bottom-0 left-0 right-0 p-8 md:p-16">
                            <div class="max-w-3xl">
                                <span class="inline-block px-4 py-1.5 rounded-full bg-primary text-white text-[10px] font-black uppercase tracking-widest mb-6 border border-white/20">Featured Insight</span>
                                <h2 class="text-3xl md:text-5xl font-black text-white mb-6 leading-tight group-hover:text-primary transition-colors">{{ $featuredPost->title }}</h2>
                                <p class="text-white/80 text-lg md:text-xl font-medium mb-8 line-clamp-2">{{ $featuredPost->excerpt }}</p>
                                <div class="flex items-center gap-6 text-sm text-white/60 font-bold">
                                    <span>{{ $featuredPost->author }}</span>
                                    <span>•</span>
                                    <span>{{ $featuredPost->published_at->format('M d, Y') }}</span>
                                    <span>•</span>
                                    <span>{{ $featuredPost->read_time }} min read</span>
                                </div>
                            </div>
                        </div>
                    </a>
                </section>
            @endif

            <!-- Articles Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-12 mb-24">
                @forelse($posts as $post)
                    <!-- Article Card -->
                    <a href="{{ route('web.blog.show', $post->slug) }}" class="group block">
                        <div class="aspect-video bg-gray-50 rounded-[32px] mb-6 overflow-hidden border border-gray-100 relative shadow-lg shadow-gray-100/50">
                            <div class="absolute top-4 left-4 z-10">
                                <span class="px-3 py-1 rounded-full bg-white/90 backdrop-blur-md text-[10px] font-black uppercase tracking-widest border border-gray-100 shadow-sm">{{ $post->category }}</span>
                            </div>
                            @if($post->featured_image)
                                <img src="{{ $post->featured_image }}" class="absolute inset-0 w-full h-full object-cover group-hover:scale-110 transition-transform duration-700" alt="{{ $post->title }}">
                            @else
                                <div class="absolute inset-0 bg-primary/5 group-hover:bg-primary/10 transition-colors flex items-center justify-center">
                                    <i class="fa-solid fa-newspaper text-3xl text-primary/10"></i>
                                </div>
                            @endif
                        </div>
                        <h3 class="text-2xl font-black text-gray-900 mb-4 leading-snug group-hover:text-primary transition-colors line-clamp-2 underline-offset-4">{{ $post->title }}</h3>
                        <p class="text-cool-gray font-medium mb-6 line-clamp-2 leading-relaxed">{{ $post->excerpt }}</p>
                        <div class="flex items-center gap-3 text-sm text-cool-gray font-bold">
                            <span>{{ $post->published_at->format('M d, Y') }}</span>
                            <span class="text-gray-200">•</span>
                            <span>{{ $post->read_time }} min read</span>
                        </div>
                    </a>
                @empty
                    <div class="col-span-full text-center py-20 bg-gray-50 rounded-[48px] border-2 border-dashed border-gray-200">
                        <div class="w-20 h-20 bg-white rounded-full flex items-center justify-center mx-auto mb-6 text-gray-300 shadow-sm">
                            <i class="fa-solid fa-feather-pointed text-3xl"></i>
                        </div>
                        <h3 class="text-2xl font-black text-gray-900 mb-2">The ink is still drying</h3>
                        <p class="text-cool-gray font-medium">Check back soon for insights from the frontlines of African commerce.</p>
                    </div>
                @endforelse
            </div>

            @if($posts->hasPages())
                <!-- Pagination -->
                <div class="flex items-center justify-center mb-32">
                    {{ $posts->links() }}
                </div>
            @endif

            <!-- Newsletter Subscription -->
            <div class="relative bg-emerald-950 rounded-[64px] p-12 md:p-24 overflow-hidden text-center">
                <div class="absolute inset-0 opacity-20 pointer-events-none">
                    <div class="absolute top-0 right-0 w-96 h-96 bg-primary rounded-full blur-[100px] -mr-48 -mt-48"></div>
                    <div class="absolute bottom-0 left-0 w-96 h-96 bg-emerald-500 rounded-full blur-[100px] -ml-48 -mb-48"></div>
                </div>

                <div class="relative z-10 max-w-3xl mx-auto">
                    <h2 class="text-4xl md:text-6xl font-black text-white mb-8 tracking-tight">Stay ahead of <br/>the <span class="text-primary italic">curve</span></h2>
                    <p class="text-white/60 text-lg mb-12 font-medium">Join 5,000+ Ugandan entrepreneurs receiving our weekly digest on digital trade and exclusive business growth tools.</p>
                    
                    <form id="newsletterForm" action="{{ route('web.newsletter.subscribe') }}" method="POST" class="flex flex-col sm:flex-row gap-4 max-w-xl mx-auto">
                        @csrf
                        <input type="email" name="email" required placeholder="Your work email" class="flex-1 px-8 py-5 rounded-[2rem] bg-white/10 border border-white/20 text-white placeholder:text-white/30 outline-none focus:bg-white/20 transition-all font-medium">
                        <button type="submit" class="px-10 py-5 bg-primary text-white font-black rounded-[2rem] shadow-2xl shadow-primary/30 hover:bg-emerald-700 transition-all hover:-translate-y-1 active:scale-95 whitespace-nowrap flex items-center justify-center gap-2">
                            <span class="btn-text">Subscribe Now</span>
                            <i class="fa-solid fa-spinner fa-spin hidden btn-loader"></i>
                        </button>
                    </form>
                    <p class="mt-8 text-white/30 text-xs font-bold uppercase tracking-widest">No spam. Only high-value insights.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('newsletterForm');
    if (form) {
        form.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const button = form.querySelector('button[type="submit"]');
            const loader = button.querySelector('.btn-loader');
            const text = button.querySelector('.btn-text');
            const input = form.querySelector('input[name="email"]');
            
            button.disabled = true;
            loader.classList.remove('hidden');
            text.classList.add('opacity-50');
            
            try {
                const response = await fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({ email: input.value })
                });
                
                const data = await response.json();
                
                if (data.status === 'success') {
                    showToast(data.message, 'success');
                    input.value = '';
                } else {
                    showToast(data.message || 'Something went wrong. Please try again.', 'error');
                }
            } catch (error) {
                console.error('Error:', error);
                showToast('Connection error. Please check your internet.', 'error');
            } finally {
                button.disabled = false;
                loader.classList.add('hidden');
                text.classList.remove('opacity-50');
            }
        });
    }
});
</script>

<style>
@keyframes slide-in {
    from { transform: translate(-50%, -100%); opacity: 0; }
    to { transform: translate(-50%, 0); opacity: 1; }
}
.animate-slide-in {
    animation: slide-in 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
}
</style>
@endsection
