@extends('layouts.app')

@section('title', $business->name . ' - Verified Store in ' . ($business->district ?? 'Uganda') . ' | Yilick')
@section('meta_description', Str::limit($business->description ?? 'Visit ' . $business->name . ' on Yilick to browse their latest items, reviews, and verified business details in ' . ($business->district ?? 'Uganda') . '.', 160))
@section('meta_keywords', $business->name . ', ' . ($business->business_category ?? 'shop') . ' ' . ($business->district ?? 'uganda') . ', verified seller yilick, buy and sell kampala')
@section('og_image', $business->logo_url ?? asset('assets/icons/logo.png'))

@section('header_meta')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "{{ $business->name }}",
    "description": "{{ Str::limit(strip_tags($business->description), 200) }}",
    "image": "{{ $business->logo_url ?? asset('assets/icons/logo.png') }}",
    "address": {
        "@type": "PostalAddress",
        "streetAddress": "{{ $business->address ?? '' }}",
        "addressLocality": "{{ $business->district ?? 'Uganda' }}",
        "addressCountry": "UG"
    },
    "telephone": "{{ $business->primary_phone ?? '' }}",
    "url": "{{ url()->current() }}",
    "priceRange": "$$",
    "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "5.0",
        "reviewCount": "{{ max(1, $business->feedbacks_count ?? 0) }}"
    }
}
</script>
@endsection

@section('content')
<div class="bg-gray-50 min-h-screen pb-12">
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <div class="relative bg-slate-50 border-b border-gray-200 pb-12 pt-12 overflow-hidden">
        <!-- Modern Dot Pattern -->
        <div class="absolute inset-0 opacity-[0.4]" style="background-image: radial-gradient(#cbd5e1 1px, transparent 1px); background-size: 24px 24px;"></div>
        
        <div class="container mx-auto px-4 max-w-7xl relative">
            <div class="flex flex-col md:flex-row md:items-start gap-8 md:gap-10">
                <!-- Profile Image -->
                <div class="relative flex-shrink-0 mx-auto md:mx-0">
                    <div class="w-32 h-32 md:w-40 md:h-40 rounded-2xl border-4 border-white shadow-xl overflow-hidden bg-white ring-1 ring-black/5">
                        <img src="{{ $business->logo_url ?? 'https://ui-avatars.com/api/?name='.urlencode($business->name).'&background=f3f4f6&color=374151&size=256' }}" 
                             alt="{{ $business->name }}" 
                             onerror="this.src='{{ asset('assets/icons/favicon.png') }}'"
                             class="w-full h-full object-cover">
                    </div>
                </div>

                <!-- Business Info -->
                <div class="flex-1 w-full text-center md:text-left pt-2">
                    <div class="flex flex-col lg:flex-row lg:justify-between gap-6">
                        <div class="space-y-4">
                            <!-- Name & Verification -->
                            <div class="flex flex-col md:flex-row items-center md:items-start gap-2 md:gap-4">
                                <h1 class="text-3xl md:text-5xl font-black text-slate-900 tracking-tight">
                                    {{ $business->name }}
                                </h1>
                                @if($business->isVerified())
                                    <div class="mt-2 md:mt-1 bg-white text-blue-600 px-3 py-1 rounded-full text-xs font-bold flex items-center gap-1.5 border border-blue-100 shadow-sm shrink-0">
                                        <i class="fa-solid fa-certificate"></i>
                                        <span>Verified Seller</span>
                                    </div>
                                @endif
                            </div>

                            <!-- Meta Info -->
                            <div class="flex flex-wrap items-center justify-center md:justify-start gap-x-4 gap-y-2 text-sm text-slate-500 font-medium">
                                <span class="bg-white px-3 py-1 rounded-md text-slate-700 border border-slate-200 shadow-sm">{{ $business->business_category ?? 'Business' }}</span>
                                <span class="hidden md:inline text-slate-300">•</span>
                                <span class="flex items-center gap-1.5"><i class="fa-solid fa-location-dot text-slate-400"></i> {{ $business->district ?? 'Uganda' }}</span>
                                <span class="hidden md:inline text-slate-300">•</span>
                                <span>Joined {{ $business->created_at->format('M Y') }}</span>
                            </div>
                            
                            <!-- Stats Cards -->
                            <div class="flex items-center justify-center md:justify-start gap-3 pt-3">
                                <div class="bg-white px-4 py-2 rounded-xl border border-slate-200 shadow-sm flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-full bg-emerald-50 flex items-center justify-center text-emerald-600">
                                        <i class="fa-solid fa-layer-group text-sm"></i>
                                    </div>
                                    <div class="text-left">
                                        <span class="block text-sm font-bold text-slate-900 leading-none">{{ $business->listings_count }}</span>
                                        <span class="text-[10px] text-slate-500 uppercase font-bold tracking-wider">Ads</span>
                                    </div>
                                </div>

                                <div class="bg-white px-4 py-2 rounded-xl border border-slate-200 shadow-sm flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
                                        <i class="fa-solid fa-users text-sm"></i>
                                    </div>
                                    <div class="text-left">
                                        <span class="block text-sm font-bold text-slate-900 leading-none">{{ $business->followers_count }}</span>
                                        <span class="text-[10px] text-slate-500 uppercase font-bold tracking-wider">Fans</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="flex flex-col sm:flex-row gap-3 items-center lg:items-start pt-4 lg:pt-0">
                             @if($business->primary_whatsapp)
                            <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $business->primary_whatsapp) }}?text={{ urlencode('Hi, I am interested in your products. ' . url()->current()) }}" target="_blank" class="w-full sm:w-auto px-6 py-3.5 bg-[#25D366] text-white text-sm font-bold rounded-xl hover:bg-[#128C7E] transition-all shadow-lg shadow-green-200 flex items-center justify-center gap-2 transform active:scale-95">
                                <i class="fa-brands fa-whatsapp text-lg"></i>
                                <span>Chat on WhatsApp</span>
                            </a>
                            @endif
                            
                            @if($business->primary_phone)
                            <a href="javascript:void(0)" 
                               onclick="showBusinessPhone(event, this, '{{ $business->primary_phone }}')"
                               class="w-full sm:w-auto px-6 py-3.5 bg-white text-slate-900 text-sm font-bold rounded-xl border border-gray-200 hover:bg-gray-50 transition-all shadow-sm flex items-center justify-center gap-2 group">
                                <i class="fa-regular fa-eye text-slate-400 group-hover:text-emerald-600 transition-colors"></i>
                                <span>Show Contact</span>
                            </a>
                            @endif

                             <button 
                                type="button"
                                onclick="toggleFavoriteGlobal(this, 'business', {{ $business->id }})"
                                data-active="{{ Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'true' : 'false' }}"
                                class="w-full sm:w-auto px-6 py-3.5 bg-white text-sm font-bold rounded-xl border {{ Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'border-primary bg-primary/5 text-primary' : 'border-gray-200 text-slate-900' }} hover:bg-gray-50 transition-all shadow-sm flex items-center justify-center gap-2 group favorite-btn">
                                <i class="{{ Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'fa-solid' : 'fa-regular' }} fa-heart {{ Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'text-primary' : 'text-slate-400 group-hover:text-red-500' }} transition-colors"></i>
                                <span>{{ Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'Following' : 'Follow Shop' }}</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        function showBusinessPhone(event, element, phoneNumber) {
            // Prevent immediate navigation/call
            event.preventDefault();

            // Update href to allow calling on NEXT click
            element.href = 'tel:' + phoneNumber;
            
            // Update Icon
            const icon = element.querySelector('i');
            if (icon) {
                icon.className = 'fa-solid fa-phone text-white';
            }
            
            // Update Text
            const textSpan = element.querySelector('span');
            if (textSpan) {
                textSpan.textContent = phoneNumber;
            }
            
            // Update Style to indicate it's now active/calling
            // Switch to Green for 'Call' action (cleaner UI)
            element.classList.remove('bg-white', 'text-slate-900', 'border-gray-200', 'hover:bg-gray-50');
            element.classList.add('bg-emerald-600', 'text-white', 'border-emerald-500', 'hover:bg-emerald-700');

            // Remove onclick so next click triggers href normally
            element.removeAttribute('onclick');
        }
    </script>
    @endpush


    
    <!-- Tab Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('[data-tab-target]');
            const contents = document.querySelectorAll('[data-tab-content]');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    // Reset active state
                    tabs.forEach(t => {
                        t.classList.remove('border-primary', 'text-primary');
                        t.classList.add('border-transparent', 'text-gray-500');
                    });
                    contents.forEach(c => c.classList.add('hidden'));

                    // Set new active state
                    tab.classList.remove('border-transparent', 'text-gray-500');
                    tab.classList.add('border-primary', 'text-primary');
                    
                    const target = document.querySelector(tab.dataset.tabTarget);
                    target.classList.remove('hidden');
                });
            });
        });
    </script>
    
    <!-- Navigation Tabs (Vanilla Version) -->
    <div class="bg-white border-b border-gray-200 sticky top-16 md:top-20 z-30 shadow-sm">
         <div class="container mx-auto px-4 max-w-7xl">
            <nav class="flex space-x-8" aria-label="Tabs">
                <button data-tab-target="#tab-items" 
                        class="border-primary text-primary whitespace-nowrap py-4 px-1 border-b-2 font-bold text-sm flex items-center gap-2 transition-colors">
                    <i class="fa-solid fa-layer-group"></i> Items
                </button>

                <button data-tab-target="#tab-reviews" 
                        class="border-transparent text-gray-500 hover:text-gray-700 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm flex items-center gap-2 transition-colors">
                    <i class="fa-regular fa-star"></i> Reviews <span class="bg-gray-100 text-gray-600 py-0.5 px-2 rounded-full text-xs ml-1">{{ $business->feedbacks_count }}</span>
                </button>
            </nav>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container mx-auto px-4 max-w-7xl mt-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
            
            <!-- Sidebar (Sticky) -->
            <div class="hidden md:block col-span-1">
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-5 sticky top-40">
                    <h3 class="font-bold text-gray-900 mb-4">Store Details</h3>
                    
                    <div class="space-y-4 text-sm">
                        @if($business->description)
                        <p class="text-gray-600 mb-4 leading-relaxed">{{ $business->description }}</p>
                        <hr class="border-gray-100 mb-4">
                        @endif

                         @if($business->address)
                        <div class="flex items-start gap-3">
                            <i class="fa-solid fa-map-location-dot text-gray-400 mt-1"></i>
                            <span class="text-gray-600">{{ $business->address }}</span>
                        </div>
                        @endif

                        <div class="flex items-center gap-3">
                            <i class="fa-regular fa-clock text-gray-400"></i>
                            <span class="text-green-600 font-medium">Open Now</span> 
                        </div>

                        <hr class="border-gray-100">
                        
                        <div class="flex gap-4 justify-center pt-2">
                             @if($business->facebook_url)
                                <a href="{{ $business->facebook_url }}" class="text-gray-400 hover:text-[#1877F2] transition-colors"><i class="fa-brands fa-facebook text-xl"></i></a>
                            @endif
                            @if($business->instagram_url)
                                <a href="{{ $business->instagram_url }}" class="text-gray-400 hover:text-[#E4405F] transition-colors"><i class="fa-brands fa-instagram text-xl"></i></a>
                            @endif
                             @if($business->tiktok_url)
                                <a href="{{ $business->tiktok_url }}" class="text-gray-400 hover:text-black transition-colors"><i class="fa-brands fa-tiktok text-xl"></i></a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content Area -->
            <div class="col-span-1 md:col-span-3">
                
                <!-- ITEMS TAB -->
                <div id="tab-items" data-tab-content>
                    <!-- Search/Filter Bar -->
                    <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4 mb-6">
                        <h2 class="text-xl font-bold text-gray-900">Latest from {{ $business->name }}</h2>
                        <!-- Search Input -->
                        <form action="{{ route('business.show', $business->slug) }}" method="GET" class="relative w-full sm:w-64">
                            <input type="text" 
                                   name="q"
                                   value="{{ request('q') }}"
                                   placeholder="Search in this store..." 
                                   class="w-full pl-9 pr-4 py-2 border border-gray-200 rounded-lg text-sm focus:border-primary focus:ring-1 focus:ring-primary outline-none shadow-sm">
                            <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 text-xs"></i>
                        </form>
                    </div>
    
                    @if($listings->count() > 0)
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4 md:gap-6">
                            @foreach($listings as $listing)
                                 <x-listing-card :listing="$listing" />
                            @endforeach
                        </div>
    
                        <div class="mt-8">
                            {{ $listings->links('vendor.pagination.yilick') }}
                        </div>
                    @else
                        <div class="text-center py-20 bg-white rounded-xl border border-gray-100 border-dashed">
                            <div class="w-16 h-16 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fa-regular fa-box-open text-gray-300 text-2xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-900">No items available</h3>
                            <p class="text-gray-500 mt-1">This store hasn't posted any listings yet.</p>
                        </div>
                    @endif
                </div>

                <!-- REVIEWS TAB -->
                <div id="tab-reviews" class="hidden" data-tab-content>
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-xl font-bold text-gray-900">Customer Feedback</h2>
                        <!-- Placeholder for "Write Review" button if auth -->
                    </div>

                    @forelse($feedbacks as $feedback)
                    <div class="bg-white rounded-xl border border-gray-100 p-5 mb-4 shadow-sm hover:shadow-md transition-shadow">
                        <div class="flex items-start gap-4">
                            <!-- User Avatar -->
                            <img src="{{ $feedback->user->profile_photo ? $feedback->user->profile_photo_url : 'https://ui-avatars.com/api/?name='.urlencode($feedback->user->full_name ?? 'User').'&background=random' }}" 
                                 class="w-10 h-10 rounded-full object-cover border border-gray-100" 
                                 onerror="this.src='{{ asset('assets/icons/favicon.png') }}'"
                                 alt="User">
                            
                            <div class="flex-1">
                                <!-- Name and Date -->
                                <div class="flex justify-between items-start">
                                    <div>
                                        <h4 class="font-bold text-gray-900 text-sm">{{ $feedback->user->full_name ?? 'Anonymous' }}</h4>
                                        <span class="text-xs text-gray-400">{{ $feedback->created_at->diffForHumans() }}</span>
                                    </div>
                                    <!-- Sentiment Badge -->
                                    @if($feedback->sentiment === 'positive')
                                        <span class="bg-green-50 text-green-700 text-xs px-2 py-1 rounded-full font-bold border border-green-100 flex items-center gap-1">
                                            <i class="fa-solid fa-thumbs-up"></i> Recommended
                                        </span>
                                    @elseif($feedback->sentiment === 'negative')
                                        <span class="bg-red-50 text-red-700 text-xs px-2 py-1 rounded-full font-bold border border-red-100 flex items-center gap-1">
                                            <i class="fa-solid fa-thumbs-down"></i> Not Recommended
                                        </span>
                                    @else
                                        <span class="bg-gray-100 text-gray-600 text-xs px-2 py-1 rounded-full font-bold border border-gray-200">
                                            Neutral
                                        </span>
                                    @endif
                                </div>

                                <!-- Message -->
                                <div class="mt-2 text-gray-700 text-sm leading-relaxed">
                                    {{ $feedback->message }}
                                </div>
                                
                                <!-- Attachments (Images) -->
                                @if($feedback->attachments->count() > 0)
                                    <div class="flex gap-2 mt-3 overflow-x-auto pb-2">
                                        @foreach($feedback->attachments as $attachment)
                                            <button onclick="openLightbox('{{ config('app.url') }}/storage/{{ $attachment->path }}')" class="shrink-0 focus:outline-none">
                                                <img src="{{ config('app.url') }}/storage/{{ $attachment->path }}" class="w-16 h-16 object-cover rounded-lg border border-gray-200 hover:opacity-90 transition-opacity">
                                            </button>
                                        @endforeach
                                    </div>
                                @endif

                                <!-- Business Response -->
                                @foreach($feedback->responses as $response)
                                    <div class="mt-4 bg-gray-50 rounded-lg p-3 border border-gray-100">
                                        <div class="flex items-center gap-2 mb-1">
                                            <i class="fa-solid fa-store text-primary text-xs"></i>
                                            <span class="font-bold text-xs text-gray-900">Store Response</span>
                                            <span class="text-[10px] text-gray-400">• {{ $response->created_at->diffForHumans() }}</span>
                                        </div>
                                        <p class="text-xs text-gray-600">{{ $response->message }}</p>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="text-center py-16 bg-white rounded-xl border border-gray-100 border-dashed">
                        <div class="w-12 h-12 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fa-regular fa-comment-dots text-gray-300 text-xl"></i>
                        </div>
                        <h3 class="text-sm font-medium text-gray-900">No reviews yet</h3>
                        <p class="text-xs text-gray-500 mt-1">Be the first to share your experience with this seller.</p>
                    </div>
                    @endforelse
                </div>

            </div>
            
        </div>
    </div>
</div>

<!-- Lightbox Modal -->
<div id="lightbox-modal" class="fixed inset-0 z-[60] bg-black/90 hidden items-center justify-center p-4 backdrop-blur-sm transition-opacity opacity-0" 
     onclick="closeLightbox()">
    <!-- Close Button -->
    <button onclick="closeLightbox()" class="absolute top-4 right-4 text-white/70 hover:text-white p-2">
        <i class="fa-solid fa-xmark text-4xl"></i>
    </button>
    
    <!-- Image -->
    <img id="lightbox-image" src="" class="max-w-full max-h-[90vh] rounded-lg shadow-2xl transform scale-95 transition-transform duration-300" onclick="event.stopPropagation()">
</div>

@push('scripts')
<script>
    function openLightbox(imageUrl) {
        const modal = document.getElementById('lightbox-modal');
        const img = document.getElementById('lightbox-image');
        
        img.src = imageUrl;
        modal.classList.remove('hidden');
        // Small timeout to allow display:block to apply before opacity transition
        setTimeout(() => {
            modal.classList.remove('opacity-0');
            img.classList.remove('scale-95');
            img.classList.add('scale-100');
        }, 10);
        
        document.body.style.overflow = 'hidden'; // Prevent scrolling
    }

    function closeLightbox() {
        const modal = document.getElementById('lightbox-modal');
        const img = document.getElementById('lightbox-image');
        
        modal.classList.add('opacity-0');
        img.classList.remove('scale-100');
        img.classList.add('scale-95');
        
        setTimeout(() => {
            modal.classList.add('hidden');
            img.src = '';
        }, 300);
        
        document.body.style.overflow = '';
    }

    // Close on Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeLightbox();
        }
    });
</script>
@endpush
@endsection
