@extends('layouts.app')

@section('title', $type === 'phone' ? 'Phone Number' : 'WhatsApp Number')

@section('content')
<div class="min-h-screen bg-gray-50 pb-20 font-sans selection:bg-primary/20">
    <div class="container mx-auto px-4 py-6 max-w-2xl">
        <!-- Header -->
        <div class="flex items-center mb-6">
            <a href="{{ route('web.settings') }}" class="mr-4 w-10 h-10 bg-white rounded-xl shadow-sm border border-gray-100 flex items-center justify-center text-gray-600 hover:text-primary hover:border-primary/20 transition-all">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-900">{{ $type === 'phone' ? 'Phone Number' : 'WhatsApp Number' }}</h1>
        </div>

        <!-- Success Message -->
        @if(session('success'))
        <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-xl flex items-center gap-3">
            <i class="fa-solid fa-check-circle"></i>
            {{ session('success') }}
        </div>
        @endif

        <!-- Error Message -->
        @if($errors->any())
        <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-xl">
             <ul class="list-disc list-inside">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
        
        <!-- Navigation Tabs -->
        <div class="flex gap-2 overflow-x-auto pb-4 mb-2 no-scrollbar">
            <a href="{{ route('web.business.edit') }}" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all {{ Route::is('web.business.edit') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm' }}">
                Details
            </a>
            <a href="{{ route('web.business.links') }}" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all {{ Route::is('web.business.links') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm' }}">
                 Links
            </a>
            <a href="{{ route('web.business.branding') }}" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all {{ Route::is('web.business.branding') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm' }}">
                 Branding
            </a>
            <a href="{{ route('web.business.number.edit', ['type' => 'phone']) }}" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all {{ request()->route('type') == 'phone' ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm' }}">
                 Phone
            </a>
             <a href="{{ route('web.business.members') }}" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all {{ Route::is('web.business.members') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm' }}">
                 Members
            </a>
        </div>

        <form action="{{ route('web.business.number.update', $type) }}" method="POST" class="space-y-6">
            @csrf
            
            <!-- Info Box -->
            <div class="bg-primary/5 rounded-2xl p-4 border border-primary/10 flex gap-4 shadow-sm shadow-primary/5">
                <div class="w-10 h-10 rounded-full bg-primary flex-shrink-0 flex items-center justify-center text-white shadow-sm">
                    @if($type === 'phone')
                        <i class="fa-solid fa-phone text-sm"></i>
                    @else
                        <i class="fa-brands fa-whatsapp text-sm"></i>
                    @endif
                </div>
                <div class="text-xs font-medium text-gray-600 leading-relaxed">
                    @if($type === 'phone')
                        Update the primary phone number customers will use to contact your business.
                    @else
                        Update your WhatsApp number for quick customer communication.
                    @endif
                </div>
            </div>

            <!-- Form Fields -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 space-y-6">
                <!-- Current Number Display -->
                @if(($type === 'phone' && $business->primary_phone) || ($type === 'whatsapp' && $business->primary_whatsapp))
                <div class="bg-gray-50 rounded-xl p-4 border border-gray-200">
                    <div class="text-xs font-bold text-gray-500 mb-1">Current Number</div>
                    <div class="flex items-center gap-2">
                        @if($type === 'phone')
                            <i class="fa-solid fa-phone text-gray-600"></i>
                        @else
                            <i class="fa-brands fa-whatsapp text-gray-600"></i>
                        @endif
                        <span class="font-bold text-gray-900">{{ $type === 'phone' ? $business->primary_phone : $business->primary_whatsapp }}</span>
                    </div>
                </div>
                @endif

                <!-- Number Input -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">{{ $type === 'phone' ? 'Phone Number' : 'WhatsApp Number' }}</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <span class="font-bold text-gray-600">+256</span>
                        </div>
                        <input type="tel" name="number" id="number-input" autocomplete="off"
                            class="w-full pl-20 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="700 000000">
                    </div>
                    <p class="mt-2 text-xs text-gray-500">
                        @if($type === 'phone')
                            Enter number without country code (automatically adds +256)
                        @else
                            Enter WhatsApp number without country code (automatically adds +256)
                        @endif
                    </p>
                    @error('number')
                        <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Helper Info -->
                <div class="bg-blue-50 rounded-xl p-4 border border-blue-100">
                    <div class="flex gap-3">
                        <i class="fa-solid fa-circle-info text-blue-600 text-sm mt-0.5"></i>
                        <div class="text-xs text-blue-900 leading-relaxed">
                            @if($type === 'phone')
                                <strong>Tip:</strong> Use your most reliable number. This will be displayed on your listings and business profile.
                            @else
                                <strong>Tip:</strong> Make sure this number has WhatsApp installed and active for instant customer messaging.
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full py-4 bg-primary hover:bg-primary-dark text-white rounded-xl font-bold text-base shadow-lg shadow-primary/20 transition-all transform active:scale-[0.98]">
                Update {{ $type === 'phone' ? 'Phone Number' : 'WhatsApp Number' }}
            </button>
        </form>
    </div>
</div>

@push('scripts')
<script>
    const numberInput = document.getElementById('number-input');
    
    // Format number as user types
    numberInput.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, ''); // Remove non-digits
        
        // Format as: 700 000000 or 7XX XXX XXX
        if (value.length > 0) {
            if (value.length <= 3) {
                value = value;
            } else if (value.length <= 6) {
                value = value.slice(0, 3) + ' ' + value.slice(3);
            } else {
                value = value.slice(0, 3) + ' ' + value.slice(3, 6) + ' ' + value.slice(6, 9);
            }
        }
        
        e.target.value = value;
    });
    
    // Add hidden input with +256 prefix on form submit
    const form = numberInput.closest('form');
    form.addEventListener('submit', function(e) {
        const rawNumber = numberInput.value.replace(/\s/g, ''); // Remove spaces
        
        if (rawNumber) {
            // Create hidden input with +256 prefix
            const hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = 'number';
            hiddenInput.value = '+256' + rawNumber;
            
            // Remove name from visible input to avoid duplicate submission
            numberInput.removeAttribute('name');
            
            // Add hidden input to form
            form.appendChild(hiddenInput);
        }
    });
</script>
@endpush
@endsection
