@extends('layouts.app')

@section('title', 'How to Sell - Yilick')

@section('content')
<div class="bg-gray-50 min-h-screen pb-20">
    <!-- Header -->
    <div class="bg-white border-b border-gray-100 pt-8 pb-8 sticky top-0 md:static z-30">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto flex items-center gap-4">
                <a href="{{ route('web.help-center') }}" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-cool-gray hover:text-primary transition-colors">
                    <i class="fa-solid fa-chevron-left"></i>
                </a>
                <h1 class="text-xl font-black text-charcoal-gray tracking-tight">How to Sell on Yilick</h1>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-12">
        <div class="max-w-3xl mx-auto">
            <!-- Hero Card -->
            <div class="bg-emerald-600 rounded-[32px] p-8 md:p-12 text-white mb-12 relative overflow-hidden shadow-2xl shadow-emerald-200">
                <div class="absolute top-0 right-0 w-64 h-64 bg-white/10 rounded-full -mr-20 -mt-20 blur-3xl"></div>
                <div class="relative z-10">
                    <div class="w-16 h-16 rounded-2xl bg-white/20 backdrop-blur-md flex items-center justify-center mb-8">
                        <i class="fa-solid fa-store text-3xl"></i>
                    </div>
                    <h2 class="text-3xl md:text-4xl font-black mb-4">Turn your items into cash</h2>
                    <p class="text-white/80 text-lg leading-relaxed">Reach thousands of buyers in Uganda by listing your items on Yilick. Our guide helps you create high-performing ads.</p>
                </div>
            </div>

            <!-- Steps -->
            <div class="space-y-8 relative">
                <!-- Vertical Line -->
                <div class="absolute left-6 top-4 bottom-4 w-0.5 bg-gray-100 hidden md:block"></div>

                @php
                    $steps = [
                        ['step' => 1, 'title' => 'Create an Account', 'desc' => 'Sign up with your phone number or email. A verified account builds trust with potential buyers.', 'icon' => 'fa-user-plus', 'color' => 'emerald'],
                        ['step' => 2, 'title' => 'Snap Great Photos', 'desc' => 'Take clear, well-lit photos of your item from multiple angles. Showcase any flaws to be transparent.', 'icon' => 'fa-camera', 'color' => 'emerald'],
                        ['step' => 3, 'title' => 'Write a Catchy Title', 'desc' => 'Use descriptive keywords that buyers might search for. Include the brand, model, and condition.', 'icon' => 'fa-pen-to-square', 'color' => 'emerald'],
                        ['step' => 4, 'title' => 'Set a Competitive Price', 'desc' => 'Research similar items on Yilick to price yours right. Be clear if the price is negotiable or fixed.', 'icon' => 'fa-tag', 'color' => 'emerald'],
                        ['step' => 5, 'title' => 'Choose the Right Category', 'desc' => 'Pick the most relevant category and sub-category to help buyers find your ad easily.', 'icon' => 'fa-layer-group', 'color' => 'emerald'],
                        ['step' => 6, 'title' => 'Publish and Promote', 'desc' => 'Double-check your ad and hit publish! Consider using our promotion tools to reach more buyers faster.', 'icon' => 'fa-paper-plane', 'color' => 'emerald'],
                        ['step' => 7, 'title' => 'Manage Inquiries', 'desc' => 'Respond quickly to chats and calls. Professional communication leads to faster sales.', 'icon' => 'fa-comments', 'color' => 'emerald'],
                    ];
                @endphp

                @foreach($steps as $step)
                    <div class="relative flex flex-col md:flex-row gap-6 p-6 bg-white rounded-3xl border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                        <div class="flex-shrink-0 w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center font-black text-lg relative z-10 md:mt-2">
                            {{ $step['step'] }}
                        </div>
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-2">
                                <i class="fa-solid {{ $step['icon'] }} text-emerald-400"></i>
                                <h3 class="font-bold text-xl text-charcoal-gray">{{ $step['title'] }}</h3>
                            </div>
                            <p class="text-cool-gray leading-relaxed">{{ $step['desc'] }}</p>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pro Tips -->
            <div class="mt-16 bg-emerald-900 rounded-[40px] p-10 text-white relative overflow-hidden shadow-2xl">
                <div class="absolute bottom-0 right-0 w-48 h-48 bg-emerald-800 rounded-full translate-x-1/2 translate-y-1/2"></div>
                
                <h3 class="text-2xl font-black mb-6 flex items-center gap-3">
                    <i class="fa-solid fa-wand-magic-sparkles text-primary"></i>
                    <span>Seller Pro Tips</span>
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 relative z-10">
                    <div>
                        <h4 class="font-bold mb-2 text-primary">Be Honest</h4>
                        <p class="text-white/70 text-sm leading-relaxed">Describe flaws accurately to avoid disputes during inspection.</p>
                    </div>
                    <div>
                        <h4 class="font-bold mb-2 text-primary">Speed Matters</h4>
                        <p class="text-white/70 text-sm leading-relaxed">Buyers often message multiple sellers. The first to respond usually wins.</p>
                    </div>
                    <div>
                        <h4 class="font-bold mb-2 text-primary">Clear Pricing</h4>
                        <p class="text-white/70 text-sm leading-relaxed">Avoid "Contact for Price" – ads with clear prices get 3x more clicks.</p>
                    </div>
                    <div>
                        <h4 class="font-bold mb-2 text-primary">Safe Payments</h4>
                        <p class="text-white/70 text-sm leading-relaxed">Only release the item once you've confirmed receipt of payment.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
