@extends('layouts.app')

@section('title', 'Hot Deals & Best Offers Today in Uganda | Yilick')
@section('meta_description', 'Don\'t miss out! Discover today\'s hottest deals on electronics, fashion, and more. Randomly selected top-quality listings at the best prices in Uganda.')
@section('meta_keywords', 'top deals uganda, flash sales kampala, best price electronics uganda, cheap shopping kampala, yilick hot deals')

@section('content')
<div class="bg-gray-50 min-h-screen">
    <!-- Hero Section - Modern & Responsive -->
    <div class="relative bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900 overflow-hidden">
        <!-- Decorative Elements -->
        <div class="absolute inset-0 overflow-hidden">
            <div class="absolute -top-24 -right-24 w-96 h-96 bg-orange-500/20 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-24 -left-24 w-80 h-80 bg-rose-500/15 rounded-full blur-3xl"></div>
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-orange-400/5 rounded-full blur-3xl"></div>
        </div>
        
        <!-- Content -->
        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12 md:py-20">
            <div class="flex flex-col md:flex-row items-center gap-8 md:gap-16">
                <!-- Text Content -->
                <div class="flex-1 text-center md:text-left order-2 md:order-1">
                    <!-- Live Badge -->
                    <div class="inline-flex items-center gap-2 bg-orange-500/20 backdrop-blur-sm border border-orange-500/30 rounded-full px-4 py-1.5 mb-6">
                        <span class="relative flex h-2 w-2">
                            <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-orange-400 opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-orange-500"></span>
                        </span>
                        <span class="text-orange-300 text-xs font-bold uppercase tracking-wider">Refreshed Every Visit</span>
                    </div>
                    
                    <!-- Title -->
                    <h1 class="text-4xl sm:text-5xl lg:text-6xl font-black text-white mb-4 tracking-tight">
                        <span class="inline-block">Today's</span>
                        <span class="inline-block bg-gradient-to-r from-orange-400 via-rose-400 to-orange-500 bg-clip-text text-transparent">Hot Deals</span>
                    </h1>
                    
                    <!-- Description -->
                    <p class="text-gray-400 text-base sm:text-lg max-w-xl mx-auto md:mx-0 mb-8">
                        Discover the hottest random picks from our marketplace. These deals are refreshed every time you visit, so grab them while you can!
                    </p>
                    
                    <!-- CTA Buttons -->
                    <div class="flex flex-col sm:flex-row items-center gap-4 justify-center md:justify-start">
                        <button onclick="window.location.reload()" class="w-full sm:w-auto inline-flex items-center justify-center gap-2 px-6 py-3 bg-gradient-to-r from-orange-500 to-rose-500 hover:from-orange-600 hover:to-rose-600 text-white font-bold rounded-xl shadow-lg shadow-orange-500/25 transition-all hover:scale-105 hover:shadow-orange-500/40">
                            <i class="fa-solid fa-shuffle"></i>
                            <span>Shuffle Deals</span>
                        </button>
                        <a href="{{ route('web.home') }}" class="w-full sm:w-auto inline-flex items-center justify-center gap-2 px-6 py-3 bg-white/10 hover:bg-white/20 backdrop-blur-sm text-white font-semibold rounded-xl border border-white/10 transition-all">
                            <i class="fa-solid fa-arrow-left"></i>
                            <span>Back to Home</span>
                        </a>
                    </div>
                </div>
                
                <!-- Graphic Element -->
                <div class="flex-shrink-0 order-1 md:order-2">
                    <div class="relative">
                        <!-- Glow Effect -->
                        <div class="absolute inset-0 bg-gradient-to-tr from-orange-500 to-rose-500 rounded-3xl blur-2xl opacity-40 scale-90"></div>
                        
                        <!-- Main Card -->
                        <div class="relative w-40 h-40 sm:w-56 sm:h-56 lg:w-64 lg:h-64 bg-gradient-to-tr from-orange-500 via-rose-500 to-orange-400 rounded-3xl flex items-center justify-center shadow-2xl transform rotate-3 hover:rotate-0 transition-transform duration-500">
                            <!-- Pattern Overlay -->
                            <div class="absolute inset-0 rounded-3xl opacity-20" style="background-image: url('data:image/svg+xml,%3Csvg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cg fill=\"%23ffffff\" fill-opacity=\"0.4\" fill-rule=\"evenodd\"%3E%3Ccircle cx=\"3\" cy=\"3\" r=\"1.5\"/%3E%3Ccircle cx=\"13\" cy=\"13\" r=\"1.5\"/%3E%3C/g%3E%3C/svg%3E');"></div>
                            
                            <!-- Icon -->
                            <i class="fa-solid fa-fire text-6xl sm:text-7xl lg:text-8xl text-white drop-shadow-lg"></i>
                            
                            <!-- Badge -->
                            <div class="absolute -top-3 -right-3 bg-white text-orange-600 text-xs font-black px-3 py-1.5 rounded-full shadow-lg">
                                50 ITEMS
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Listings Grid -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        @if($listings->count() > 0)
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4 md:gap-6">
                @foreach($listings as $listing)
                    <x-listing-card :listing="$listing" :boosted="$loop->index < 5" />
                @endforeach
            </div>
        @else
            <div class="text-center py-20">
                <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fa-regular fa-face-sad-tear text-gray-400 text-3xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900">No hot deals available right now</h3>
                <p class="text-gray-500 mt-2">Check back later or browse categories.</p>
            </div>
        @endif
    </div>
</div>
@endsection
