@extends('layouts.app')
@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="mb-8">
        <a href="{{ route('web.membership.index') }}" class="text-sm text-gray-500 hover:text-gray-900 flex items-center">
            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
            Back to Packages
        </a>
    </div>

    <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
        <div class="p-8 border-b border-gray-100" style="background-color: {{ $package->color ?? '#3B82F6' }}10;">
            <h2 class="text-2xl font-bold text-gray-900">Checkout</h2>
            <p class="mt-2 text-gray-600">Complete your subscription to <span class="font-bold" style="color: {{ $package->color ?? '#3B82F6' }}">{{ $package->name }}</span></p>
        </div>

        <div class="p-8">
            <div class="flex justify-between items-center mb-6 pb-6 border-b border-gray-100">
                <div>
                    <h3 class="font-semibold text-lg text-gray-900">{{ $package->name }} Plan</h3>
                    <p class="text-sm text-gray-500">Duration: {{ $package->duration_days }} Days</p>
                </div>
                <div class="text-right">
                    @if($discount > 0)
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($finalPrice) }} <span class="text-sm font-normal text-gray-400 line-through">{{ number_format($package->price) }}</span> <span class="text-sm font-normal text-gray-500">{{ $package->currency }}</span></p>
                        <p class="text-xs font-bold text-emerald-600 mt-1">Upgrade Discount: -{{ number_format($discount) }}</p>
                    @else
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($package->price) }} <span class="text-sm font-normal text-gray-500">{{ $package->currency }}</span></p>
                    @endif
                </div>
            </div>

            <form action="{{ route('web.membership.process', $package->id) }}" method="POST" class="space-y-6" id="checkout-form">
                @csrf
                <input type="hidden" name="business_id" value="{{ $businessId }}">
                <input type="hidden" name="full_phone" id="full_phone">
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-4">Payment Method</label>
                    <div class="grid grid-cols-1 gap-4">
                        <!-- Relworx / Mobile Money Option -->
                        <div class="relative flex items-center p-6 border-2 border-emerald-500 bg-emerald-50/10 rounded-2xl cursor-pointer">
                            <input type="radio" name="payment_method" value="mobile_money" checked class="h-5 w-5 text-emerald-600 border-gray-300 focus:ring-emerald-500">
                            <div class="ml-4 flex-1 flex items-center justify-between">
                                <div>
                                    <span class="block text-base font-bold text-gray-900 leading-none mb-1">Mobile Money</span>
                                    <span class="block text-xs text-gray-500 font-medium tracking-wide">MTN MoMo & Airtel Money</span>
                                </div>
                                <div class="flex items-center gap-4">
                                    <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/a/af/MTN_Logo.svg/800px-MTN_Logo.svg.png" class="h-6 w-auto">
                                    <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/3a/Airtel_logo_2010.svg/800px-Airtel_logo_2010.svg.png" class="h-5 w-auto">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="space-y-4">
                    <label for="phone" class="block text-sm font-medium text-gray-700">Mobile Money Number (Uganda)</label>
                    <div class="relative">
                        <input type="tel" id="phone" name="phone_input" 
                               class="block w-full px-4 py-4 rounded-xl border border-gray-200 focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 transition-all font-semibold"
                               placeholder="7XX XXX XXX">
                    </div>
                    <div id="phone-error" class="hidden text-xs font-bold text-red-500 flex items-center gap-1.5 ml-1">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path></svg>
                        <span>Please enter a valid Uganda number (+256...)</span>
                    </div>
                    @error('full_phone')
                    <div class="text-xs font-bold text-red-500 flex items-center gap-1.5 ml-1">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path></svg>
                        <span>{{ $message }}</span>
                    </div>
                    @enderror
                </div>

                <div class="pt-4">
                    <button type="submit" id="pay-button"
                            class="w-full flex justify-center items-center gap-2 py-4 px-4 border border-transparent rounded-xl shadow-sm text-base font-bold text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 transition-all hover:scale-[1.01] disabled:opacity-50">
                        <span id="button-text">Pay {{ number_format($finalPrice) }} {{ $package->currency }}</span>
                        <svg id="button-loader" class="hidden animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                    </button>
                    <p class="mt-4 text-xs text-center text-gray-500 italic">
                        By proceeding, you agree to our <a href="{{ route('web.terms') }}" class="underline hover:text-gray-900">Terms of Service</a>.
                    </p>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@23.0.4/build/css/intlTelInput.css">
<style>
    .iti { width: 100%; }
    .iti__country-list { 
        border-radius: 1rem; 
        border: 1px solid #E5E7EB;
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        padding: 0.5rem;
    }
    .iti__country { padding: 0.5rem 1rem; border-radius: 0.5rem; }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@23.0.4/build/js/intlTelInput.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const phoneInput = document.querySelector("#phone");
        const form = document.querySelector("#checkout-form");
        const payButton = document.querySelector("#pay-button");
        const errorMsg = document.querySelector("#phone-error");
        const fullPhoneInput = document.querySelector("#full_phone");
        const buttonText = document.querySelector("#button-text");
        const buttonLoader = document.querySelector("#button-loader");

        const iti = window.intlTelInput(phoneInput, {
            initialCountry: "ug",
            onlyCountries: ["ug"],
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@23.0.4/build/js/utils.js",
            strictMode: true,
        });

        form.addEventListener('submit', function(e) {
            e.preventDefault();
            errorMsg.classList.add('hidden');
            phoneInput.classList.remove('border-red-500');

            if (iti.isValidNumber()) {
                fullPhoneInput.value = iti.getNumber();
                payButton.disabled = true;
                buttonText.innerText = "Processing...";
                buttonLoader.classList.remove('hidden');
                form.submit();
            } else {
                errorMsg.classList.remove('hidden');
                phoneInput.classList.add('border-red-500');
            }
        });
    });
</script>
@endpush
