@extends('layouts.app')
@section('content')
<div class="min-h-[60vh] flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full text-center">
        <div class="mx-auto flex items-center justify-center h-24 w-24 rounded-full bg-green-100 mb-8">
            <svg class="h-12 w-12 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
            </svg>
        </div>
        
        <h2 class="text-3xl font-extrabold text-gray-900 mb-4">
            Payment Successful!
        </h2>
        
        <p class="text-lg text-gray-600 mb-8">
            Thank you for subscribing. Your premium features are now active.
        </p>

        <div class="space-y-4">
            <a href="{{ route('web.home') }}" class="block w-full py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500">
                Go to Dashboard
            </a>
            
            <a href="{{ route('web.membership.index') }}" class="block w-full py-3 px-4 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500">
                View My Membership
            </a>
        </div>
    </div>
</div>
@endsection
