@php
    $config = [
        'ads' => [
            'icon' => 'fa-clone',
            'color' => 'emerald',
            'title' => 'No Favorite Ads Yet',
            'subtitle' => 'Save ads you\'re interested in to easily find them later and compare prices.',
            'cta' => 'Browse Listings',
            'ctaLink' => route('listing.search')
        ],
        'sellers' => [
            'icon' => 'fa-store',
            'color' => 'blue',
            'title' => 'No Shops Followed',
            'subtitle' => 'Follow your favorite shops to be the first to know when they post new items.',
            'cta' => 'Discover Shops',
            'ctaLink' => route('listing.search')
        ],
        'searches' => [
            'icon' => 'fa-magnifying-glass',
            'color' => 'orange',
            'title' => 'No Saved Searches',
            'subtitle' => 'Save your search filters to quickly run the same search again later.',
            'cta' => 'Start Searching',
            'ctaLink' => route('listing.search')
        ]
    ][$type] ?? [
        'icon' => 'fa-regular fa-heart',
        'color' => 'red',
        'title' => 'No Favorites Yet',
        'subtitle' => 'Start saving items to build your favorites list.',
        'cta' => 'Browse',
        'ctaLink' => route('listing.search')
    ];
    
    $colorClasses = [
        'emerald' => [
            'bg' => 'bg-gradient-to-br from-emerald-50 to-teal-50',
            'icon' => 'text-emerald-400',
            'border' => 'border-emerald-100',
            'btn' => 'bg-primary hover:bg-emerald-600 shadow-emerald-200'
        ],
        'blue' => [
            'bg' => 'bg-gradient-to-br from-blue-50 to-indigo-50',
            'icon' => 'text-blue-400',
            'border' => 'border-blue-100',
            'btn' => 'bg-blue-500 hover:bg-blue-600 shadow-blue-200'
        ],
        'orange' => [
            'bg' => 'bg-gradient-to-br from-orange-50 to-amber-50',
            'icon' => 'text-orange-400',
            'border' => 'border-orange-100',
            'btn' => 'bg-orange-500 hover:bg-orange-600 shadow-orange-200'
        ],
        'red' => [
            'bg' => 'bg-gradient-to-br from-red-50 to-pink-50',
            'icon' => 'text-red-400',
            'border' => 'border-red-100',
            'btn' => 'bg-red-500 hover:bg-red-600 shadow-red-200'
        ]
    ][$config['color']];
@endphp

<div class="flex flex-col items-center justify-center py-16 md:py-24 px-4 text-center">
    <!-- Animated Icon Container -->
    <div class="relative mb-8">
        <!-- Outer Ring Animation -->
        <div class="absolute inset-0 {{ $colorClasses['bg'] }} rounded-[40px] {{ $colorClasses['border'] }} border-2 animate-pulse"></div>
        
        <!-- Main Icon Box -->
        <div class="relative w-28 h-28 md:w-32 md:h-32 rounded-[32px] {{ $colorClasses['bg'] }} border-2 {{ $colorClasses['border'] }} flex items-center justify-center {{ $colorClasses['icon'] }} shadow-lg">
            <i class="fa-solid {{ $config['icon'] }} text-4xl md:text-5xl"></i>
        </div>
        
        <!-- Floating Small Hearts/Icons -->
        <div class="absolute -top-2 -right-2 w-8 h-8 rounded-full bg-white shadow-md flex items-center justify-center {{ $colorClasses['icon'] }} animate-bounce" style="animation-delay: 0.2s;">
            <i class="fa-solid fa-heart text-sm"></i>
        </div>
    </div>
    
    <!-- Text Content -->
    <h3 class="text-2xl md:text-3xl font-black text-gray-900 mb-3 tracking-tight">{{ $config['title'] }}</h3>
    <p class="text-gray-500 text-base md:text-lg max-w-md leading-relaxed mb-8">{{ $config['subtitle'] }}</p>
    
    <!-- CTA Button -->
    <a href="{{ $config['ctaLink'] }}" 
       class="inline-flex items-center gap-2 px-8 py-4 {{ $colorClasses['btn'] }} text-white font-bold rounded-2xl shadow-xl hover:scale-105 hover:-translate-y-0.5 active:scale-95 transition-all duration-300">
        <span>{{ $config['cta'] }}</span>
        <i class="fa-solid fa-arrow-right"></i>
    </a>
    
    <!-- Decorative Background Elements -->
    <div class="absolute inset-0 pointer-events-none overflow-hidden opacity-30">
        <div class="absolute top-10 left-10 text-4xl {{ $colorClasses['icon'] }} opacity-10">
            <i class="fa-regular fa-heart"></i>
        </div>
        <div class="absolute bottom-10 right-10 text-6xl {{ $colorClasses['icon'] }} opacity-10">
            <i class="fa-regular fa-heart"></i>
        </div>
    </div>
</div>
