@php
    $config = [
        'published' => [
            'icon' => 'fa-rectangle-list',
            'color' => 'emerald',
            'title' => 'Ready to sell?',
            'subtitle' => 'You haven\'t posted any active listings yet. Join thousands of sellers and start making money today.',
            'cta' => 'Post Your First Ad',
            'ctaLink' => route('listing.create')
        ],
        'review' => [
            'icon' => 'fa-clipboard-check',
            'color' => 'blue',
            'title' => 'Clean Slate',
            'subtitle' => 'All your submitted ads have been processed. New submissions typically take less than 1 hour.',
            'cta' => 'Create New Ad',
            'ctaLink' => route('listing.create')
        ],
        'declined' => [
            'icon' => 'fa-triangle-exclamation',
            'color' => 'red',
            'title' => 'Zero Issues',
            'subtitle' => 'None of your ads have been declined. We appreciate you following our community guidelines!',
            'cta' => 'Review Marketplace Rules',
            'ctaLink' => route('web.help-center')
        ],
        'closed' => [
            'icon' => 'fa-box-archive',
            'color' => 'gray',
            'title' => 'No Archived Ads',
            'subtitle' => 'You don\'t have any closed or expired listings. Keep your ads active to reach more buyers.',
            'cta' => 'View Inventory',
            'ctaLink' => route('web.my-ads', ['tab' => 'published'])
        ]
    ][$type] ?? [
        'icon' => 'fa-rectangle-list',
        'color' => 'emerald',
        'title' => 'No Listings Yet',
        'subtitle' => 'Start by creating your first professional listing.',
        'cta' => 'Create Ad',
        'ctaLink' => route('listing.create')
    ];

    $themes = [
        'emerald' => [
            'bg' => 'bg-emerald-50',
            'icon' => 'text-emerald-500',
            'glow' => 'bg-emerald-500/10',
            'border' => 'border-emerald-100',
            'btn' => 'bg-[#28a745] hover:bg-[#218838] shadow-emerald-200'
        ],
        'blue' => [
            'bg' => 'bg-blue-50',
            'icon' => 'text-blue-500',
            'glow' => 'bg-blue-500/10',
            'border' => 'border-blue-100',
            'btn' => 'bg-blue-600 hover:bg-blue-700 shadow-blue-200'
        ],
        'red' => [
            'bg' => 'bg-red-50',
            'icon' => 'text-red-500',
            'glow' => 'bg-red-500/10',
            'border' => 'border-red-100',
            'btn' => 'bg-red-600 hover:bg-red-700 shadow-red-200'
        ],
        'gray' => [
            'bg' => 'bg-gray-100',
            'icon' => 'text-gray-500',
            'glow' => 'bg-gray-500/10',
            'border' => 'border-gray-200',
            'btn' => 'bg-gray-900 hover:bg-black shadow-gray-200'
        ]
    ];
    $theme = $themes[$config['color']];
@endphp

<div class="flex flex-col items-center justify-center py-24 px-4 text-center">
    <!-- Animated Icon Scene -->
    <div class="relative mb-10">
        <!-- Background Glow -->
        <div class="absolute inset-x-0 top-0 h-40 w-40 -translate-x-1/2 left-1/2 {{ $theme['glow'] }} rounded-full blur-3xl animate-pulse"></div>
        
        <!-- Icon Container -->
        <div class="relative w-32 h-32 rounded-[2.5rem] {{ $theme['bg'] }} border {{ $theme['border'] }} shadow-inner flex items-center justify-center group overflow-hidden">
            <!-- Decorative Pattern -->
            <div class="absolute inset-0 opacity-[0.03]" style="background-image: url('data:image/svg+xml,%3Csvg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cpath d=\"M0 0h20v20H0V0zm10 17a7 7 0 1 0 0-14 7 7 0 0 0 0 14z\" fill=\"%23000\" fill-opacity=\"1\" fill-rule=\"evenodd\"/%3E%3C/svg%3E');"></div>
            
            <i class="fa-solid {{ $config['icon'] }} text-5xl {{ $theme['icon'] }} transform group-hover:scale-110 transition-transform duration-500 select-none"></i>
            
            <!-- Floating Sparkle Items -->
            <div class="absolute top-4 right-4 text-[10px] {{ $theme['icon'] }} animate-bounce opacity-30">
                <i class="fa-solid fa-sparkles"></i>
            </div>
        </div>
    </div>
    
    <!-- Title & Text -->
    <h3 class="text-3xl font-black text-gray-900 mb-3 tracking-tight italic uppercase italic">
        {{ $config['title'] }}
    </h3>
    <p class="text-gray-400 text-base md:text-lg max-w-sm mb-12 font-medium leading-relaxed">
        {{ $config['subtitle'] }}
    </p>
    
    <!-- Call to Action -->
    <a href="{{ $config['ctaLink'] }}" 
       class="inline-flex items-center gap-3 px-10 py-4 {{ $theme['btn'] }} text-white font-black rounded-2xl shadow-2xl transition-all transform hover:-translate-y-1 active:scale-95 text-sm uppercase tracking-widest">
        <span>{{ $config['cta'] }}</span>
        <i class="fa-solid fa-arrow-right text-xs"></i>
    </a>
</div>
