@extends('layouts.app')

@section('title', 'Verify Receipt #' . ($order->receipt_number ?? substr($order->offline_uuid, 0, 8)) . ' | Yilick')

@section('content')
<div class="bg-gray-50 min-h-screen py-10 md:py-20 px-4">
    <div class="max-w-xl mx-auto">
        <!-- Verified Badge -->
        <div class="mb-8 text-center animate-fade-in">
            <div class="inline-flex items-center gap-2 bg-emerald-500 text-white px-6 py-2.5 rounded-full shadow-lg shadow-emerald-500/20">
                <i class="fa-solid fa-circle-check text-xl"></i>
                <span class="font-black text-sm uppercase tracking-widest">Verified Official Receipt</span>
            </div>
            <p class="text-cool-gray text-xs mt-4 font-medium uppercase tracking-[0.2em]">Authenticity Guaranteed by Yilick AI</p>
        </div>

        <!-- Receipt Card -->
        <div class="bg-white rounded-[2.5rem] shadow-2xl border border-gray-100 overflow-hidden relative group">
            <!-- Decorative gradient top -->
            <div class="absolute top-0 inset-x-0 h-2 bg-gradient-to-r from-emerald-400 via-primary to-emerald-500"></div>

            <div class="p-8 md:p-12">
                <!-- Business Header -->
                <div class="text-center mb-10">
                    @if($order->business && $order->business->logo)
                        <img src="{{ $order->business->logo_url }}" alt="{{ $order->business->name }}" class="h-16 w-auto mx-auto mb-4 object-contain">
                    @endif
                    <h1 class="text-2xl font-black text-gray-900 tracking-tight uppercase">{{ $order->business->name }}</h1>
                    <p class="text-gray-500 text-sm mt-1 font-medium italic">
                        {{ $order->business->address }}, {{ $order->business->district }}
                    </p>
                    <p class="text-gray-500 text-xs mt-1 font-medium">
                        Tel: {{ $order->business->primary_phone ?? $order->business->phone }}
                    </p>
                </div>

                <!-- Receipt Info Grid -->
                <div class="grid grid-cols-2 gap-y-6 border-y border-gray-100 py-8 mb-8">
                    <div>
                        <p class="text-[10px] font-black text-primary uppercase tracking-widest mb-1">Receipt Number</p>
                        <p class="font-bold text-gray-900">{{ $order->receipt_number ?? 'POS-' . strtoupper(substr($order->offline_uuid, 0, 8)) }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-[10px] font-black text-primary uppercase tracking-widest mb-1">Date & Time</p>
                        <p class="font-bold text-gray-900">{{ $order->created_at->format('d M Y, H:i') }}</p>
                    </div>
                    <div>
                        <p class="text-[10px] font-black text-primary uppercase tracking-widest mb-1">Served By</p>
                        <p class="font-bold text-gray-900">{{ $order->cashier->full_name }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-[10px] font-black text-primary uppercase tracking-widest mb-1">Status</p>
                        <span class="inline-flex items-center gap-1.5 text-emerald-600 font-black text-xs uppercase">
                            <span class="w-1.5 h-1.5 bg-emerald-500 rounded-full animate-pulse"></span>
                            Paid In Full
                        </span>
                    </div>
                </div>

                <!-- Items Table -->
                <div class="mb-10">
                    <table class="w-full">
                        <thead>
                            <tr class="text-[10px] font-black text-cool-gray uppercase tracking-widest border-b border-gray-50">
                                <th class="text-left pb-4">Item Description</th>
                                <th class="text-center pb-4">Qty</th>
                                <th class="text-right pb-4">Total</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50">
                            @foreach($order->items as $item)
                            <tr>
                                <td class="py-4">
                                    <p class="font-bold text-gray-900 text-sm capitalize">{{ $item['title'] }}</p>
                                    <p class="text-[10px] text-cool-gray font-medium mt-0.5">@ {{ number_format($item['price']) }}</p>
                                </td>
                                <td class="py-4 text-center font-bold text-gray-700 text-sm">{{ $item['qty'] ?? ($item['quantity'] ?? 0) }}</td>
                                <td class="py-4 text-right font-black text-gray-900 text-sm">
                                    @php
                                        $itemPrice = $item['price'] ?? 0;
                                        $itemQty = $item['qty'] ?? ($item['quantity'] ?? 0);
                                        $itemDiscount = $item['discount_amount'] ?? 0;
                                        $itemTaxRate = $item['tax_rate'] ?? 0;
                                        
                                        $subtotal = ($itemPrice * $itemQty) - $itemDiscount;
                                        $total = $subtotal + ($subtotal * ($itemTaxRate / 100));
                                    @endphp
                                    {{ number_format($total) }}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Finance Summary -->
                <div class="bg-gray-50 rounded-2xl p-6 space-y-3">
                    <div class="flex justify-between text-sm font-medium text-gray-600">
                        <span>Subtotal</span>
                        <span>{{ number_format($order->total_amount - $order->tax_amount + $order->discount_amount) }}</span>
                    </div>
                    @if($order->tax_amount > 0)
                    <div class="flex justify-between text-sm font-medium text-gray-600">
                        <span>Tax</span>
                        <span>{{ number_format($order->tax_amount) }}</span>
                    </div>
                    @endif
                    @if($order->discount_amount > 0)
                    <div class="flex justify-between text-sm font-medium text-emerald-600">
                        <span>Discount</span>
                        <span>-{{ number_format($order->discount_amount) }}</span>
                    </div>
                    @endif
                    <div class="pt-3 border-t border-gray-200 flex justify-between items-center">
                        <span class="text-base font-black text-gray-900 uppercase tracking-tight">Total Amount</span>
                        <span class="text-2xl font-black text-primary tracking-tighter">{{ number_format($order->total_amount) }} <span class="text-xs uppercase ml-1">{{ $order->business->currency ?? 'UGX' }}</span></span>
                    </div>
                </div>

                <!-- Payment Methods -->
                <div class="mt-8 flex flex-wrap gap-2 justify-center">
                    @foreach($order->payments as $payment)
                    <div class="px-4 py-2 bg-white border border-gray-100 rounded-xl shadow-sm flex items-center gap-2">
                        <i class="fa-solid fa-credit-card text-cool-gray text-xs"></i>
                        <span class="text-[10px] font-black text-gray-700 uppercase tracking-wider">
                            {{ str_replace('_', ' ', $payment->payment_method) }}: {{ number_format($payment->amount) }}
                        </span>
                    </div>
                    @endforeach
                </div>

                <!-- Security Footer -->
                <div class="mt-12 text-center pt-8 border-t border-dashed border-gray-200">
                    <p class="text-[10px] font-black text-cool-gray uppercase tracking-widest mb-4">Official Verification Token</p>
                    <div class="bg-gray-100 p-3 rounded-xl break-all">
                        <code class="text-[9px] font-mono text-gray-500 uppercase">{{ $order->offline_uuid }}</code>
                    </div>
                    <p class="text-cool-gray text-[10px] font-medium mt-8 leading-relaxed">
                        This document is a certified digital record of the transaction processed via Yilick POS.<br>
                        Generated on {{ $order->synced_at->format('d/m/Y') }} by Xperbyte LTD.
                    </p>
                </div>
            </div>
        </div>

        <!-- App CTA -->
        <div class="mt-12 text-center pb-20">
            <h3 class="text-lg font-black text-gray-900 tracking-tight mb-4">Grow your business with Yilick</h3>
            <div class="flex items-center justify-center gap-4">
                <a href="{{ route('web.home') }}" class="btn-primary flex items-center gap-2">
                    <i class="fa-solid fa-store"></i>
                    <span>Visit Marketplace</span>
                </a>
                <a href="{{ route('web.download') }}" class="bg-white hover:bg-gray-50 py-3 px-6 rounded-2xl font-bold text-gray-700 border border-gray-200 transition-all">
                    Get the App
                </a>
            </div>
        </div>
    </div>
</div>

<style>
    @keyframes fade-in {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animate-fade-in {
        animation: fade-in 0.6s ease-out forwards;
    }
</style>
@endsection
