@extends('layouts.app')

@section('title', 'Personal Details')

@section('content')
<div class="min-h-screen bg-gray-50 pb-20 font-sans selection:bg-primary/20">
    <div class="container mx-auto px-4 py-6 max-w-2xl">
        <!-- Header -->
        <div class="flex items-center mb-6">
            <a href="{{ route('web.settings') }}" class="mr-4 w-10 h-10 bg-white rounded-xl shadow-sm border border-gray-100 flex items-center justify-center text-gray-600 hover:text-primary hover:border-primary/20 transition-all">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-900">Personal Details</h1>
        </div>

        <form action="{{ route('web.settings.personal-details.update') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            
            <!-- Info Box -->
            <div class="bg-primary/5 rounded-2xl p-4 border border-primary/10 flex gap-4 shadow-sm shadow-primary/5">
                <div class="w-8 h-8 rounded-full bg-primary flex-shrink-0 flex items-center justify-center text-white shadow-sm">
                    <i class="fa-regular fa-user text-sm"></i>
                </div>
                <div class="text-xs font-medium text-gray-600 leading-relaxed">
                    {{ __('Yilick keeps your personal details private. Other users will only see your name and profile picture.') }}
                </div>
            </div>

            <!-- Profile Photo -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100">
                <div class="flex items-center gap-3 mb-6">
                    <i class="fa-solid fa-camera text-primary text-lg"></i>
                    <h2 class="text-base font-bold text-gray-900">Profile Photo</h2>
                </div>

                <div class="flex flex-col items-center">
                    <div class="relative group cursor-pointer" onclick="document.getElementById('photo-input').click()">
                        <div class="w-32 h-32 rounded-full bg-gray-100 border-4 border-white shadow-lg overflow-hidden relative">
                            @if(auth('web')->user()->profile_photo)
                                <img src="{{ auth('web')->user()->profile_photo_url }}" onerror="this.src='{{ asset('assets/icons/favicon.png') }}'" class="w-full h-full object-cover">
                            @else
                                <div class="w-full h-full flex items-center justify-center">
                                    <i class="fa-regular fa-user text-4xl text-gray-400"></i>
                                </div>
                            @endif
                            <div class="absolute inset-0 bg-black/40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                                <i class="fa-solid fa-camera text-white text-2xl"></i>
                            </div>
                        </div>
                        <div class="absolute bottom-0 right-0 w-10 h-10 bg-primary rounded-full border-4 border-white shadow-md flex items-center justify-center text-white">
                            <i class="fa-solid fa-pen text-sm"></i>
                        </div>
                    </div>
                    <button type="button" onclick="document.getElementById('photo-input').click()" class="mt-4 text-sm font-bold text-primary hover:text-primary-dark transition-colors">
                        Change photo
                    </button>
                    <input type="file" id="photo-input" name="profile_photo" class="hidden" accept="image/*" onchange="previewImage(this)">
                </div>
            </div>

            <!-- Form Fields -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 space-y-6">
                <!-- Full Name -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Full Name</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-regular fa-user text-gray-400"></i>
                        </div>
                        <input type="text" name="full_name" value="{{ old('full_name', auth('web')->user()->full_name) }}" 
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="Enter your full name">
                    </div>
                    @error('full_name')
                        <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Email (Read Only) -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Email Address</label>
                    <div class="relative opacity-60">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-regular fa-envelope text-gray-400"></i>
                        </div>
                        <input type="email" value="{{ auth('web')->user()->email }}" readonly
                            class="w-full pl-11 pr-4 py-3 bg-gray-100 border border-gray-200 rounded-xl font-medium text-gray-500 cursor-not-allowed">
                    </div>
                </div>

                <!-- Date of Birth -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Date of Birth</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-regular fa-calendar text-gray-400"></i>
                        </div>
                        <input type="date" name="date_of_birth" value="{{ old('date_of_birth', optional(auth('web')->user()->date_of_birth)->format('Y-m-d')) }}"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900">
                    </div>
                    @error('date_of_birth')
                        <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Gender -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Gender</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-solid fa-user-group text-gray-400 text-xs"></i>
                        </div>
                        <select name="gender" class="w-full pl-11 pr-10 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 appearance-none">
                            <option value="">Select Gender</option>
                            <option value="male" {{ old('gender', auth('web')->user()->gender) == 'male' ? 'selected' : '' }}>Male</option>
                            <option value="female" {{ old('gender', auth('web')->user()->gender) == 'female' ? 'selected' : '' }}>Female</option>
                            <option value="other" {{ old('gender', auth('web')->user()->gender) == 'other' ? 'selected' : '' }}>Other</option>
                            <option value="prefer_not_to_say" {{ old('gender', auth('web')->user()->gender) == 'prefer_not_to_say' ? 'selected' : '' }}>Prefer not to say</option>
                        </select>
                        <div class="absolute inset-y-0 right-0 pr-4 flex items-center pointer-events-none">
                            <i class="fa-solid fa-chevron-down text-gray-400 text-xs"></i>
                        </div>
                    </div>
                    @error('gender')
                        <p class="mt-1 text-xs text-red-500 font-bold">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full py-4 bg-primary hover:bg-primary-dark text-white rounded-xl font-bold text-base shadow-lg shadow-primary/20 transition-all transform active:scale-[0.98]">
                Update Personal Details
            </button>
        </form>
    </div>
</div>

@push('scripts')
<script>
    function previewImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                // Determine layout context for image preview
                // Here we just find the nearest img tag in the previous sibling container or similar
                // For simplicity, let's just assume we reload or leverage shared components, 
                // but a customized JS preview is nicer.
                const img = input.closest('.flex').querySelector('img');
                if (img) {
                    img.src = e.target.result; 
                } else {
                     // If no image tag existed (placeholder icon), we might need to swap it.
                     const placeholder = input.closest('.flex').querySelector('.w-32.h-32 > div');
                     if(placeholder) {
                         placeholder.innerHTML = `<img src="${e.target.result}" class="w-full h-full object-cover">`;
                     }
                }
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endpush
@endsection
