<?php

use App\Http\Controllers\Web\HomeController;
use App\Http\Controllers\Web\ProfileController;
use App\Http\Controllers\Web\NotificationController;
use App\Http\Controllers\Web\HelpController;
use App\Http\Controllers\Web\FavoriteController;
use App\Http\Controllers\Auth\PasswordResetController;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'index'])->name('web.home');

// Membership / Subscription (Must be outside auth:web to handle auto-login from Mobile)
Route::get('/membership', [\App\Http\Controllers\Web\MembershipController::class, 'index'])->name('web.membership.index');
Route::get('/membership/checkout/{id}', [\App\Http\Controllers\Web\MembershipController::class, 'checkout'])->name('web.membership.checkout');
Route::post('/membership/process/{id}', [\App\Http\Controllers\Web\MembershipController::class, 'processPayment'])->name('web.membership.process');
Route::get('/membership/processing/{transaction_id}', [\App\Http\Controllers\Web\MembershipController::class, 'processing'])->name('web.membership.processing');
Route::get('/membership/success', [\App\Http\Controllers\Web\MembershipController::class, 'success'])->name('web.membership.success');
Route::get('/membership/failed', [\App\Http\Controllers\Web\MembershipController::class, 'failed'])->name('web.membership.failed');
Route::get('/membership/status/{transaction_id}', [\App\Http\Controllers\Web\MembershipController::class, 'checkStatus'])->name('web.membership.status');
Route::get('/membership/finish', function () { return redirect()->route('web.home'); })->name('web.membership.finish');

Route::middleware(['auth:web'])->group(function () {
    Route::get('/profile', [ProfileController::class, 'index'])->name('web.profile');
    Route::get('/my-ads', [ProfileController::class, 'myAds'])->name('web.my-ads');
    Route::post('/switch-business', [ProfileController::class, 'switchBusiness'])->name('web.switch-business');
    Route::get('/business/create', [\App\Http\Controllers\WebBusinessController::class, 'create'])->name('business.create');
    Route::post('/business', [\App\Http\Controllers\WebBusinessController::class, 'store'])->name('business.store');
    Route::get('/business/success/{business}', [\App\Http\Controllers\WebBusinessController::class, 'success'])->name('business.success');
    Route::get('/notifications', [NotificationController::class, 'index'])->name('web.notifications');
    Route::post('/notifications/read-all', [NotificationController::class, 'markAllAsRead'])->name('web.notifications.read-all');
    Route::post('/notifications/{id}/read', [NotificationController::class, 'markAsRead'])->name('web.notifications.read');
    
    // Listing Management
    Route::post('/listing/{id}/repost', [\App\Http\Controllers\WebListingController::class, 'repost'])->name('listing.repost');
    Route::post('/listing/{id}/close', [\App\Http\Controllers\WebListingController::class, 'close'])->name('listing.close');
    Route::delete('/listing/{id}', [\App\Http\Controllers\WebListingController::class, 'destroy'])->name('listing.destroy');
    Route::post('/listing/bulk-repost', [\App\Http\Controllers\WebListingController::class, 'bulkRepost'])->name('listing.bulk-repost');
    Route::post('/listing/bulk-destroy', [\App\Http\Controllers\WebListingController::class, 'bulkDestroy'])->name('listing.bulk-destroy');
    
    // Edit & Update Listing
    Route::get('/ad/{slug}/edit', [\App\Http\Controllers\WebListingController::class, 'edit'])->name('listing.edit');
    Route::put('/listing/{id}', [\App\Http\Controllers\WebListingController::class, 'update'])->name('listing.update');
    Route::delete('/listing/media/{id}', [\App\Http\Controllers\WebListingController::class, 'deleteMedia'])->name('listing.media.delete');
    
    // Create Listing
    Route::get('/post-ad', [\App\Http\Controllers\WebListingController::class, 'create'])->name('listing.create');
    Route::post('/listing', [\App\Http\Controllers\WebListingController::class, 'store'])->name('listing.store');
    Route::post('/listing/media/upload', [\App\Http\Controllers\WebListingController::class, 'uploadMedia'])->name('listing.media.upload');

    // Favorites
    Route::get('/favorites', [FavoriteController::class, 'index'])->name('web.favorites');
    Route::post('/favorites/toggle-listing', [FavoriteController::class, 'toggleListing'])->name('web.favorites.toggle-listing');
    Route::post('/favorites/toggle-business', [FavoriteController::class, 'toggleBusiness'])->name('web.favorites.toggle-business');
    Route::post('/favorites/search', [FavoriteController::class, 'saveSearch'])->name('web.favorites.save-search');
    Route::delete('/favorites/search/{id}', [FavoriteController::class, 'removeSearch'])->name('web.favorites.remove-search');
    
    // Chat Pages
    Route::get('/messages/start/{listing}', [\App\Http\Controllers\Web\ChatController::class, 'startChat'])->name('web.chat.start');
    Route::get('/messages', [\App\Http\Controllers\Web\ChatController::class, 'inbox'])->name('web.chat.inbox');
    Route::get('/messages/{conversation}', [\App\Http\Controllers\Web\ChatController::class, 'show'])->name('web.chat.show');
    
    // Chat AJAX Endpoints
    Route::get('/api/web/chat/conversations', [\App\Http\Controllers\Web\ChatController::class, 'getConversations'])->name('web.chat.conversations');
    Route::get('/api/web/chat/{conversation}/messages', [\App\Http\Controllers\Web\ChatController::class, 'getMessages'])->name('web.chat.messages');
    Route::post('/api/web/chat/send', [\App\Http\Controllers\Web\ChatController::class, 'sendMessage'])->name('web.chat.send');
    Route::post('/api/web/chat/{conversation}/read', [\App\Http\Controllers\Web\ChatController::class, 'markAsRead'])->name('web.chat.read');

    // Settings
    Route::get('/settings', [App\Http\Controllers\Web\SettingsController::class, 'index'])->name('web.settings');
    Route::post('/settings/update', [App\Http\Controllers\Web\SettingsController::class, 'update'])->name('web.settings.update');
    
    // Personal Details
    Route::get('/settings/personal-details', [App\Http\Controllers\Web\SettingsController::class, 'personalDetails'])->name('web.settings.personal-details');
    Route::post('/settings/personal-details', [App\Http\Controllers\Web\SettingsController::class, 'updatePersonalDetails'])->name('web.settings.personal-details.update');
    
    // Change Password
    Route::get('/settings/change-password', [App\Http\Controllers\Web\SettingsController::class, 'changePassword'])->name('web.settings.change-password');
    Route::post('/settings/change-password', [App\Http\Controllers\Web\SettingsController::class, 'updatePassword'])->name('web.settings.change-password.update');
    
    // Business Management
    Route::get('/business/edit', [App\Http\Controllers\Web\BusinessController::class, 'edit'])->name('web.business.edit');
    Route::post('/business/update', [App\Http\Controllers\Web\BusinessController::class, 'update'])->name('web.business.update');
    Route::get('/business/links', [App\Http\Controllers\Web\BusinessController::class, 'links'])->name('web.business.links');
    Route::post('/business/links/update', [App\Http\Controllers\Web\BusinessController::class, 'updateLinks'])->name('web.business.links.update');
    Route::get('/business/branding', [App\Http\Controllers\Web\BusinessController::class, 'branding'])->name('web.business.branding');
    Route::post('/business/branding/update', [App\Http\Controllers\Web\BusinessController::class, 'updateBranding'])->name('web.business.branding.update');
    Route::get('/business/number/{type}', [App\Http\Controllers\Web\BusinessController::class, 'editNumber'])->name('web.business.number.edit');
    Route::post('/business/number/{type}', [App\Http\Controllers\Web\BusinessController::class, 'updateNumber'])->name('web.business.number.update');

    // Business Members Management
    Route::get('/business/members', [App\Http\Controllers\Web\BusinessController::class, 'members'])->name('web.business.members');
    Route::post('/business/members/invite', [App\Http\Controllers\Web\BusinessController::class, 'invite'])->name('web.business.members.invite');
    Route::post('/business/members/{userId}/role', [App\Http\Controllers\Web\BusinessController::class, 'updateMemberRole'])->name('web.business.members.update-role');
    Route::delete('/business/members/{userId}', [App\Http\Controllers\Web\BusinessController::class, 'removeMember'])->name('web.business.members.remove');
    Route::post('/business/transfer-ownership', [App\Http\Controllers\Web\BusinessController::class, 'transferOwnership'])->name('web.business.transfer-ownership');
    Route::post('/business/transfer-ownership', [App\Http\Controllers\Web\BusinessController::class, 'transferOwnership'])->name('web.business.transfer-ownership');
    Route::get('/invitations/{token}/accept', [App\Http\Controllers\Web\BusinessController::class, 'acceptInvitation'])->name('web.invitation.accept');
    Route::delete('/business/invitations/{id}', [App\Http\Controllers\Web\BusinessController::class, 'revokeInvitation'])->name('web.business.invitations.revoke');

    // Admin Routes
    Route::prefix('admin')->middleware(['role:admin'])->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('admin.dashboard');
        
        // User Management
        Route::get('/users', [\App\Http\Controllers\Admin\UserController::class, 'index'])->name('admin.users.index');
        Route::get('/users/{user}', [\App\Http\Controllers\Admin\UserController::class, 'show'])->name('admin.users.show');
        Route::post('/users/{user}/status', [\App\Http\Controllers\Admin\UserController::class, 'updateStatus'])->name('admin.users.update-status');
        Route::post('/users/{user}/role', [\App\Http\Controllers\Admin\UserController::class, 'updateRole'])->name('admin.users.update-role');

        // Business Management
        Route::get('/businesses', [\App\Http\Controllers\Admin\BusinessController::class, 'index'])->name('admin.businesses.index');
        Route::get('/businesses/verifications', [\App\Http\Controllers\Admin\BusinessController::class, 'verifications'])->name('admin.businesses.verifications');
        Route::get('/businesses/{business}', [\App\Http\Controllers\Admin\BusinessController::class, 'show'])->name('admin.businesses.show');
        Route::post('/businesses/{business}/verify', [\App\Http\Controllers\Admin\BusinessController::class, 'verify'])->name('admin.businesses.verify');
        Route::post('/businesses/{business}/reject', [\App\Http\Controllers\Admin\BusinessController::class, 'reject'])->name('admin.businesses.reject');

        // Listing Management
        Route::get('/listings', [\App\Http\Controllers\Admin\ListingController::class, 'index'])->name('admin.listings.index');
        Route::get('/listings/{listing}', [\App\Http\Controllers\Admin\ListingController::class, 'show'])->name('admin.listings.show');
        Route::post('/listings/bulk-status', [\App\Http\Controllers\Admin\ListingController::class, 'bulkStatus'])->name('admin.listings.bulk-status');
        Route::post('/listings/{listing}/status', [\App\Http\Controllers\Admin\ListingController::class, 'updateStatus'])->name('admin.listings.update-status');
        Route::delete('/listings/{listing}', [\App\Http\Controllers\Admin\ListingController::class, 'destroy'])->name('admin.listings.destroy');

        // Category Management
        Route::get('/categories', [\App\Http\Controllers\Admin\CategoryController::class, 'index'])->name('admin.categories.index');
        Route::post('/categories', [\App\Http\Controllers\Admin\CategoryController::class, 'store'])->name('admin.categories.store');
        Route::post('/categories/{id}', [\App\Http\Controllers\Admin\CategoryController::class, 'update'])->name('admin.categories.update');
        Route::delete('/categories/{id}', [\App\Http\Controllers\Admin\CategoryController::class, 'destroy'])->name('admin.categories.destroy');

        // Notification Center
        Route::get('/notifications', [\App\Http\Controllers\Admin\NotificationController::class, 'index'])->name('admin.notifications.index');
        Route::post('/notifications/send', [\App\Http\Controllers\Admin\NotificationController::class, 'send'])->name('admin.notifications.send');
        Route::post('/notifications/broadcast', [\App\Http\Controllers\Admin\NotificationController::class, 'broadcast'])->name('admin.notifications.broadcast');

        // Feedback Management
        Route::get('/feedback', [\App\Http\Controllers\Admin\FeedbackController::class, 'index'])->name('admin.feedback.index');
        Route::post('/feedback/{feedback}/status', [\App\Http\Controllers\Admin\FeedbackController::class, 'updateStatus'])->name('admin.feedback.update-status');

        // Blog Management
        Route::resource('blog', \App\Http\Controllers\Admin\BlogController::class)->names('admin.blog');

        // System Settings
        Route::get('/settings', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('admin.settings.index');
        Route::post('/settings', [\App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('admin.settings.update');
        Route::post('/settings/company', [\App\Http\Controllers\Admin\SettingsController::class, 'updateCompanyInfo'])->name('admin.settings.update-company');

        // Admin Profile
        Route::get('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'index'])->name('admin.profile.index');
        Route::post('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'update'])->name('admin.profile.update');
    });
});

Route::get('/help-center', [HelpController::class, 'index'])->name('web.help-center');
Route::get('/how-to-buy', [HelpController::class, 'howToBuy'])->name('web.how-to-buy');
Route::get('/how-to-sell', [HelpController::class, 'howToSell'])->name('web.how-to-sell');
Route::get('/safety-center', [HelpController::class, 'safetyCenter'])->name('web.safety-center');
Route::get('/faqs', [HelpController::class, 'faqs'])->name('web.faqs');
Route::get('/terms-and-conditions', [HelpController::class, 'terms'])->name('web.terms');
Route::get('/privacy-policy', [HelpController::class, 'privacy'])->name('web.privacy');
Route::get('/cookie-policy', [HelpController::class, 'cookie'])->name('web.cookie');
Route::get('/contact', [HelpController::class, 'contact'])->name('web.contact');
Route::get('/careers', [HelpController::class, 'careers'])->name('web.careers');
Route::get('/blog', [HelpController::class, 'blog'])->name('web.blog');
Route::get('/blog/{blogPost}', [HelpController::class, 'showBlogPost'])->name('web.blog.show');

Route::post('/contact-support', [HelpController::class, 'sendSupportEmail'])->name('web.support.send');
Route::post('/newsletter/subscribe', [HelpController::class, 'subscribeNewsletter'])->name('web.newsletter.subscribe');
Route::get('/about-us', [HelpController::class, 'about'])->name('web.about');
Route::get('/sitemap.xml', [App\Http\Controllers\Web\SitemapController::class, 'index'])->name('web.sitemap');
Route::view('/download', 'web.download')->name('web.download');

Route::get('/media/{path}', function ($path) {
    $file = storage_path('app/public/' . $path);
    abort_if(!file_exists($file), 404);

    return response()->file($file, [
        'Cache-Control' => 'public, max-age=31536000'
    ]);
})->where('path', '.*');


Route::get('/password/reset/{token}', [PasswordResetController::class, 'show'])->name('password.reset');
Route::post('/password/reset', [PasswordResetController::class, 'reset'])->name('password.update');

Route::get('/ad/{slug}', [\App\Http\Controllers\WebListingController::class, 'show'])->name('listing.show');
Route::post('/ad/{slug}/report', [\App\Http\Controllers\WebListingController::class, 'report'])->name('listing.report');
Route::get('/store/{slug}', [\App\Http\Controllers\WebBusinessController::class, 'show'])->name('business.show');
Route::post('/store/{slug}/block', [\App\Http\Controllers\WebListingController::class, 'blockBusiness'])->name('business.block');
Route::get('/hot-deals', [\App\Http\Controllers\WebListingController::class, 'hotDeals'])->name('listing.hot-deals');
Route::get('/search', [\App\Http\Controllers\WebListingController::class, 'search'])->name('listing.search');
Route::get('/verify/{uuid}', [\App\Http\Controllers\WebReceiptController::class, 'verify'])->name('receipt.verify');

// Auth Routes
Route::get('/login', [\App\Http\Controllers\Web\AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [\App\Http\Controllers\Web\AuthController::class, 'login']);
Route::get('/forgot-password', [\App\Http\Controllers\Web\AuthController::class, 'showForgotPassword'])->name('password.request');
Route::post('/forgot-password', [\App\Http\Controllers\Web\AuthController::class, 'forgotPassword'])->name('password.email');
Route::get('/register', [\App\Http\Controllers\Web\AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [\App\Http\Controllers\Web\AuthController::class, 'register']);
Route::post('/logout', [\App\Http\Controllers\Web\AuthController::class, 'logout'])->name('logout');

// Legacy share route alias
Route::get('/listing-share/{slug}', function($slug) {
    return redirect()->route('listing.show', $slug);
})->name('listing.share');
