<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center max-w-3xl mx-auto mb-16">
            <h2 class="text-base font-semibold text-emerald-600 tracking-wide uppercase">Premium Membership</h2>
            <p class="mt-2 text-4xl font-extrabold text-gray-900 sm:text-5xl tracking-tight">
                Accelerate your business growth
            </p>
            <p class="mt-4 text-xl text-gray-500">
                Unlock exclusive tools, enhanced visibility, and premium support to take your sales to the next level.
            </p>
        </div>

        <?php if($activeSubscription): ?>
            <div class="mb-12 max-w-4xl mx-auto">
                <div class="bg-white rounded-2xl shadow-sm border border-emerald-100 p-6 flex flex-col sm:flex-row items-center justify-between gap-6">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 rounded-full bg-emerald-100 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-crown text-emerald-600 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Current Plan: <?php echo e($activeSubscription->package->name); ?></h3>
                            <div class="flex flex-wrap items-center gap-x-4 gap-y-1 mt-1">
                                <p class="text-emerald-600 font-medium text-sm">
                                    <i class="fa-regular fa-clock mr-1"></i> Expires <?php echo e($activeSubscription->expires_at->format('M d, Y')); ?>

                                </p>
                                <p class="text-gray-500 font-medium text-sm">
                                    <i class="fa-solid fa-chart-line mr-1"></i> 
                                    Listings: <?php echo e($activeSubscription->listings_used); ?> / <?php echo e($activeSubscription->package->max_listings); ?> used
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="hidden sm:block">
                        <div class="px-4 py-2 bg-emerald-50 text-emerald-700 text-xs font-black uppercase tracking-widest rounded-xl border border-emerald-100">
                            Active
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Pricing Cards -->
        <div class="grid gap-8 lg:grid-cols-3 md:grid-cols-2 sm:grid-cols-1 items-start">
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $isPopular = $loop->iteration === 2 && $packages->count() >= 3; 
                    $isCurrent = $activeSubscription && $activeSubscription->package_id === $package->id;
                    $cardClasses = $isPopular 
                        ? 'border-emerald-500 shadow-xl scale-105 z-10' 
                        : 'border-gray-200 shadow-sm hover:shadow-lg hover:-translate-y-1';
                    $btnClasses = 'bg-emerald-600 hover:bg-emerald-700 text-white shadow-md';
                ?>

                <div class="relative flex flex-col bg-white rounded-2xl border transition-all duration-300 <?php echo e($cardClasses); ?>">
                    <?php if($isCurrent): ?>
                        <div class="absolute top-0 right-0 p-4">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-[10px] font-black bg-emerald-100 text-emerald-700 border border-emerald-200 uppercase tracking-widest">
                                Your Plan
                            </span>
                        </div>
                    <?php endif; ?>

                    <?php if($isPopular): ?>
                        <div class="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                            <span class="inline-flex items-center px-4 py-1 rounded-full text-sm font-bold bg-emerald-600 text-white shadow-sm uppercase tracking-wide">
                                Most Popular
                            </span>
                        </div>
                    <?php endif; ?>

                    <div class="p-8 pb-0">
                        <h3 class="text-xl font-bold text-gray-900"><?php echo e($package->name); ?></h3>
                        <p class="mt-2 text-sm text-gray-500 min-h-[40px]"><?php echo e($package->description); ?></p>
                        
                        <div class="my-6 flex items-baseline">
                            <span class="text-4xl font-extrabold text-gray-900"><?php echo e(number_format($package->price)); ?></span>
                            <span class="ml-2 text-gray-500 font-medium"><?php echo e($package->currency); ?></span>
                            <span class="ml-1 text-gray-400 text-sm">/ <?php echo e($package->duration_days); ?> days</span>
                        </div>
                    </div>

                    <div class="flex-1 flex flex-col p-8 pt-0">
                        <ul role="list" class="space-y-4 mb-8 flex-1">
                            <?php $__currentLoopData = $package->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="flex items-start">
                                    <div class="flex-shrink-0 w-6 h-6 rounded-full bg-emerald-50 flex items-center justify-center mt-0.5">
                                        <i class="fa-solid fa-check text-emerald-600 text-xs"></i>
                                    </div>
                                    <span class="ml-3 text-sm text-gray-600"><?php echo e($feature); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                        <?php if($isCurrent): ?>
                            <?php if($package->slug === 'free'): ?>
                                <div class="w-full text-center py-3 px-6 text-sm font-bold bg-gray-100 text-gray-400 border border-gray-200 rounded-xl cursor-not-allowed">
                                    Active Plan
                                </div>
                            <?php else: ?>
                                <a href="<?php echo e(route('web.membership.checkout', ['id' => $package->id, 'business_id' => $businessId])); ?>" 
                                   class="w-full block text-center rounded-xl py-3 px-6 text-sm font-bold bg-emerald-50 text-emerald-700 border border-emerald-200 hover:bg-emerald-100 transition-colors">
                                    Extend Plan
                                </a>
                            <?php endif; ?>
                        <?php else: ?>
                            <a href="<?php echo e(route('web.membership.checkout', ['id' => $package->id, 'business_id' => $businessId])); ?>" 
                               class="w-full block text-center rounded-xl py-3 px-6 text-sm font-bold transition-colors <?php echo e($btnClasses); ?>">
                                <?php echo e($activeSubscription ? 'Change to ' . $package->name : 'Choose ' . $package->name); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Mobile Money Branding -->
        <div class="mt-24 border-t border-gray-100 pt-16 text-center">
            <h3 class="text-sm font-black text-gray-400 uppercase tracking-[0.2em] mb-8">Secure Mobile Money Payments</h3>
            <div class="flex justify-center items-center gap-16">
                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/a/af/MTN_Logo.svg/1024px-MTN_Logo.svg.png" class="h-14 w-auto grayscale opacity-40 hover:grayscale-0 hover:opacity-100 transition-all duration-300">
                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/3a/Airtel_logo_2010.svg/1024px-Airtel_logo_2010.svg.png" class="h-10 w-auto grayscale opacity-40 hover:grayscale-0 hover:opacity-100 transition-all duration-300">
            </div>
            <p class="mt-8 text-xs font-bold text-gray-400 italic">Fast, secure, and reliable processing via MTN MoMo & Airtel Money</p>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/membership/index.blade.php ENDPATH**/ ?>