<?php $__env->startSection('title', 'Privacy Policy - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pt-20 pb-20">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <!-- Header -->
            <div class="text-center mb-12">
                <h1 class="text-4xl font-black text-charcoal-gray mb-4">Privacy Policy</h1>
                <p class="text-cool-gray font-bold uppercase tracking-widest text-sm">Official Corporate Policy | Last Updated: January 1, 2026</p>
                <div class="w-20 h-1.5 bg-primary rounded-full mx-auto mt-6"></div>
            </div>

            <!-- Content Card -->
            <div class="bg-white rounded-[32px] shadow-sm border border-gray-100 p-8 md:p-12 prose prose-emerald max-w-none">
                <p class="lead text-lg text-cool-gray font-medium">This Privacy Policy ("Policy") details how Yilick Marketplace Limited ("Company," "we," "us," or "our") collects, protects, and utilizes the personal and technical data of Users across our Platform. We are committed to maintaining the highest standards of data security while facilitating a transparent marketplace environment.</p>

                <div class="space-y-16 mt-16">
                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-6 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">01</span>
                            DATA CONTROLLER & SCOPE
                        </h3>
                        <div class="pl-11 space-y-6">
                            <p><strong>1.1 Controller Identification:</strong> Yilick Marketplace Limited, a company registered in the Republic of Uganda, is the primary controller of your personal data processed through the Platform. Our operations are governed by the Data Protection and Privacy Act of Uganda.</p>
                            <p><strong>1.2 Applicability:</strong> This Policy applies to all Users, including buyers, sellers, and individuals applying for career opportunities through the Yilick Careers portal. By using the Platform, you acknowledge the collection and processing of data as described herein.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-6 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">02</span>
                            CATEGORIES OF DATA COLLECTED
                        </h3>
                        <div class="pl-11 space-y-6">
                            <p><strong>2.1 Voluntary Information:</strong> We collect data you provide directly, including your name, phone number, email address, gender, date of birth, and physical business location. For sellers, this includes shop branding and listing descriptions.</p>
                            <p><strong>2.2 Career Applicant Data:</strong> If you apply for a position via our Careers portal, we collect your Curriculum Vitae (CV), professional history, education details, and any supporting documentation provided for recruitment evaluation.</p>
                            <p><strong>2.3 Automated Metadata:</strong> We automatically log identifiers such as IP addresses, device hardware specifications, OS versions, browser fingerprints, and high-frequency clickstream data to optimize performance and detect bot activity.</p>
                            <p><strong>2.4 Media & AI Processing:</strong> All images and videos uploaded to the Platform are processed by our AI algorithms to identify objects, detect prohibited content, and generate technical signatures for search optimization. Media may be stored with embedded EXIF data unless stripped by the User.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-6 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">03</span>
                            PURPOSE OF DATA PROCESSING
                        </h3>
                        <div class="pl-11 space-y-6">
                            <p>We process your information for the following mandatory business purposes:</p>
                            <ul class="list-disc pl-6 space-y-2">
                                <li>To facilitate communication and transactions between Buyers and Sellers.</li>
                                <li>To verify account authenticity and detect/prevent fraudulent "SafeTrade" requests.</li>
                                <li>To personalize your marketplace experience through AI-driven recommendations.</li>
                                <li>To analyze marketplace trends and improve the Yilick software architecture.</li>
                                <li>To comply with statutory legal requirements and law enforcement mandates.</li>
                            </ul>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-6 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">04</span>
                            DATA SHARING & DISCLOSURE
                        </h3>
                        <div class="pl-11 space-y-6">
                            <p><strong>4.1 Public Disclosure:</strong> Information provided in your public profile and listings (e.g., phone number, name) will be visible to other Users to facilitate commerce.</p>
                            <p><strong>4.2 Third-Party Providers:</strong> We share data with secure infrastructure providers (cloud hosting, SMS gateways, and payment processors) under strict confidentiality agreements.</p>
                            <p><strong>4.3 Law Enforcement:</strong> We reserve the right to disclose personal data to regulatory bodies or law enforcement agencies when necessitated by a valid legal process or to protect the safety of our User community.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-6 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">05</span>
                            RETENTION & DELETION
                        </h3>
                        <div class="pl-11 space-y-6">
                            <p>Personal data is stored only for as long as necessary to provide Services, resolve disputes, and comply with legal obligations. Upon account termination, your data will be archived or anonymized in accordance with our internal data retention schedule unless a deletion request is formally submitted and verified.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-6 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">06</span>
                            USER RIGHTS & ACCOUNTABILITY
                        </h3>
                        <div class="pl-11 space-y-6">
                            <p>In accordance with the Data Protection and Privacy Act, you have the right to access, review, and correct your personal information. Users are responsible for the accuracy of the data provided. Inaccurate or falsified data may lead to immediate account suspension to protect the integrity of the Platform.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-6 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">07</span>
                            POLICY MODIFICATIONS
                        </h3>
                        <div class="pl-11 space-y-6">
                            <p>The Company may revise this Policy periodically to reflect technological advancements or regulatory changes. Continued use of the Platform after such modifications constitutes acceptance of the updated Policy.</p>
                        </div>
                    </section>
                </div>
            </div>

            <!-- Footer Note -->
            <div class="mt-12 text-center text-cool-gray text-sm">
                <p>&copy; <?php echo e(date('Y')); ?> Yilick. All rights reserved.</p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/privacy.blade.php ENDPATH**/ ?>