<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Invitation</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #1f2937;
            background-color: #f9fafb;
        }
        .email-container { max-width: 600px; margin: 0 auto; background-color: #ffffff; }
        .header {
            background: #111827;
            padding: 32px 24px;
            text-align: center;
        }
        .header h1 { color: #ffffff; font-size: 22px; font-weight: 700; margin-bottom: 8px; }
        .header p { color: #e5e7eb; font-size: 14px; }
        .content { padding: 28px 24px; }
        .greeting { font-size: 18px; font-weight: 600; margin-bottom: 16px; color: #111827; }
        .message { font-size: 15px; color: #374151; margin-bottom: 16px; line-height: 1.8; }
        .box {
            background: #f3f4f6;
            border: 1px solid #e5e7eb;
            border-radius: 10px;
            padding: 16px;
            margin: 18px 0;
        }
        .label { font-size: 12px; color: #6b7280; text-transform: uppercase; letter-spacing: .06em; margin-bottom: 6px; }
        .value { font-size: 15px; color: #111827; font-weight: 600; }
        .token {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, 'Liberation Mono', 'Courier New', monospace;
            font-size: 13px;
            background: #111827;
            color: #ffffff;
            padding: 10px 12px;
            border-radius: 8px;
            overflow-wrap: anywhere;
        }
        .footer {
            padding: 18px 24px;
            border-top: 1px solid #e5e7eb;
            color: #6b7280;
            font-size: 12px;
        }
        .muted { color: #6b7280; font-size: 13px; }
    </style>
</head>
<body>
<div class="email-container">
    <div class="header">
        <h1>Business Invitation</h1>
        <p><?php echo e(config('app.name')); ?></p>
    </div>

    <div class="content">
        <div class="greeting">Hi <?php echo e($invitee->full_name ?? $invitee->email); ?>,</div>

        <div class="message">
            <strong><?php echo e($inviter->full_name ?? $inviter->email); ?></strong> invited you to help manage the business
            <strong><?php echo e($business->name); ?></strong>.
        </div>

        <div class="box">
            <div class="label">Role</div>
            <div class="value"><?php echo e($invite->role); ?></div>
        </div>

        <div class="box">
            <div class="label">Invitation Token</div>
            <div class="token"><?php echo e($invite->token); ?></div>
            <?php if($invite->expires_at): ?>
                <div class="muted" style="margin-top: 10px;">Expires: <?php echo e($invite->expires_at->toDayDateTimeString()); ?></div>
            <?php endif; ?>
        </div>

        <div class="message">
            To accept this invite, click the button below or copy the token if prompted in the app.
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="<?php echo e(route('web.invitation.accept', $invite->token)); ?>" style="background-color: #10B981; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">
                Accept Invitation
            </a>
        </div>

        <div class="muted">
            If you did not expect this invitation, you can safely ignore this email.
        </div>
    </div>

    <div class="footer">
        © <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>

    </div>
</div>
</body>
</html>
<?php /**PATH /home/yilickapp/website/resources/views/emails/business-invitation.blade.php ENDPATH**/ ?>