<?php $__env->startSection('title', 'Business Links'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 pb-20 font-sans selection:bg-primary/20">
    <div class="container mx-auto px-4 py-6 max-w-2xl">
        <!-- Header -->
        <div class="flex items-center mb-6">
            <a href="<?php echo e(route('web.settings')); ?>" class="mr-4 w-10 h-10 bg-white rounded-xl shadow-sm border border-gray-100 flex items-center justify-center text-gray-600 hover:text-primary hover:border-primary/20 transition-all">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-900">Business Links</h1>
        </div>

        <!-- Success Message -->
        <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-xl flex items-center gap-3">
            <i class="fa-solid fa-check-circle"></i>
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>

        <!-- Error Message -->
        <?php if($errors->any()): ?>
        <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-xl">
             <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <!-- Navigation Tabs -->
        <div class="flex gap-2 overflow-x-auto pb-4 mb-2 no-scrollbar">
            <a href="<?php echo e(route('web.business.edit')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.edit') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                Details
            </a>
            <a href="<?php echo e(route('web.business.links')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.links') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Links
            </a>
            <a href="<?php echo e(route('web.business.branding')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.branding') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Branding
            </a>
            <a href="<?php echo e(route('web.business.number.edit', ['type' => 'phone'])); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(request()->route('type') == 'phone' ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Phone
            </a>
             <a href="<?php echo e(route('web.business.members')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.members') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Members
            </a>
        </div>

        <form action="<?php echo e(route('web.business.links.update')); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
            
            <!-- Info Box -->
            <div class="bg-primary/5 rounded-2xl p-4 border border-primary/10 flex gap-4 shadow-sm shadow-primary/5">
                <div class="w-10 h-10 rounded-full bg-primary flex-shrink-0 flex items-center justify-center text-white shadow-sm">
                    <i class="fa-solid fa-link text-sm"></i>
                </div>
                <div class="text-xs font-medium text-gray-600 leading-relaxed">
                    Add your website and social media links to help customers connect with you online.
                </div>
            </div>

            <!-- Form Fields -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 space-y-6">
                <!-- Website -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Website</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-solid fa-globe text-gray-400"></i>
                        </div>
                        <input type="url" name="website" value="<?php echo e(old('website', $business->website)); ?>"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="https://example.com">
                    </div>
                    <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Facebook -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Facebook</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-brands fa-facebook text-gray-400"></i>
                        </div>
                        <input type="url" name="facebook_url" value="<?php echo e(old('facebook_url', $business->facebook_url)); ?>"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="https://facebook.com/yourpage">
                    </div>
                    <?php $__errorArgs = ['facebook_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Instagram -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Instagram</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-brands fa-instagram text-gray-400"></i>
                        </div>
                        <input type="url" name="instagram_url" value="<?php echo e(old('instagram_url', $business->instagram_url)); ?>"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="https://instagram.com/yourprofile">
                    </div>
                    <?php $__errorArgs = ['instagram_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Twitter -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Twitter</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-brands fa-twitter text-gray-400"></i>
                        </div>
                        <input type="url" name="twitter_url" value="<?php echo e(old('twitter_url', $business->twitter_url)); ?>"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="https://twitter.com/yourhandle">
                    </div>
                    <?php $__errorArgs = ['twitter_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- LinkedIn -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">LinkedIn</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-brands fa-linkedin text-gray-400"></i>
                        </div>
                        <input type="url" name="linkedin_url" value="<?php echo e(old('linkedin_url', $business->linkedin_url)); ?>"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="https://linkedin.com/company/yourcompany">
                    </div>
                    <?php $__errorArgs = ['linkedin_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- TikTok -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">TikTok</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-brands fa-tiktok text-gray-400"></i>
                        </div>
                        <input type="url" name="tiktok_url" value="<?php echo e(old('tiktok_url', $business->tiktok_url)); ?>"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="https://tiktok.com/@youraccount">
                    </div>
                    <?php $__errorArgs = ['tiktok_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- YouTube -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">YouTube</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-brands fa-youtube text-gray-400"></i>
                        </div>
                        <input type="url" name="youtube_url" value="<?php echo e(old('youtube_url', $business->youtube_url)); ?>"
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="https://youtube.com/@yourchannel">
                    </div>
                    <?php $__errorArgs = ['youtube_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full py-4 bg-primary hover:bg-primary-dark text-white rounded-xl font-bold text-base shadow-lg shadow-primary/20 transition-all transform active:scale-[0.98]">
                Update Business Links
            </button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/business/links.blade.php ENDPATH**/ ?>