<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'Yilick')); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Styles -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <style>
        :root {
            --primary: #10b981;
            --primary-dark: #059669;
            --primary-light: #d1fae5;
        }
        
        /* FOUC Cloak: Content is hidden until styles load */
        body { 
            opacity: 0;
            font-family: 'Plus Jakarta Sans', sans-serif; 
            -webkit-tap-highlight-color: transparent; 
            overscroll-behavior-y: none;
            background-color: #f9fafb;
            transition: opacity 0.3s ease-in-out;
        }
        
        body.is-ready {
            opacity: 1;
        }

        .pb-safe { padding-bottom: env(safe-area-inset-bottom); }
        
        /* Smooth Fade In Animation */
        .fade-up {
            animation: fadeUp 0.6s cubic-bezier(0.16, 1, 0.3, 1) forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        @keyframes fadeUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .delay-1 { animation-delay: 0.1s; }
        .delay-2 { animation-delay: 0.2s; }
        .delay-3 { animation-delay: 0.3s; }

        /* Premium Card Interaction */
        .active-scale:active {
            transform: scale(0.97);
        }
    </style>
</head>
<body class="bg-[#f9fafb] text-gray-900 antialiased selection:bg-emerald-100 selection:text-emerald-700">
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <!-- Fast Reveal Script to prevent FOUC -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             document.body.classList.add('is-ready');
        });
        // Fallback for safety
        window.onload = () => document.body.classList.add('is-ready');
    </script>
</body>
</html>
<?php /**PATH /home/yilickapp/website/resources/views/layouts/mobile.blade.php ENDPATH**/ ?>