<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Access Update</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #1f2937;
            background-color: #f9fafb;
        }
        .email-container { max-width: 600px; margin: 0 auto; background-color: #ffffff; }
        .header {
            background: #111827;
            padding: 32px 24px;
            text-align: center;
        }
        .header h1 { color: #ffffff; font-size: 22px; font-weight: 700; margin-bottom: 8px; }
        .header p { color: #e5e7eb; font-size: 14px; }
        .content { padding: 28px 24px; }
        .greeting { font-size: 18px; font-weight: 600; margin-bottom: 16px; color: #111827; }
        .message { font-size: 15px; color: #374151; margin-bottom: 16px; line-height: 1.8; }
        .footer {
            padding: 18px 24px;
            border-top: 1px solid #e5e7eb;
            color: #6b7280;
            font-size: 12px;
        }
    </style>
</head>
<body>
<div class="email-container">
    <div class="header">
        <h1>Access Update</h1>
        <p><?php echo e(config('app.name')); ?></p>
    </div>

    <div class="content">
        <div class="greeting">Hi <?php echo e($user->name ?? $user->email); ?>,</div>

        <?php if($selfRemoved): ?>
        <div class="message">
            You have successfully removed yourself from managing <strong><?php echo e($business->name); ?></strong>.
            You will no longer see this business in your dashboard.
        </div>
        <?php else: ?>
        <div class="message">
            Your access to manage <strong><?php echo e($business->name); ?></strong> has been removed by the business owner.
        </div>
        <?php endif; ?>

        <div class="message">
            If you need to regain access, you will need to be invited again by the owner.
        </div>
    </div>

    <div class="footer">
        © <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>

    </div>
</div>
</body>
</html>
<?php /**PATH /home/yilickapp/website/resources/views/emails/business-member-removed.blade.php ENDPATH**/ ?>