<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['listing' => null, 'boosted' => false]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['listing' => null, 'boosted' => false]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<div class="group relative bg-white border border-gray-100 rounded-none overflow-hidden hover:shadow-md transition-all duration-300 cursor-pointer h-full flex flex-col" style="box-shadow: rgba(0, 0, 0, 0.05) 0px 2px 4px 0px;">
    <!-- Image Container -->
    <div class="aspect-[4/3] bg-gray-50 relative overflow-hidden">
        <?php if($listing && $listing->media->isNotEmpty()): ?>
            <img src="<?php echo e($listing->media->first()->url); ?>" 
                 alt="<?php echo e($listing->title); ?> for sale in <?php echo e($listing->location_district ?? 'Uganda'); ?> - Yilick" 
                 onerror="this.onerror=null; this.src='/assets/icons/listing_placeholder.svg'"
                 class="w-full h-full object-cover">
        <?php else: ?>
            <div class="w-full h-full flex items-center justify-center bg-gray-50 text-gray-300">
                <i class="fa-regular fa-image text-3xl"></i>
            </div>
        <?php endif; ?>

        <?php if($boosted): ?>
            <div class="absolute top-2 left-2 z-10">
                <span class="inline-flex items-center px-1.5 py-0.5 bg-[#28a745] text-white text-[10px] font-bold uppercase rounded-sm shadow-sm">
                    Featured
                </span>
            </div>
        <?php endif; ?>

        <!-- Favorite Action -->
        <?php
            $isFavorited = $listing ? $listing->isFavoritedBy(Auth::guard('web')->user()) : false;
        ?>
        <button 
            type="button"
            onclick="event.stopPropagation(); event.preventDefault(); toggleFavoriteGlobal(this, 'listing', <?php echo e($listing->id ?? 0); ?>)"
            class="absolute top-2 right-2 w-7 h-7 rounded-sm bg-white/90 backdrop-blur-sm hover:bg-white <?php echo e($isFavorited ? 'text-red-500' : 'text-gray-400'); ?> hover:text-red-500 shadow-sm flex items-center justify-center transition-all z-10 favorite-btn"
            data-active="<?php echo e($isFavorited ? 'true' : 'false'); ?>">
            <i class="<?php echo e($isFavorited ? 'fa-solid' : 'fa-regular'); ?> fa-heart text-xs"></i>
        </button>
    </div>

    <!-- Content Details -->
    <div class="p-3 flex flex-col flex-grow">
        <!-- Title -->
        <h3 class="text-[14px] font-medium text-[#333333] line-clamp-2 leading-tight mb-2 h-[34px]">
            <?php echo e($listing->title); ?>

        </h3>

        <!-- Price -->
        <div class="mb-2">
            <span class="text-[15.2px] font-semibold text-[#28a745]">
                <?php echo e($listing?->price_amount ? number_format($listing->price_amount) : '0'); ?> UGX
            </span>
        </div>

        <!-- Location (Bottom) -->
        <div class="mt-auto pt-2 border-t border-gray-50 flex items-center gap-1 text-[#666666]">
            <i class="fa-solid fa-location-dot text-[10px] opacity-60"></i>
            <span class="text-[12px] font-normal truncate"><?php echo e($listing->location_district ?? 'Kampala'); ?></span>
        </div>
    </div>

    <?php if($listing): ?>
        <a href="<?php echo e(route('listing.share', $listing->slug)); ?>" class="absolute inset-0 z-0" aria-label="View <?php echo e($listing->title); ?>"></a>
    <?php endif; ?>
</div>
<?php /**PATH /home/yilickapp/website/resources/views/components/listing-card.blade.php ENDPATH**/ ?>