<?php $__env->startSection('title', $business->name . ' - Verified Store in ' . ($business->district ?? 'Uganda') . ' | Yilick'); ?>
<?php $__env->startSection('meta_description', Str::limit($business->description ?? 'Visit ' . $business->name . ' on Yilick to browse their latest items, reviews, and verified business details in ' . ($business->district ?? 'Uganda') . '.', 160)); ?>
<?php $__env->startSection('meta_keywords', $business->name . ', ' . ($business->business_category ?? 'shop') . ' ' . ($business->district ?? 'uganda') . ', verified seller yilick, buy and sell kampala'); ?>
<?php $__env->startSection('og_image', $business->logo_url ?? asset('assets/icons/logo.png')); ?>

<?php $__env->startSection('header_meta'); ?>
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "<?php echo e($business->name); ?>",
    "description": "<?php echo e(Str::limit(strip_tags($business->description), 200)); ?>",
    "image": "<?php echo e($business->logo_url ?? asset('assets/icons/logo.png')); ?>",
    "address": {
        "@type": "PostalAddress",
        "streetAddress": "<?php echo e($business->address ?? ''); ?>",
        "addressLocality": "<?php echo e($business->district ?? 'Uganda'); ?>",
        "addressCountry": "UG"
    },
    "telephone": "<?php echo e($business->primary_phone ?? ''); ?>",
    "url": "<?php echo e(url()->current()); ?>",
    "priceRange": "$$",
    "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "5.0",
        "reviewCount": "<?php echo e(max(1, $business->feedbacks_count ?? 0)); ?>"
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pb-12">
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <!-- Hero Section -->
    <div class="relative bg-slate-50 border-b border-gray-200 pb-12 pt-12 overflow-hidden">
        <!-- Modern Dot Pattern -->
        <div class="absolute inset-0 opacity-[0.4]" style="background-image: radial-gradient(#cbd5e1 1px, transparent 1px); background-size: 24px 24px;"></div>
        
        <div class="container mx-auto px-4 max-w-7xl relative">
            <div class="flex flex-col md:flex-row md:items-start gap-8 md:gap-10">
                <!-- Profile Image -->
                <div class="relative flex-shrink-0 mx-auto md:mx-0">
                    <div class="w-32 h-32 md:w-40 md:h-40 rounded-2xl border-4 border-white shadow-xl overflow-hidden bg-white ring-1 ring-black/5">
                        <img src="<?php echo e($business->logo_url ?? 'https://ui-avatars.com/api/?name='.urlencode($business->name).'&background=f3f4f6&color=374151&size=256'); ?>" 
                             alt="<?php echo e($business->name); ?>" 
                             onerror="this.src='<?php echo e(asset('assets/icons/favicon.png')); ?>'"
                             class="w-full h-full object-cover">
                    </div>
                </div>

                <!-- Business Info -->
                <div class="flex-1 w-full text-center md:text-left pt-2">
                    <div class="flex flex-col lg:flex-row lg:justify-between gap-6">
                        <div class="space-y-4">
                            <!-- Name & Verification -->
                            <div class="flex flex-col md:flex-row items-center md:items-start gap-2 md:gap-4">
                                <h1 class="text-3xl md:text-5xl font-black text-slate-900 tracking-tight">
                                    <?php echo e($business->name); ?>

                                </h1>
                                <?php if($business->isVerified()): ?>
                                    <div class="mt-2 md:mt-1 bg-white text-blue-600 px-3 py-1 rounded-full text-xs font-bold flex items-center gap-1.5 border border-blue-100 shadow-sm shrink-0">
                                        <i class="fa-solid fa-certificate"></i>
                                        <span>Verified Seller</span>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Meta Info -->
                            <div class="flex flex-wrap items-center justify-center md:justify-start gap-x-4 gap-y-2 text-sm text-slate-500 font-medium">
                                <span class="bg-white px-3 py-1 rounded-md text-slate-700 border border-slate-200 shadow-sm"><?php echo e($business->business_category ?? 'Business'); ?></span>
                                <span class="hidden md:inline text-slate-300">•</span>
                                <span class="flex items-center gap-1.5"><i class="fa-solid fa-location-dot text-slate-400"></i> <?php echo e($business->district ?? 'Uganda'); ?></span>
                                <span class="hidden md:inline text-slate-300">•</span>
                                <span>Joined <?php echo e($business->created_at->format('M Y')); ?></span>
                            </div>
                            
                            <!-- Stats Cards -->
                            <div class="flex items-center justify-center md:justify-start gap-3 pt-3">
                                <div class="bg-white px-4 py-2 rounded-xl border border-slate-200 shadow-sm flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-full bg-emerald-50 flex items-center justify-center text-emerald-600">
                                        <i class="fa-solid fa-layer-group text-sm"></i>
                                    </div>
                                    <div class="text-left">
                                        <span class="block text-sm font-bold text-slate-900 leading-none"><?php echo e($business->listings_count); ?></span>
                                        <span class="text-[10px] text-slate-500 uppercase font-bold tracking-wider">Ads</span>
                                    </div>
                                </div>

                                <div class="bg-white px-4 py-2 rounded-xl border border-slate-200 shadow-sm flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
                                        <i class="fa-solid fa-users text-sm"></i>
                                    </div>
                                    <div class="text-left">
                                        <span class="block text-sm font-bold text-slate-900 leading-none"><?php echo e($business->followers_count); ?></span>
                                        <span class="text-[10px] text-slate-500 uppercase font-bold tracking-wider">Fans</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="flex flex-col sm:flex-row gap-3 items-center lg:items-start pt-4 lg:pt-0">
                             <?php if($business->primary_whatsapp): ?>
                            <a href="https://wa.me/<?php echo e(preg_replace('/[^0-9]/', '', $business->primary_whatsapp)); ?>?text=<?php echo e(urlencode('Hi, I am interested in your products. ' . url()->current())); ?>" target="_blank" class="w-full sm:w-auto px-6 py-3.5 bg-[#25D366] text-white text-sm font-bold rounded-xl hover:bg-[#128C7E] transition-all shadow-lg shadow-green-200 flex items-center justify-center gap-2 transform active:scale-95">
                                <i class="fa-brands fa-whatsapp text-lg"></i>
                                <span>Chat on WhatsApp</span>
                            </a>
                            <?php endif; ?>
                            
                            <?php if($business->primary_phone): ?>
                            <a href="javascript:void(0)" 
                               onclick="showBusinessPhone(event, this, '<?php echo e($business->primary_phone); ?>')"
                               class="w-full sm:w-auto px-6 py-3.5 bg-white text-slate-900 text-sm font-bold rounded-xl border border-gray-200 hover:bg-gray-50 transition-all shadow-sm flex items-center justify-center gap-2 group">
                                <i class="fa-regular fa-eye text-slate-400 group-hover:text-emerald-600 transition-colors"></i>
                                <span>Show Contact</span>
                            </a>
                            <?php endif; ?>

                             <button 
                                type="button"
                                onclick="toggleFavoriteGlobal(this, 'business', <?php echo e($business->id); ?>)"
                                data-active="<?php echo e(Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'true' : 'false'); ?>"
                                class="w-full sm:w-auto px-6 py-3.5 bg-white text-sm font-bold rounded-xl border <?php echo e(Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'border-primary bg-primary/5 text-primary' : 'border-gray-200 text-slate-900'); ?> hover:bg-gray-50 transition-all shadow-sm flex items-center justify-center gap-2 group favorite-btn">
                                <i class="<?php echo e(Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'fa-solid' : 'fa-regular'); ?> fa-heart <?php echo e(Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'text-primary' : 'text-slate-400 group-hover:text-red-500'); ?> transition-colors"></i>
                                <span><?php echo e(Auth::guard('web')->user() && $business->isFavoritedBy(Auth::guard('web')->user()) ? 'Following' : 'Follow Shop'); ?></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        function showBusinessPhone(event, element, phoneNumber) {
            // Prevent immediate navigation/call
            event.preventDefault();

            // Update href to allow calling on NEXT click
            element.href = 'tel:' + phoneNumber;
            
            // Update Icon
            const icon = element.querySelector('i');
            if (icon) {
                icon.className = 'fa-solid fa-phone text-white';
            }
            
            // Update Text
            const textSpan = element.querySelector('span');
            if (textSpan) {
                textSpan.textContent = phoneNumber;
            }
            
            // Update Style to indicate it's now active/calling
            // Switch to Green for 'Call' action (cleaner UI)
            element.classList.remove('bg-white', 'text-slate-900', 'border-gray-200', 'hover:bg-gray-50');
            element.classList.add('bg-emerald-600', 'text-white', 'border-emerald-500', 'hover:bg-emerald-700');

            // Remove onclick so next click triggers href normally
            element.removeAttribute('onclick');
        }
    </script>
    <?php $__env->stopPush(); ?>


    
    <!-- Tab Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('[data-tab-target]');
            const contents = document.querySelectorAll('[data-tab-content]');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    // Reset active state
                    tabs.forEach(t => {
                        t.classList.remove('border-primary', 'text-primary');
                        t.classList.add('border-transparent', 'text-gray-500');
                    });
                    contents.forEach(c => c.classList.add('hidden'));

                    // Set new active state
                    tab.classList.remove('border-transparent', 'text-gray-500');
                    tab.classList.add('border-primary', 'text-primary');
                    
                    const target = document.querySelector(tab.dataset.tabTarget);
                    target.classList.remove('hidden');
                });
            });
        });
    </script>
    
    <!-- Navigation Tabs (Vanilla Version) -->
    <div class="bg-white border-b border-gray-200 sticky top-16 md:top-20 z-30 shadow-sm">
         <div class="container mx-auto px-4 max-w-7xl">
            <nav class="flex space-x-8" aria-label="Tabs">
                <button data-tab-target="#tab-items" 
                        class="border-primary text-primary whitespace-nowrap py-4 px-1 border-b-2 font-bold text-sm flex items-center gap-2 transition-colors">
                    <i class="fa-solid fa-layer-group"></i> Items
                </button>

                <button data-tab-target="#tab-reviews" 
                        class="border-transparent text-gray-500 hover:text-gray-700 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm flex items-center gap-2 transition-colors">
                    <i class="fa-regular fa-star"></i> Reviews <span class="bg-gray-100 text-gray-600 py-0.5 px-2 rounded-full text-xs ml-1"><?php echo e($business->feedbacks_count); ?></span>
                </button>
            </nav>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container mx-auto px-4 max-w-7xl mt-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
            
            <!-- Sidebar (Sticky) -->
            <div class="hidden md:block col-span-1">
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-5 sticky top-40">
                    <h3 class="font-bold text-gray-900 mb-4">Store Details</h3>
                    
                    <div class="space-y-4 text-sm">
                        <?php if($business->description): ?>
                        <p class="text-gray-600 mb-4 leading-relaxed"><?php echo e($business->description); ?></p>
                        <hr class="border-gray-100 mb-4">
                        <?php endif; ?>

                         <?php if($business->address): ?>
                        <div class="flex items-start gap-3">
                            <i class="fa-solid fa-map-location-dot text-gray-400 mt-1"></i>
                            <span class="text-gray-600"><?php echo e($business->address); ?></span>
                        </div>
                        <?php endif; ?>

                        <div class="flex items-center gap-3">
                            <i class="fa-regular fa-clock text-gray-400"></i>
                            <span class="text-green-600 font-medium">Open Now</span> 
                        </div>

                        <hr class="border-gray-100">
                        
                        <div class="flex gap-4 justify-center pt-2">
                             <?php if($business->facebook_url): ?>
                                <a href="<?php echo e($business->facebook_url); ?>" class="text-gray-400 hover:text-[#1877F2] transition-colors"><i class="fa-brands fa-facebook text-xl"></i></a>
                            <?php endif; ?>
                            <?php if($business->instagram_url): ?>
                                <a href="<?php echo e($business->instagram_url); ?>" class="text-gray-400 hover:text-[#E4405F] transition-colors"><i class="fa-brands fa-instagram text-xl"></i></a>
                            <?php endif; ?>
                             <?php if($business->tiktok_url): ?>
                                <a href="<?php echo e($business->tiktok_url); ?>" class="text-gray-400 hover:text-black transition-colors"><i class="fa-brands fa-tiktok text-xl"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content Area -->
            <div class="col-span-1 md:col-span-3">
                
                <!-- ITEMS TAB -->
                <div id="tab-items" data-tab-content>
                    <!-- Search/Filter Bar -->
                    <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4 mb-6">
                        <h2 class="text-xl font-bold text-gray-900">Latest from <?php echo e($business->name); ?></h2>
                        <!-- Search Input -->
                        <form action="<?php echo e(route('business.show', $business->slug)); ?>" method="GET" class="relative w-full sm:w-64">
                            <input type="text" 
                                   name="q"
                                   value="<?php echo e(request('q')); ?>"
                                   placeholder="Search in this store..." 
                                   class="w-full pl-9 pr-4 py-2 border border-gray-200 rounded-lg text-sm focus:border-primary focus:ring-1 focus:ring-primary outline-none shadow-sm">
                            <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 text-xs"></i>
                        </form>
                    </div>
    
                    <?php if($listings->count() > 0): ?>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4 md:gap-6">
                            <?php $__currentLoopData = $listings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <?php if (isset($component)) { $__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.listing-card','data' => ['listing' => $listing]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('listing-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['listing' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($listing)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce)): ?>
<?php $attributes = $__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce; ?>
<?php unset($__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce)): ?>
<?php $component = $__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce; ?>
<?php unset($__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce); ?>
<?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
    
                        <div class="mt-8">
                            <?php echo e($listings->links('vendor.pagination.yilick')); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-20 bg-white rounded-xl border border-gray-100 border-dashed">
                            <div class="w-16 h-16 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fa-regular fa-box-open text-gray-300 text-2xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-900">No items available</h3>
                            <p class="text-gray-500 mt-1">This store hasn't posted any listings yet.</p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- REVIEWS TAB -->
                <div id="tab-reviews" class="hidden" data-tab-content>
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-xl font-bold text-gray-900">Customer Feedback</h2>
                        <!-- Placeholder for "Write Review" button if auth -->
                    </div>

                    <?php $__empty_1 = true; $__currentLoopData = $feedbacks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feedback): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="bg-white rounded-xl border border-gray-100 p-5 mb-4 shadow-sm hover:shadow-md transition-shadow">
                        <div class="flex items-start gap-4">
                            <!-- User Avatar -->
                            <img src="<?php echo e($feedback->user->profile_photo ? $feedback->user->profile_photo_url : 'https://ui-avatars.com/api/?name='.urlencode($feedback->user->full_name ?? 'User').'&background=random'); ?>" 
                                 class="w-10 h-10 rounded-full object-cover border border-gray-100" 
                                 onerror="this.src='<?php echo e(asset('assets/icons/favicon.png')); ?>'"
                                 alt="User">
                            
                            <div class="flex-1">
                                <!-- Name and Date -->
                                <div class="flex justify-between items-start">
                                    <div>
                                        <h4 class="font-bold text-gray-900 text-sm"><?php echo e($feedback->user->full_name ?? 'Anonymous'); ?></h4>
                                        <span class="text-xs text-gray-400"><?php echo e($feedback->created_at->diffForHumans()); ?></span>
                                    </div>
                                    <!-- Sentiment Badge -->
                                    <?php if($feedback->sentiment === 'positive'): ?>
                                        <span class="bg-green-50 text-green-700 text-xs px-2 py-1 rounded-full font-bold border border-green-100 flex items-center gap-1">
                                            <i class="fa-solid fa-thumbs-up"></i> Recommended
                                        </span>
                                    <?php elseif($feedback->sentiment === 'negative'): ?>
                                        <span class="bg-red-50 text-red-700 text-xs px-2 py-1 rounded-full font-bold border border-red-100 flex items-center gap-1">
                                            <i class="fa-solid fa-thumbs-down"></i> Not Recommended
                                        </span>
                                    <?php else: ?>
                                        <span class="bg-gray-100 text-gray-600 text-xs px-2 py-1 rounded-full font-bold border border-gray-200">
                                            Neutral
                                        </span>
                                    <?php endif; ?>
                                </div>

                                <!-- Message -->
                                <div class="mt-2 text-gray-700 text-sm leading-relaxed">
                                    <?php echo e($feedback->message); ?>

                                </div>
                                
                                <!-- Attachments (Images) -->
                                <?php if($feedback->attachments->count() > 0): ?>
                                    <div class="flex gap-2 mt-3 overflow-x-auto pb-2">
                                        <?php $__currentLoopData = $feedback->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <button onclick="openLightbox('<?php echo e(config('app.url')); ?>/storage/<?php echo e($attachment->path); ?>')" class="shrink-0 focus:outline-none">
                                                <img src="<?php echo e(config('app.url')); ?>/storage/<?php echo e($attachment->path); ?>" class="w-16 h-16 object-cover rounded-lg border border-gray-200 hover:opacity-90 transition-opacity">
                                            </button>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Business Response -->
                                <?php $__currentLoopData = $feedback->responses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $response): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="mt-4 bg-gray-50 rounded-lg p-3 border border-gray-100">
                                        <div class="flex items-center gap-2 mb-1">
                                            <i class="fa-solid fa-store text-primary text-xs"></i>
                                            <span class="font-bold text-xs text-gray-900">Store Response</span>
                                            <span class="text-[10px] text-gray-400">• <?php echo e($response->created_at->diffForHumans()); ?></span>
                                        </div>
                                        <p class="text-xs text-gray-600"><?php echo e($response->message); ?></p>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-16 bg-white rounded-xl border border-gray-100 border-dashed">
                        <div class="w-12 h-12 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fa-regular fa-comment-dots text-gray-300 text-xl"></i>
                        </div>
                        <h3 class="text-sm font-medium text-gray-900">No reviews yet</h3>
                        <p class="text-xs text-gray-500 mt-1">Be the first to share your experience with this seller.</p>
                    </div>
                    <?php endif; ?>
                </div>

            </div>
            
        </div>
    </div>
</div>

<!-- Lightbox Modal -->
<div id="lightbox-modal" class="fixed inset-0 z-[60] bg-black/90 hidden items-center justify-center p-4 backdrop-blur-sm transition-opacity opacity-0" 
     onclick="closeLightbox()">
    <!-- Close Button -->
    <button onclick="closeLightbox()" class="absolute top-4 right-4 text-white/70 hover:text-white p-2">
        <i class="fa-solid fa-xmark text-4xl"></i>
    </button>
    
    <!-- Image -->
    <img id="lightbox-image" src="" class="max-w-full max-h-[90vh] rounded-lg shadow-2xl transform scale-95 transition-transform duration-300" onclick="event.stopPropagation()">
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function openLightbox(imageUrl) {
        const modal = document.getElementById('lightbox-modal');
        const img = document.getElementById('lightbox-image');
        
        img.src = imageUrl;
        modal.classList.remove('hidden');
        // Small timeout to allow display:block to apply before opacity transition
        setTimeout(() => {
            modal.classList.remove('opacity-0');
            img.classList.remove('scale-95');
            img.classList.add('scale-100');
        }, 10);
        
        document.body.style.overflow = 'hidden'; // Prevent scrolling
    }

    function closeLightbox() {
        const modal = document.getElementById('lightbox-modal');
        const img = document.getElementById('lightbox-image');
        
        modal.classList.add('opacity-0');
        img.classList.remove('scale-100');
        img.classList.add('scale-95');
        
        setTimeout(() => {
            modal.classList.add('hidden');
            img.src = '';
        }, 300);
        
        document.body.style.overflow = '';
    }

    // Close on Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeLightbox();
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/business-details.blade.php ENDPATH**/ ?>