<?php $__env->startSection('title', 'Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 pb-20 font-sans selection:bg-primary/20">
    <div class="container mx-auto px-4 py-6 max-w-2xl relative">
        <!-- Loading Overlay -->
        <div id="settings-loading" class="fixed inset-0 z-[60] bg-white/40 backdrop-blur-[1px] hidden items-center justify-center transition-opacity duration-300">
            <div class="bg-white p-4 rounded-2xl shadow-xl flex items-center gap-3 border border-gray-100 animate-in fade-in zoom-in duration-200">
                <div class="w-6 h-6 border-2 border-primary/20 border-t-primary rounded-full animate-spin"></div>
                <span class="text-sm font-bold text-gray-700">Updating...</span>
            </div>
        </div>

        <!-- Toast Notification -->
        <div id="settings-toast" class="fixed bottom-8 left-1/2 -translate-x-1/2 z-[70] hidden animate-in slide-in-from-bottom-8 duration-300">
            <div class="bg-gray-900 text-white px-6 py-3 rounded-2xl shadow-2xl flex items-center gap-3">
                <i class="fa-solid fa-circle-check text-emerald-400"></i>
                <span id="toast-message" class="text-sm font-bold">Settings updated!</span>
            </div>
        </div>

        <h1 class="text-2xl font-bold text-gray-900 mb-6">Settings</h1>

        <!-- Account & Profile -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
            <div class="px-5 py-3 border-b border-gray-50 bg-gray-50/50">
                <h2 class="text-sm font-bold text-gray-500 uppercase tracking-wider">Account & Profile</h2>
            </div>
            
            <a href="<?php echo e(route('web.settings.personal-details')); ?>" class="flex items-center p-4 hover:bg-gray-50 transition-colors group border-b border-gray-50 last:border-0">
                <div class="w-10 h-10 rounded-xl bg-blue-50 flex items-center justify-center text-blue-600 mr-4 group-hover:scale-110 transition-transform">
                    <i class="fa-regular fa-user text-lg"></i>
                </div>
                <div class="flex-1">
                    <div class="font-bold text-gray-900 text-sm">Personal Details</div>
                    <div class="text-xs text-gray-500 mt-0.5">Manage your personal information</div>
                </div>
                <i class="fa-solid fa-chevron-right text-gray-300 text-xs group-hover:text-gray-400"></i>
            </a>

            <?php if($business): ?>
            <button type="button" onclick="document.getElementById('business-modal').classList.remove('hidden')" class="w-full flex items-center p-4 hover:bg-gray-50 transition-colors group border-b border-gray-50 last:border-0 text-left">
                <div class="w-10 h-10 rounded-xl bg-green-50 flex items-center justify-center text-green-600 mr-4 group-hover:scale-110 transition-transform">
                    <i class="fa-regular fa-building text-lg"></i>
                </div>
                <div class="flex-1">
                    <div class="font-bold text-gray-900 text-sm">Business Details</div>
                    <div class="text-xs text-gray-500 mt-0.5">Manage your business profile</div>
                </div>
                <i class="fa-solid fa-chevron-right text-gray-300 text-xs group-hover:text-gray-400"></i>
            </button>
            
            <a href="<?php echo e(route('web.business.number.edit', 'phone')); ?>" class="flex items-center p-4 hover:bg-gray-50 transition-colors group border-b border-gray-50 last:border-0">
                <div class="w-10 h-10 rounded-xl bg-teal-50 flex items-center justify-center text-teal-600 mr-4 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-phone text-lg"></i>
                </div>
                <div class="flex-1">
                    <div class="font-bold text-gray-900 text-sm">Phone Number</div>
                    <div class="text-xs text-gray-500 mt-0.5">Update your phone number</div>
                </div>
                <i class="fa-solid fa-chevron-right text-gray-300 text-xs group-hover:text-gray-400"></i>
            </a>

            <a href="<?php echo e(route('web.business.number.edit', 'whatsapp')); ?>" class="flex items-center p-4 hover:bg-gray-50 transition-colors group border-b border-gray-50 last:border-0">
                <div class="w-10 h-10 rounded-xl bg-green-50 flex items-center justify-center text-green-600 mr-4 group-hover:scale-110 transition-transform">
                    <i class="fa-brands fa-whatsapp text-lg"></i>
                </div>
                <div class="flex-1">
                    <div class="font-bold text-gray-900 text-sm">WhatsApp Number</div>
                    <div class="text-xs text-gray-500 mt-0.5">Configure WhatsApp settings</div>
                </div>
                <i class="fa-solid fa-chevron-right text-gray-300 text-xs group-hover:text-gray-400"></i>
            </a>
            <?php endif; ?>
        </div>

        <!-- Communication -->
        <?php if($business): ?>
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
            <div class="px-5 py-3 border-b border-gray-50 bg-gray-50/50">
                <h2 class="text-sm font-bold text-gray-500 uppercase tracking-wider">Communication</h2>
            </div>

            <div class="flex items-center justify-between p-4 border-b border-gray-50 last:border-0">
                 <div class="flex items-center">
                    <div class="w-10 h-10 rounded-xl bg-amber-50 flex items-center justify-center text-amber-600 mr-4">
                        <i class="fa-regular fa-star text-lg"></i>
                    </div>
                    <div>
                        <div class="font-bold text-gray-900 text-sm">Enable Feedback</div>
                        <div class="text-xs text-gray-500 mt-0.5">Allow users to leave reviews</div>
                    </div>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" class="sr-only peer" id="toggle-feedback" <?php echo e($business->is_feedback_enabled ? 'checked' : ''); ?> onchange="updateSetting('is_feedback_enabled', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-emerald-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-emerald-600"></div>
                </label>
            </div>

            <div class="flex items-center justify-between p-4 border-b border-gray-50 last:border-0">
                 <div class="flex items-center">
                    <div class="w-10 h-10 rounded-xl bg-blue-50 flex items-center justify-center text-blue-600 mr-4">
                        <i class="fa-regular fa-comments text-lg"></i>
                    </div>
                    <div>
                        <div class="font-bold text-gray-900 text-sm">Enable Chat</div>
                        <div class="text-xs text-gray-500 mt-0.5">Allow users to message you</div>
                    </div>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" class="sr-only peer" id="toggle-chat" <?php echo e($business->is_chat_enabled ? 'checked' : ''); ?> onchange="updateSetting('is_chat_enabled', this.checked)">
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-emerald-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-emerald-600"></div>
                </label>
            </div>
        </div>
        <?php endif; ?>

        <!-- Security -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
            <div class="px-5 py-3 border-b border-gray-50 bg-gray-50/50">
                <h2 class="text-sm font-bold text-gray-500 uppercase tracking-wider">Security</h2>
            </div>
            
            <a href="<?php echo e(route('web.settings.change-password')); ?>" class="flex items-center p-4 hover:bg-gray-50 transition-colors group border-b border-gray-50 last:border-0">
                <div class="w-10 h-10 rounded-xl bg-indigo-50 flex items-center justify-center text-indigo-600 mr-4 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-lock text-lg"></i>
                </div>
                <div class="flex-1">
                    <div class="font-bold text-gray-900 text-sm">Change Password</div>
                    <div class="text-xs text-gray-500 mt-0.5">Update your account password</div>
                </div>
                <i class="fa-solid fa-chevron-right text-gray-300 text-xs group-hover:text-gray-400"></i>
            </a>
        </div>

        <!-- Information -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
             <div class="px-5 py-3 border-b border-gray-50 bg-gray-50/50">
                <h2 class="text-sm font-bold text-gray-500 uppercase tracking-wider">Information</h2>
            </div>
            <a href="<?php echo e(route('web.home')); ?>" class="flex items-center p-4 hover:bg-gray-50 transition-colors group border-b border-gray-50 last:border-0">
                <div class="w-10 h-10 rounded-xl bg-cyan-50 flex items-center justify-center text-cyan-600 mr-4 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-circle-info text-lg"></i>
                </div>
                <div class="flex-1">
                    <div class="font-bold text-gray-900 text-sm">About Us</div>
                    <div class="text-xs text-gray-500 mt-0.5">Learn more about Yilick</div>
                </div>
                <i class="fa-solid fa-chevron-right text-gray-300 text-xs group-hover:text-gray-400"></i>
            </a>
        </div>

        <!-- Account Actions -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
             <div class="px-5 py-3 border-b border-gray-50 bg-gray-50/50">
                <h2 class="text-sm font-bold text-gray-500 uppercase tracking-wider">Account Actions</h2>
            </div>
            <form action="<?php echo e(route('logout')); ?>" method="POST" class="m-0">
                <?php echo csrf_field(); ?>
                <button type="submit" class="w-full flex items-center p-4 hover:bg-red-50 transition-colors group text-left">
                    <div class="w-10 h-10 rounded-xl bg-red-50 flex items-center justify-center text-red-600 mr-4 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-right-from-bracket text-lg"></i>
                    </div>
                    <div class="flex-1">
                        <div class="font-bold text-red-600 text-sm">Logout</div>
                        <div class="text-xs text-red-400 mt-0.5">Sign out of your account</div>
                    </div>
                    <i class="fa-solid fa-chevron-right text-red-200 text-xs group-hover:text-red-300"></i>
                </button>
            </form>
        </div>
    </div>
</div>

<!-- Business Options Modal -->
<div id="business-modal" class="hidden fixed inset-0 z-50 overflow-y-auto" onclick="if(event.target === this) document.getElementById('business-modal').classList.add('hidden')">
    <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:p-0">

        <!-- Modal panel with smooth slide-up animation -->
        <div class="relative z-10 inline-block align-bottom bg-white rounded-2xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full animate-in slide-in-from-bottom-4 fade-in duration-300">
            <div class="bg-white px-6 pt-6 pb-4">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-gray-900">Business Options</h3>
                    <button onclick="document.getElementById('business-modal').classList.add('hidden')" class="w-8 h-8 rounded-lg hover:bg-gray-100 transition-colors flex items-center justify-center text-gray-400 hover:text-gray-600">
                        <i class="fa-solid fa-xmark text-xl"></i>
                    </button>
                </div>
                <div class="border-t border-gray-100"></div>
            </div>

            <div class="px-2 pb-6 space-y-1">
                <!-- Business Profile -->
                <a href="<?php echo e(route('web.business.edit')); ?>" class="flex items-center p-4 mx-4 rounded-xl hover:bg-gray-50 transition-all group">
                    <div class="w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center mr-4 group-hover:scale-105 group-hover:bg-primary/20 transition-all">
                        <i class="fa-solid fa-shop text-primary text-lg"></i>
                    </div>
                    <div class="flex-1">
                        <div class="font-bold text-gray-900 text-sm">Business Profile</div>
                        <div class="text-xs text-gray-500 mt-0.5">Update business information</div>
                    </div>
                    <i class="fa-solid fa-chevron-right text-gray-300 group-hover:text-gray-400 transition-colors"></i>
                </a>

                <!-- Business Links -->
                <a href="<?php echo e(route('web.business.links')); ?>" class="flex items-center p-4 mx-4 rounded-xl hover:bg-gray-50 transition-all group">
                    <div class="w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center mr-4 group-hover:scale-105 group-hover:bg-primary/20 transition-all">
                        <i class="fa-solid fa-link text-primary text-lg"></i>
                    </div>
                    <div class="flex-1">
                        <div class="font-bold text-gray-900 text-sm">Business Links</div>
                        <div class="text-xs text-gray-500 mt-0.5">Manage website and social media</div>
                    </div>
                    <i class="fa-solid fa-chevron-right text-gray-300 group-hover:text-gray-400 transition-colors"></i>
                </a>

                <!-- Business Branding -->
                <a href="<?php echo e(route('web.business.branding')); ?>" class="flex items-center p-4 mx-4 rounded-xl hover:bg-gray-50 transition-all group">
                    <div class="w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center mr-4 group-hover:scale-105 group-hover:bg-primary/20 transition-all">
                        <i class="fa-solid fa-palette text-primary text-lg"></i>
                    </div>
                    <div class="flex-1">
                        <div class="font-bold text-gray-900 text-sm">Business Branding</div>
                        <div class="text-xs text-gray-500 mt-0.5">Logo, banner, colors and preview</div>
                    </div>
                    <i class="fa-solid fa-chevron-right text-gray-300 group-hover:text-gray-400 transition-colors"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function showToast(message) {
        const toast = document.getElementById('settings-toast');
        const toastMsg = document.getElementById('toast-message');
        toastMsg.innerText = message;
        toast.classList.remove('hidden');
        toast.classList.add('flex');
        
        setTimeout(() => {
            toast.classList.remove('flex');
            toast.classList.add('hidden');
        }, 3000);
    }

    function updateSetting(key, value) {
        const loading = document.getElementById('settings-loading');
        loading.classList.remove('hidden');
        loading.classList.add('flex');

        axios.post('<?php echo e(route('web.settings.update')); ?>', {
            [key]: value
        })
        .then(response => {
            showToast('Setting updated successfully!');
        })
        .catch(error => {
            console.error(error);
            // Revert checkbox if failed
            const checkbox = document.getElementById(key === 'is_feedback_enabled' ? 'toggle-feedback' : 'toggle-chat');
            if (checkbox) checkbox.checked = !value;
            showToast('Failed to update setting');
        })
        .finally(() => {
            loading.classList.remove('flex');
            loading.classList.add('hidden');
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/settings.blade.php ENDPATH**/ ?>