<?php $__env->startSection('title', 'Create Your Shop - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen py-8 md:py-16">
    <div class="max-w-3xl mx-auto px-4">
        <!-- Breadcrumbs -->
        <nav class="flex mb-8 text-sm font-medium" aria-label="Breadcrumb">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li class="inline-flex items-center">
                    <a href="<?php echo e(route('web.profile')); ?>" class="text-cool-gray hover:text-primary flex items-center gap-2 transition-colors">
                        <i class="fa-solid fa-circle-user"></i>
                        Profile
                    </a>
                </li>
                <li>
                    <div class="flex items-center text-cool-gray/40">
                        <i class="fa-solid fa-chevron-right text-[10px] mx-1"></i>
                        <span class="text-charcoal-gray">Create Shop</span>
                    </div>
                </li>
            </ol>
        </nav>

        <!-- Header Section -->
        <div class="mb-10 flex flex-col md:flex-row md:items-end justify-between gap-6">
            <div>
                <h1 class="text-3xl md:text-4xl font-black text-charcoal-gray tracking-tight mb-3">
                    Setup Your <span class="text-primary italic">Storefront</span>
                </h1>
                <p class="text-cool-gray text-base max-w-xl leading-relaxed">
                    Connect with thousands of customers by creating your professional shop profile. It only takes a few minutes.
                </p>
            </div>
            <button type="button" onclick="openInfoModal()" class="flex items-center gap-2 px-6 py-3 bg-white border border-gray-100 rounded-2xl text-cool-gray font-bold hover:text-primary hover:border-primary/30 hover:shadow-lg hover:shadow-gray-200/50 transition-all group shrink-0">
                <i class="fa-solid fa-circle-info text-primary transition-transform group-hover:scale-110"></i>
                <span class="text-xs uppercase tracking-widest">Why create a shop?</span>
            </button>
        </div>

        <!-- Form Success/Error Messages -->
        <?php if($errors->any()): ?>
            <div class="mb-8 p-4 bg-red-50 border border-red-100 rounded-2xl flex items-start gap-4 animate-in fade-in slide-in-from-top-4 duration-500">
                <div class="w-10 h-10 rounded-xl bg-red-100 flex items-center justify-center text-red-600 shrink-0">
                    <i class="fa-solid fa-circle-exclamation"></i>
                </div>
                <ul class="text-sm text-red-600 font-medium pt-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('business.store')); ?>" method="POST" enctype="multipart/form-data" class="space-y-8">
            <?php echo csrf_field(); ?>

            <!-- Step 1: Basic Identity -->
            <div class="bg-white rounded-[2.5rem] shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
                <div class="p-8 md:p-10">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 rounded-2xl bg-primary/10 flex items-center justify-center text-primary text-xl">
                            <i class="fa-solid fa-id-card"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-charcoal-gray">Shop Identity</h3>
                            <p class="text-cool-gray text-xs">The basic information about your brand.</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 gap-6">
                        <!-- Shop Name -->
                        <div>
                            <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-2" for="name">
                                Shop Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="name" id="name" value="<?php echo e(old('name')); ?>" required
                                class="w-full px-5 py-4 bg-gray-50 border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-charcoal-gray placeholder-cool-gray/40"
                                placeholder="e.g. Premium Electronics Store">
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Business Type -->
                            <div>
                                <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-2" for="business_type">
                                    Business Type <span class="text-red-500">*</span>
                                </label>
                                <select name="business_type" id="business_type" required
                                    class="w-full px-5 py-4 bg-gray-50 border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-charcoal-gray">
                                    <option value="">Select Type</option>
                                    <option value="individual" <?php echo e(old('business_type') == 'individual' ? 'selected' : ''); ?>>Individual</option>
                                    <option value="retailType" <?php echo e(old('business_type') == 'retailType' ? 'selected' : ''); ?>>Retail</option>
                                    <option value="wholesale" <?php echo e(old('business_type') == 'wholesale' ? 'selected' : ''); ?>>Wholesale</option>
                                    <option value="serviceProvider" <?php echo e(old('business_type') == 'serviceProvider' ? 'selected' : ''); ?>>Service Provider</option>
                                    <option value="manufacturing" <?php echo e(old('business_type') == 'manufacturing' ? 'selected' : ''); ?>>Manufacturing/Factory</option>
                                </select>
                            </div>

                            <!-- Business Category -->
                            <div>
                                <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-2" for="business_category">
                                    Category <span class="text-red-500">*</span>
                                </label>
                                <select name="business_category" id="business_category" required
                                    class="w-full px-5 py-4 bg-gray-50 border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-charcoal-gray">
                                    <option value="">Select Category</option>
                                    <option value="Retail" <?php echo e(old('business_category') == 'Retail' ? 'selected' : ''); ?>>Retail</option>
                                    <option value="Food & Beverage" <?php echo e(old('business_category') == 'Food & Beverage' ? 'selected' : ''); ?>>Food & Beverage</option>
                                    <option value="Services" <?php echo e(old('business_category') == 'Services' ? 'selected' : ''); ?>>Services</option>
                                    <option value="Healthcare" <?php echo e(old('business_category') == 'Healthcare' ? 'selected' : ''); ?>>Healthcare</option>
                                    <option value="Education" <?php echo e(old('business_category') == 'Education' ? 'selected' : ''); ?>>Education</option>
                                    <option value="Technology" <?php echo e(old('business_category') == 'Technology' ? 'selected' : ''); ?>>Technology</option>
                                    <option value="Construction" <?php echo e(old('business_category') == 'Construction' ? 'selected' : ''); ?>>Construction</option>
                                    <option value="Transportation" <?php echo e(old('business_category') == 'Transportation' ? 'selected' : ''); ?>>Transportation</option>
                                    <option value="Manufacturing" <?php echo e(old('business_category') == 'Manufacturing' ? 'selected' : ''); ?>>Manufacturing</option>
                                    <option value="Finance" <?php echo e(old('business_category') == 'Finance' ? 'selected' : ''); ?>>Finance</option>
                                    <option value="Hospitality" <?php echo e(old('business_category') == 'Hospitality' ? 'selected' : ''); ?>>Hospitality</option>
                                    <option value="Real Estate" <?php echo e(old('business_category') == 'Real Estate' ? 'selected' : ''); ?>>Real Estate</option>
                                    <option value="Automotive" <?php echo e(old('business_category') == 'Automotive' ? 'selected' : ''); ?>>Automotive</option>
                                    <option value="Agriculture" <?php echo e(old('business_category') == 'Agriculture' ? 'selected' : ''); ?>>Agriculture</option>
                                    <option value="Consulting" <?php echo e(old('business_category') == 'Consulting' ? 'selected' : ''); ?>>Consulting</option>
                                    <option value="Other" <?php echo e(old('business_category') == 'Other' ? 'selected' : ''); ?>>Other</option>
                                </select>
                            </div>
                        </div>

                        <!-- Description -->
                        <div>
                            <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-2" for="description">
                                About Your Shop
                            </label>
                            <textarea name="description" id="description" rows="4"
                                class="w-full px-5 py-4 bg-gray-50 border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-charcoal-gray placeholder-cool-gray/40 resize-none"
                                placeholder="Describe what you sell and why customers should choose you..."><?php echo e(old('description')); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 2: Branding -->
            <div class="bg-white rounded-[2.5rem] shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
                <div class="p-8 md:p-10">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 rounded-2xl bg-primary/5 text-primary flex items-center justify-center text-xl">
                            <i class="fa-solid fa-palette"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-charcoal-gray">Branding</h3>
                            <p class="text-cool-gray text-xs">Make your shop stand out with visuals.</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <!-- Logo Upload -->
                        <div>
                            <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-3">
                                Shop Logo
                            </label>
                            <div class="relative group">
                                <div class="w-32 h-32 rounded-3xl bg-gray-50 border-2 border-dashed border-gray-200 flex flex-col items-center justify-center overflow-hidden transition-all group-hover:border-primary group-hover:bg-primary/5 cursor-pointer" id="logo-preview-container">
                                    <i class="fa-solid fa-cloud-arrow-up text-cool-gray group-hover:text-primary text-2xl transition-all"></i>
                                    <span class="text-[10px] font-black text-cool-gray group-hover:text-primary uppercase tracking-widest mt-2">Upload</span>
                                    <img id="logo-preview" class="absolute inset-0 w-full h-full object-cover hidden">
                                </div>
                                <input type="file" name="logo" id="logo-input" accept="image/*" class="absolute inset-0 w-32 h-32 opacity-0 cursor-pointer" onchange="previewImage(this, 'logo-preview')">
                            </div>
                            <p class="text-[10px] text-cool-gray/60 mt-2 italic">Square image (e.g. 512x512px) recommended.</p>
                        </div>

                        <!-- Cover Photo Upload -->
                        <div>
                            <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-3">
                                Banner / Cover Photo
                            </label>
                            <div class="relative group">
                                <div class="h-32 rounded-3xl bg-gray-50 border-2 border-dashed border-gray-200 flex flex-col items-center justify-center overflow-hidden transition-all group-hover:border-primary group-hover:bg-primary/5 cursor-pointer" id="cover-preview-container">
                                    <i class="fa-solid fa-image text-cool-gray group-hover:text-primary text-2xl transition-all"></i>
                                    <span class="text-[10px] font-black text-cool-gray group-hover:text-primary uppercase tracking-widest mt-2">Upload Banner</span>
                                    <img id="cover-preview" class="absolute inset-0 w-full h-full object-cover hidden">
                                </div>
                                <input type="file" name="cover" id="cover-input" accept="image/*" class="absolute inset-0 w-full h-32 opacity-0 cursor-pointer" onchange="previewImage(this, 'cover-preview')">
                            </div>
                            <p class="text-[10px] text-cool-gray/60 mt-2 italic">Landscape image (e.g. 1200x400px) recommended.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 3: Contact & Location -->
            <div class="bg-white rounded-[2.5rem] shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
                <div class="p-8 md:p-10">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 rounded-2xl bg-vibrant-orange/10 text-vibrant-orange flex items-center justify-center text-xl">
                            <i class="fa-solid fa-location-dot"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-charcoal-gray">Contact & Reach</h3>
                            <p class="text-cool-gray text-xs">How can buyers find or contact you?</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Primary Phone -->
                        <div>
                            <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-2" for="primary_phone">
                                Phone Number <span class="text-red-500">*</span>
                            </label>
                            <div class="relative group">
                                <div class="absolute left-0 top-0 bottom-0 px-4 flex items-center bg-primary/10 border-primary/20 text-primary transition-colors group-focus-within:bg-primary/10 group-focus-within:text-primary">
                                    +256
                                </div>
                                <input type="tel" name="primary_phone" id="primary_phone" value="<?php echo e(old('primary_phone')); ?>" required
                                    class="w-full pl-16 pr-5 py-4 bg-gray-50 border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-charcoal-gray"
                                    placeholder="700 000 000">
                            </div>
                        </div>

                        <!-- WhatsApp -->
                        <div>
                            <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-2" for="primary_whatsapp">
                                WhatsApp <span class="text-red-500">*</span>
                            </label>
                            <div class="relative group">
                                <div class="absolute left-0 top-0 bottom-0 px-4 flex items-center bg-primary/10 border-primary/20 text-primary transition-colors group-focus-within:bg-primary/10 group-focus-within:text-primary">
                                    +256
                                </div>
                                <input type="tel" name="primary_whatsapp" id="primary_whatsapp" value="<?php echo e(old('primary_whatsapp')); ?>" required
                                    class="w-full pl-16 pr-5 py-4 bg-gray-50 border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-charcoal-gray"
                                    placeholder="700 000 000">
                            </div>
                        </div>

                        <!-- District (Modal Trigger) -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-black text-charcoal-gray uppercase tracking-wider mb-2">
                                District / Area <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <button type="button" onclick="openDistrictModal()" id="district-display"
                                    class="w-full px-5 py-4 bg-gray-50 border border-gray-100 rounded-2xl text-left font-medium text-charcoal-gray hover:border-primary focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all flex items-center justify-between group">
                                    <span id="selected-district-text"><?php echo e(old('district', 'Select District')); ?></span>
                                    <i class="fa-solid fa-chevron-down text-cool-gray group-hover:text-primary transition-colors"></i>
                                </button>
                                <input type="hidden" name="district" id="district-input" value="<?php echo e(old('district')); ?>" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Submit Section -->
            <div class="flex flex-col md:flex-row items-center justify-between gap-6 pt-6">
                <div class="flex items-center gap-3 text-cool-gray">
                    <i class="fa-solid fa-shield-halved text-primary"></i>
                    <p class="text-xs font-medium">Your data is safe and follows our <a href="<?php echo e(route('web.privacy')); ?>" class="text-primary hover:underline">Privacy Policy</a>.</p>
                </div>
                
                <div class="flex items-center gap-4 w-full md:w-auto">
                    <a href="<?php echo e(route('web.profile')); ?>" class="flex-1 md:flex-none px-10 py-5 bg-white border border-gray-100 rounded-2xl text-cool-gray font-black text-center hover:bg-gray-50 transition-all uppercase tracking-widest text-xs">
                        Cancel
                    </a>
                    <button type="submit" class="flex-1 md:flex-none px-12 py-5 bg-primary text-white rounded-2xl font-black shadow-xl shadow-primary/20 hover:bg-primary-dark hover:scale-105 active:scale-95 transition-all flex items-center justify-center gap-3 uppercase tracking-widest text-xs">
                        <span>Launch Shop</span>
                        <i class="fa-solid fa-rocket"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- District Selection Modal -->
<div id="district-modal" class="fixed inset-0 z-[100] hidden">
    <!-- Backdrop -->
    <div class="absolute inset-0 bg-charcoal-gray/60 backdrop-blur-sm" onclick="closeDistrictModal()"></div>
    
    <!-- Modal Content -->
    <div class="absolute inset-x-4 bottom-4 md:inset-auto md:left-1/2 md:top-1/2 md:-translate-x-1/2 md:-translate-y-1/2 md:w-full md:max-w-lg bg-white rounded-[2.5rem] shadow-2xl overflow-hidden animate-in fade-in zoom-in-95 slide-in-from-bottom-10 duration-300">
        <div class="p-6 md:p-8 flex flex-col h-[70vh] md:h-[600px]">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-2xl font-black text-charcoal-gray tracking-tight">Select <span class="text-primary italic">District</span></h3>
                <button onclick="closeDistrictModal()" class="w-10 h-10 rounded-full bg-gray-50 flex items-center justify-center text-cool-gray hover:bg-gray-100 transition-colors">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
            
            <!-- Search Bar -->
            <div class="relative mb-6">
                <i class="fa-solid fa-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-cool-gray/40"></i>
                <input type="text" id="district-search" onkeyup="filterDistricts()" 
                    class="w-full pl-12 pr-5 py-4 bg-gray-50 border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-charcoal-gray"
                    placeholder="Search district name...">
            </div>
            
            <!-- Districts List -->
            <div class="flex-1 overflow-y-auto space-y-1 pr-2 custom-scrollbar" id="districts-list">
                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button type="button" onclick="selectDistrict('<?php echo e($district['name']); ?>')" 
                        class="district-item w-full px-5 py-4 text-left rounded-2xl hover:bg-gray-50 transition-colors flex items-center justify-between group">
                        <span class="font-bold text-charcoal-gray group-hover:text-primary transition-colors"><?php echo e($district['name']); ?></span>
                        <i class="fa-solid fa-chevron-right text-[10px] text-cool-gray/20 group-hover:text-primary transition-all group-hover:translate-x-1"></i>
                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<style>
    .custom-scrollbar::-webkit-scrollbar {
        width: 4px;
    }
    .custom-scrollbar::-webkit-scrollbar-track {
        background: transparent;
    }
    .custom-scrollbar::-webkit-scrollbar-thumb {
        background: #E5E7EB;
        border-radius: 10px;
    }
    .custom-scrollbar::-webkit-scrollbar-thumb:hover {
        background: #D1D5DB;
    }
</style>

<script>
    function previewImage(input, previewId) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById(previewId);
                preview.src = e.target.result;
                preview.classList.remove('hidden');
                
                // Hide the icon and text
                const container = input.previousElementSibling;
                container.querySelectorAll('i, span').forEach(el => el.classList.add('opacity-0'));
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    // Modal Logic
    function openDistrictModal() {
        document.getElementById('district-modal').classList.remove('hidden');
        document.body.style.overflow = 'hidden';
        document.getElementById('district-search').focus();
    }

    function closeDistrictModal() {
        document.getElementById('district-modal').classList.add('hidden');
        document.body.style.overflow = '';
    }

    function selectDistrict(name) {
        document.getElementById('selected-district-text').innerText = name;
        document.getElementById('district-input').value = name;
        closeDistrictModal();
    }

    function filterDistricts() {
        const query = document.getElementById('district-search').value.toLowerCase();
        const items = document.querySelectorAll('.district-item');
        
        items.forEach(item => {
            const text = item.querySelector('span').innerText.toLowerCase();
            if (text.includes(query)) {
                item.classList.remove('hidden');
            } else {
                item.classList.add('hidden');
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<!-- Info Modal -->
<div id="info-modal" class="fixed inset-0 z-[100] hidden overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <!-- Overlay -->
        <div class="fixed inset-0 bg-charcoal-gray/60 backdrop-blur-sm transition-opacity" onclick="closeInfoModal()"></div>

        <!-- Modal Content -->
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        <div class="relative inline-block align-bottom bg-white rounded-[2.5rem] text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full animate-in zoom-in-95 duration-300">
            <div class="p-8 md:p-12">
                <div class="flex items-center justify-between mb-10">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-primary/10 rounded-2xl flex items-center justify-center text-primary text-xl">
                            <i class="fa-solid fa-rocket"></i>
                        </div>
                        <h2 class="text-2xl font-black text-charcoal-gray tracking-tight">Level Up Your Sales</h2>
                    </div>
                    <button onclick="closeInfoModal()" class="text-cool-gray/40 hover:text-charcoal-gray transition-colors">
                        <i class="fa-solid fa-xmark text-2xl"></i>
                    </button>
                </div>

                <div class="space-y-10">
                    <!-- Why -->
                    <div class="flex gap-6">
                        <div class="w-12 h-12 shrink-0 bg-gray-50 rounded-2xl flex items-center justify-center text-charcoal-gray text-lg border border-gray-100 italic font-black">?</div>
                        <div>
                            <h3 class="text-sm font-black text-charcoal-gray uppercase tracking-widest mb-3">Why Create a Business?</h3>
                            <p class="text-cool-gray leading-relaxed">A specialized business profile gives you a 100% dedicated storefront where buyers can see all your listings in one place, follow your updates, and contact you directly via WhatsApp or phone.</p>
                        </div>
                    </div>

                    <!-- Benefits -->
                    <div class="flex gap-6">
                        <div class="w-12 h-12 shrink-0 bg-primary/5 rounded-2xl flex items-center justify-center text-primary text-lg border border-primary/10 transition-transform hover:scale-110">
                            <i class="fa-solid fa-crown"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-black text-charcoal-gray uppercase tracking-widest mb-3">Professional Benefits</h3>
                            <ul class="space-y-3">
                                <li class="flex items-start gap-3 text-cool-gray">
                                    <i class="fa-solid fa-check-circle text-primary mt-1"></i>
                                    <span><strong>Build Trust:</strong> Verified badges and professional branding make you stand out.</span>
                                </li>
                                <li class="flex items-start gap-3 text-cool-gray">
                                    <i class="fa-solid fa-check-circle text-primary mt-1"></i>
                                    <span><strong>Growth Tools:</strong> Access advanced analytics, sales tracking, and bulk ad management.</span>
                                </li>
                                <li class="flex items-start gap-3 text-cool-gray">
                                    <i class="fa-solid fa-check-circle text-primary mt-1"></i>
                                    <span><strong>Visibility:</strong> Businesses get prioritized placement in our specialized categories.</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <!-- Who -->
                    <div class="flex gap-6">
                        <div class="w-12 h-12 shrink-0 bg-vibrant-orange/5 rounded-2xl flex items-center justify-center text-vibrant-orange text-lg border border-vibrant-orange/10">
                            <i class="fa-solid fa-users"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-black text-charcoal-gray uppercase tracking-widest mb-3">Who Should Create It?</h3>
                            <div class="flex flex-wrap gap-2">
                                <span class="px-4 py-2 bg-gray-100 rounded-full text-[10px] font-black text-charcoal-gray uppercase tracking-widest">Retailers</span>
                                <span class="px-4 py-2 bg-gray-100 rounded-full text-[10px] font-black text-charcoal-gray uppercase tracking-widest">Wholesalers</span>
                                <span class="px-4 py-2 bg-gray-100 rounded-full text-[10px] font-black text-charcoal-gray uppercase tracking-widest">Service Providers</span>
                                <span class="px-4 py-2 bg-gray-100 rounded-full text-[10px] font-black text-charcoal-gray uppercase tracking-widest">Manufacturers</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-12 flex justify-center">
                    <button onclick="closeInfoModal()" class="px-12 py-4 bg-primary text-white rounded-2xl font-black shadow-xl shadow-primary/20 hover:bg-primary-dark hover:scale-105 active:scale-95 transition-all uppercase tracking-widest text-xs">
                        Got it, Let's Start
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function openInfoModal() {
        document.getElementById('info-modal').classList.remove('hidden');
        document.body.style.overflow = 'hidden';
    }

    function closeInfoModal() {
        document.getElementById('info-modal').classList.add('hidden');
        document.body.style.overflow = 'auto';
    }
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/business-create.blade.php ENDPATH**/ ?>