<?php $__env->startSection('title', 'Help Center - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen">
    <!-- Hero Section -->
    <div class="bg-primary pt-16 pb-24 relative overflow-hidden">
        <div class="container mx-auto px-4 relative z-10 text-center text-white">
            <h1 class="text-4xl md:text-5xl font-black mb-6 tracking-tight">How can we <span class="bg-white text-primary px-3 py-1 rounded-xl">help you</span> today?</h1>
            <p class="text-white/80 text-lg max-w-2xl mx-auto">Browse the categories below to get started with Yilick and find answers to your questions.</p>
        </div>
    </div>

    <!-- Category Grid -->
    <div class="container mx-auto px-4 -mt-12 relative z-20">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-4xl mx-auto">
            <!-- How to Buy -->
            <a href="<?php echo e(route('web.how-to-buy')); ?>" class="group bg-white rounded-3xl p-8 shadow-xl shadow-gray-200/50 border border-transparent hover:border-primary transition-all hover:-translate-y-1">
                <div class="w-16 h-16 rounded-2xl bg-emerald-50 text-emerald-500 flex items-center justify-center mb-6 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-cart-shopping text-3xl"></i>
                </div>
                <h2 class="text-2xl font-black text-charcoal-gray mb-3">How to Buy</h2>
                <p class="text-cool-gray leading-relaxed mb-6">Learn how to find items, contact sellers, and complete your purchases safely.</p>
                <div class="flex items-center gap-2 text-primary font-bold text-sm">
                    <span>View Guide</span>
                    <i class="fa-solid fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                </div>
            </a>

            <!-- How to Sell -->
            <a href="<?php echo e(route('web.how-to-sell')); ?>" class="group bg-white rounded-3xl p-8 shadow-xl shadow-gray-200/50 border border-transparent hover:border-primary transition-all hover:-translate-y-1">
                <div class="w-16 h-16 rounded-2xl bg-emerald-50 text-primary flex items-center justify-center mb-6 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-store text-3xl"></i>
                </div>
                <h2 class="text-2xl font-black text-charcoal-gray mb-3">How to Sell</h2>
                <p class="text-cool-gray leading-relaxed mb-6">Everything you need to know about creating ads, managing shops, and reaching buyers.</p>
                <div class="flex items-center gap-2 text-primary font-bold text-sm">
                    <span>View Guide</span>
                    <i class="fa-solid fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                </div>
            </a>
        </div>

        <!-- Secondary Links -->
        <div class="max-w-4xl mx-auto mt-12 grid grid-cols-1 sm:grid-cols-3 gap-6 pb-20">
            <a href="<?php echo e(route('web.safety-center')); ?>" class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 flex items-center gap-4 group hover:bg-gray-50 transition-colors">
                <div class="w-12 h-12 rounded-xl bg-orange-50 text-orange-500 flex items-center justify-center flex-shrink-0">
                    <i class="fa-solid fa-shield-halved text-xl"></i>
                </div>
                <div>
                    <h3 class="font-bold text-charcoal-gray">Safety Center</h3>
                    <p class="text-[11px] text-cool-gray">Stay safe while trading</p>
                </div>
            </a>

            <a href="<?php echo e(route('web.faqs')); ?>" class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 flex items-center gap-4 group hover:bg-gray-50 transition-colors">
                <div class="w-12 h-12 rounded-xl bg-purple-50 text-purple-500 flex items-center justify-center flex-shrink-0">
                    <i class="fa-solid fa-circle-question text-xl"></i>
                </div>
                <div>
                    <h3 class="font-bold text-charcoal-gray">FAQs</h3>
                    <p class="text-[11px] text-cool-gray">Common questions</p>
                </div>
            </a>

            <button onclick="openSupportModal()" class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 flex items-center gap-4 group hover:bg-gray-50 transition-colors text-left w-full">
                <div class="w-12 h-12 rounded-xl bg-primary/5 text-primary flex items-center justify-center flex-shrink-0 group-hover:bg-primary group-hover:text-white transition-all">
                    <i class="fa-solid fa-headset text-xl"></i>
                </div>
                <div>
                    <h3 class="font-bold text-charcoal-gray">Contact Support</h3>
                    <p class="text-[11px] text-cool-gray">We're here to help</p>
                </div>
            </button>
        </div>
    </div>
</div>

<?php echo $__env->make('web.partials.support-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/help-center.blade.php ENDPATH**/ ?>