<?php $__env->startSection('title', 'FAQs - Yilick | Quick Answers to Buying & Selling'); ?>
<?php $__env->startSection('meta_description', 'Have questions about Yilick? Find quick answers about downloading the app, safety, payments, and how to sell your items in Uganda.'); ?>

<?php $__env->startSection('header_meta'); ?>
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        {
            "@type": "Question",
            "name": "<?php echo e(str_replace('"', '\"', $faq['q'])); ?>",
            "acceptedAnswer": {
                "@type": "Answer",
                "text": "<?php echo e(str_replace('"', '\"', $faq['a'])); ?>"
            }
        }<?php echo e($index < count($faqs) - 1 ? ',' : ''); ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    ]
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pb-20">
    <!-- Header -->
    <div class="bg-white border-b border-gray-100 pt-8 pb-8 sticky top-0 md:static z-30">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto flex items-center gap-4">
                <a href="<?php echo e(route('web.help-center')); ?>" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-cool-gray hover:text-primary transition-colors">
                    <i class="fa-solid fa-chevron-left"></i>
                </a>
                <h1 class="text-xl font-black text-charcoal-gray tracking-tight">Frequently Asked Questions</h1>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-12">
        <div class="max-w-3xl mx-auto">
            <h2 class="text-3xl font-black text-charcoal-gray mb-6 text-center">Common questions & answers</h2>
            
            <!-- FAQ Search -->
            <div class="relative mb-12 group">
                <input type="text" id="faq-search" onkeyup="filterFaqs()" placeholder="Search FAQs (e.g., 'app', 'payment', 'safety')..." class="w-full h-14 pl-12 pr-6 bg-white border border-gray-100 rounded-2xl text-charcoal-gray placeholder:text-cool-gray focus:outline-none focus:ring-2 focus:ring-primary transition-all shadow-sm">
                <i class="fa-solid fa-magnifying-glass absolute left-5 top-1/2 -translate-y-1/2 text-cool-gray group-focus-within:text-primary transition-colors"></i>
            </div>

            <div class="space-y-4" id="faq-list">


                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="faq-item bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden group">
                        <button class="w-full p-6 text-left flex items-center justify-between gap-4 focus:outline-none" onclick="toggleFaq(this)">
                            <span class="faq-question font-bold text-lg text-charcoal-gray group-hover:text-primary transition-colors"><?php echo e($faq['q']); ?></span>
                            <i class="fa-solid fa-plus text-cool-gray group-hover:text-primary transition-transform"></i>
                        </button>
                        <div class="faq-content max-h-0 overflow-hidden transition-all duration-300 ease-in-out px-6">
                            <p class="pb-6 text-cool-gray leading-relaxed"><?php echo e($faq['a']); ?></p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <!-- No Results Message -->
                <div id="no-results" class="hidden text-center py-12">
                    <div class="w-20 h-20 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-4 text-cool-gray">
                        <i class="fa-solid fa-magnifying-glass text-3xl"></i>
                    </div>
                    <h3 class="font-bold text-charcoal-gray mb-1">No FAQs found</h3>
                    <p class="text-cool-gray text-sm">Try searching for different keywords</p>
                </div>
            </div>

            <!-- Still have questions? -->
            <div class="mt-16 text-center">
                <p class="text-cool-gray mb-6">Can't find what you're looking for?</p>
                <button onclick="openSupportModal('General Inquiry')" class="inline-flex items-center gap-2 text-primary font-black hover:underline">
                    <span>Ask our support team</span>
                    <i class="fa-solid fa-arrow-right"></i>
                </button>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('web.partials.support-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<script>
    function toggleFaq(button) {
        const content = button.nextElementSibling;
        const icon = button.querySelector('i');
        
        if (content.style.maxHeight) {
            content.style.maxHeight = null;
            icon.style.transform = 'rotate(0deg)';
            icon.classList.replace('fa-minus', 'fa-plus');
        } else {
            // Close other open FAQs
            document.querySelectorAll('.faq-content').forEach(el => {
                if (el !== content) {
                    el.style.maxHeight = null;
                    const b = el.previousElementSibling;
                    const i = b.querySelector('i');
                    i.style.transform = 'rotate(0deg)';
                    i.classList.replace('fa-minus', 'fa-plus');
                }
            });
            
            content.style.maxHeight = content.scrollHeight + "px";
            icon.style.transform = 'rotate(45deg)';
            icon.classList.replace('fa-plus', 'fa-minus');
        }
    }

    function filterFaqs() {
        const query = document.getElementById('faq-search').value.toLowerCase();
        const items = document.querySelectorAll('.faq-item');
        const noResults = document.getElementById('no-results');
        let found = false;

        items.forEach(item => {
            const question = item.querySelector('.faq-question').innerText.toLowerCase();
            const answer = item.querySelector('.faq-content p').innerText.toLowerCase();
            
            if (question.includes(query) || answer.includes(query)) {
                item.classList.remove('hidden');
                found = true;
            } else {
                item.classList.add('hidden');
                // Close the FAQ if it's open and being hidden
                const content = item.querySelector('.faq-content');
                if (content.style.maxHeight) {
                    content.style.maxHeight = null;
                    const icon = item.querySelector('i');
                    icon.style.transform = 'rotate(0deg)';
                    icon.classList.replace('fa-minus', 'fa-plus');
                }
            }
        });

        if (found) {
            noResults.classList.add('hidden');
        } else {
            noResults.classList.remove('hidden');
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/faqs.blade.php ENDPATH**/ ?>