<!-- Support Modal -->
<div id="support-modal" class="fixed inset-0 z-[100] hidden overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <!-- Backdrop -->
        <div id="modal-backdrop" class="fixed inset-0 bg-charcoal-gray/60 backdrop-blur-sm transition-opacity opacity-0 pointer-events-none" aria-hidden="true" onclick="closeSupportModal()"></div>

        <!-- This element is to trick the browser into centering the modal contents. -->
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

        <!-- Modal Panel -->
        <div id="modal-panel" class="inline-block align-bottom bg-white rounded-[32px] text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full translate-y-full opacity-0">
            <div class="bg-white px-8 pt-8 pb-8">
                <div class="flex justify-between items-center mb-8">
                    <h3 class="text-2xl font-black text-charcoal-gray" id="modal-title">Contact Support</h3>
                    <button onclick="closeSupportModal()" class="text-cool-gray hover:text-charcoal-gray transition-colors">
                        <i class="fa-solid fa-xmark text-2xl"></i>
                    </button>
                </div>

                <form action="<?php echo e(route('web.support.send')); ?>" method="POST" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="block text-sm font-bold text-charcoal-gray mb-2">Full Name</label>
                        <input type="text" name="name" required value="<?php echo e(auth()->user() ? auth()->user()->full_name : ''); ?>" class="w-full h-12 px-4 bg-gray-50 border border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all" placeholder="Enter your name">
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-charcoal-gray mb-2">Email Address</label>
                        <input type="email" name="email" required value="<?php echo e(auth()->user() ? auth()->user()->email : ''); ?>" class="w-full h-12 px-4 bg-gray-50 border border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all" placeholder="Enter your email">
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-charcoal-gray mb-2">Subject</label>
                        <select name="subject" id="support_subject" required class="w-full h-12 px-4 bg-gray-50 border border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all">
                            <option value="General Inquiry">General Inquiry</option>
                            <option value="Account Issue">Account Issue</option>
                            <option value="Billing & Payments">Billing & Payments</option>
                            <option value="Reporting a Bug">Reporting a Bug</option>
                            <option value="Safety & Security">Safety & Security</option>
                            <option value="Fraudulent Activity">Fraudulent Activity / Report Issue</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-charcoal-gray mb-2">Message</label>
                        <textarea name="message" required rows="4" class="w-full px-4 py-3 bg-gray-50 border border-gray-100 rounded-2xl focus:outline-none focus:ring-2 focus:ring-primary focus:bg-white transition-all resize-none" placeholder="How can we help you?"></textarea>
                    </div>
                    <div class="pt-4">
                        <button type="submit" class="w-full h-14 bg-primary hover:bg-emerald-600 text-white font-black rounded-2xl shadow-xl shadow-primary/20 transition-all active:scale-95 flex items-center justify-center gap-2">
                            <i class="fa-solid fa-paper-plane"></i>
                            <span>Send Message</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function openSupportModal(subject = null) {
    const modal = document.getElementById('support-modal');
    const backdrop = document.getElementById('modal-backdrop');
    const panel = document.getElementById('modal-panel');
    const subjectSelect = document.getElementById('support_subject');
    
    if (subject) {
        subjectSelect.value = subject;
    }
    
    modal.classList.remove('hidden');
    // Force reflow
    void modal.offsetWidth;
    
    backdrop.classList.remove('opacity-0', 'pointer-events-none');
    backdrop.classList.add('opacity-100', 'pointer-events-auto');
    
    panel.classList.remove('translate-y-full', 'opacity-0');
    panel.classList.add('translate-y-0', 'opacity-100');
}

function closeSupportModal() {
    const modal = document.getElementById('support-modal');
    const backdrop = document.getElementById('modal-backdrop');
    const panel = document.getElementById('modal-panel');
    
    backdrop.classList.remove('opacity-100', 'pointer-events-auto');
    backdrop.classList.add('opacity-0', 'pointer-events-none');
    
    panel.classList.remove('translate-y-0', 'opacity-100');
    panel.classList.add('translate-y-full', 'opacity-0');
    
    setTimeout(() => {
        modal.classList.add('hidden');
    }, 300);
}
</script>
<?php /**PATH /home/yilickapp/resources/views/web/partials/support-modal.blade.php ENDPATH**/ ?>