<?php $__env->startSection('title', 'My Profile - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pb-12 relative">
    <!-- Global Loading Overlay for Switching -->
    <div id="shop-switch-loader" class="fixed inset-0 z-[100] bg-white/80 backdrop-blur-sm hidden flex-col items-center justify-center transition-all duration-300">
        <div class="relative">
            <div class="w-16 h-16 rounded-full border-4 border-gray-100"></div>
            <div class="absolute top-0 left-0 w-16 h-16 rounded-full border-4 border-primary border-t-transparent animate-spin"></div>
            <!-- Yilick Logo Icon (Optional/Placeholder) -->
            <div class="absolute inset-0 flex items-center justify-center text-primary text-xl font-bold animate-pulse">
                Y
            </div>
        </div>
        <p class="mt-4 text-charcoal-gray font-bold animate-pulse">Switching Shop...</p>
    </div>
    
    <!-- MOBILE LAYOUT (unchanged, hidden on lg+) -->
    <div class="lg:hidden">
        <!-- Profile Header -->
        <div class="bg-white border-b border-gray-100 pt-8 pb-10">
            <div class="container mx-auto px-4">
                <div class="flex flex-col items-center text-center">
                    <div class="relative group">
                        <div class="w-24 h-24 md:w-32 md:h-32 rounded-3xl bg-primary/5 flex items-center justify-center border-4 border-white shadow-xl overflow-hidden ring-1 ring-gray-100">
                            <?php if($user->profile_photo): ?>
                                <img src="<?php echo e($user->profile_photo_url); ?>" onerror="this.src='<?php echo e(asset('assets/icons/favicon.png')); ?>'" class="w-full h-full object-cover">
                            <?php else: ?>
                                <div class="text-3xl md:text-4xl font-bold text-primary">
                                    <?php echo e(strtoupper(substr($user->full_name, 0, 1))); ?><?php echo e(strtoupper(substr(strrchr($user->full_name, " "), 1, 1)) ?: ''); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <h1 class="mt-6 text-2xl md:text-3xl font-extrabold text-charcoal-gray tracking-tight">
                        <?php echo e($user->full_name); ?>

                    </h1>
                    <p class="mt-1 text-sm text-cool-gray font-medium">
                        <?php echo e($user->email); ?>

                    </p>
                    
                    <div class="mt-4 flex items-center gap-2">
                        <span class="px-3 py-1 bg-emerald-50 text-emerald-600 text-[10px] font-bold uppercase tracking-wider rounded-full border border-emerald-100">
                            <?php echo e($user->role === 'seller' ? 'Seller Account' : 'Member'); ?>

                        </span>
                        <span class="text-cool-gray/30 text-xs">•</span>
                        <span class="text-cool-gray text-xs font-medium">Joined <?php echo e($user->created_at->format('M Y')); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="container mx-auto px-4 -mt-6">
            <div class="max-w-4xl mx-auto space-y-6">
                
                <!-- Welcome Alert -->
                <div class="bg-white rounded-2xl p-4 shadow-sm border border-gray-100 flex items-center gap-4 animate-in fade-in slide-in-from-bottom-2 duration-500">
                    <div class="w-12 h-12 rounded-xl bg-emerald-50 flex items-center justify-center flex-shrink-0">
                        <i class="fa-solid fa-circle-check text-emerald-500 text-xl"></i>
                    </div>
                    <div>
                        <h3 class="font-bold text-charcoal-gray text-sm">Welcome back!</h3>
                        <p class="text-cool-gray text-xs">Explore the latest deals and manage your listings.</p>
                    </div>
                </div>

                <!-- Business / Shop Section -->
                <?php if($businesses->count() > 0): ?>
                    <div class="bg-white rounded-3xl p-4 shadow-sm border border-gray-100">
                        <div class="flex items-center justify-between mb-4 px-2">
                            <h3 class="font-bold text-charcoal-gray text-sm">Active Shops</h3>
                            <a href="<?php echo e(route('business.create')); ?>" class="text-primary text-[10px] font-bold uppercase tracking-wider hover:underline">+ New Shop</a>
                        </div>
                        <div class="space-y-3">
                            <?php $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $isSelected = session('selected_business_id') == $business->id || (!session('selected_business_id') && $loop->first); ?>
                                <div onclick="switchShop(<?php echo e($business->id); ?>)" 
                                     id="mobile-shop-card-<?php echo e($business->id); ?>"
                                     class="flex items-center gap-4 p-3 rounded-2xl border <?php echo e($isSelected ? 'border-primary bg-primary/5 shop-selected' : 'border-gray-50 bg-gray-50/30'); ?> group hover:border-primary/20 hover:bg-white transition-all cursor-pointer shop-card-mobile">
                                    <div class="w-12 h-12 rounded-xl bg-white flex items-center justify-center border border-gray-100 overflow-hidden shadow-sm">
                                        <?php if($business->logo_url): ?>
                                            <img src="<?php echo e($business->logo_url); ?>" class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <span class="text-xs font-black text-primary"><?php echo e(strtoupper(substr($business->name, 0, 2))); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex-1">
                                        <h4 class="font-bold text-sm text-charcoal-gray leading-tight"><?php echo e($business->name); ?></h4>
                                        <div class="flex items-center gap-1.5 mt-0.5">
                                            <span class="text-[10px] text-cool-gray"><?php echo e(ucfirst($business->business_type)); ?></span>
                                            <span class="text-cool-gray/30 text-[10px]">•</span>
                                            <span class="text-[10px] font-bold <?php echo e($business->verification_status === 'verified' ? 'text-emerald-500' : 'text-vibrant-orange'); ?>">
                                                <?php echo e(ucfirst($business->verification_status)); ?>

                                            </span>
                                        </div>
                                    </div>
                                    <i id="mobile-check-<?php echo e($business->id); ?>" class="fa-solid fa-circle-check text-primary <?php echo e($isSelected ? '' : 'opacity-0'); ?> transition-opacity"></i>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php else: ?>
                    <a href="<?php echo e(route('business.create')); ?>" class="bg-white rounded-3xl p-6 shadow-sm border border-gray-100 flex items-center gap-6 group hover:border-primary/20 transition-all">
                        <div class="w-14 h-14 rounded-2xl bg-primary/5 flex items-center justify-center text-primary text-2xl group-hover:bg-primary group-hover:text-white transition-all shadow-inner">
                            <i class="fa-solid fa-store"></i>
                        </div>
                        <div class="flex-1">
                            <h3 class="font-black text-charcoal-gray text-base leading-tight">Create a shop</h3>
                            <p class="text-cool-gray text-[12px] mt-1 pr-4">Set up your storefront to start listing products and services easily.</p>
                        </div>
                        <i class="fa-solid fa-chevron-right text-cool-gray/30 group-hover:translate-x-1 transition-transform"></i>
                    </a>
                <?php endif; ?>

                <!-- Account Menu Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- My Activity Card -->
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-6 py-5 border-b border-gray-50 flex items-center justify-between">
                            <h2 class="font-bold text-charcoal-gray">My Activity</h2>
                            <span id="mobile-stats-count" class="bg-emerald-50 text-emerald-600 text-[9px] font-black px-2 py-0.5 rounded-full"><?php echo e($listingsCount); ?> Active</span>
                        </div>
                        <div class="p-2">
                            <a href="<?php echo e(route('web.my-ads')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                                <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                    <i class="fa-solid fa-rectangle-list"></i>
                                </div>
                                <div class="flex-1">
                                    <div class="font-bold text-sm text-charcoal-gray">My Ads</div>
                                    <div class="text-[11px] text-cool-gray">Manage your published listings</div>
                                </div>
                                <i class="fa-solid fa-chevron-right text-cool-gray text-xs group-hover:translate-x-1 transition-transform"></i>
                            </a>
                            <a href="<?php echo e(route('web.favorites')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                                <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                    <i class="fa-regular fa-heart"></i>
                                </div>
                                <div class="flex-1">
                                    <div class="font-bold text-sm text-charcoal-gray">Favorites</div>
                                    <div class="text-[11px] text-cool-gray">Manage your saved items</div>
                                </div>
                                <i class="fa-solid fa-chevron-right text-cool-gray text-xs group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </div>
                    </div>

                    <!-- Tools & Support Card -->
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-6 py-5 border-b border-gray-50 flex items-center justify-between">
                            <h2 class="font-bold text-charcoal-gray tracking-tight">Tools & Support</h2>
                            <i class="fa-solid fa-screwdriver-wrench text-primary text-xs"></i>
                        </div>
                        <div class="p-2">
                            <a href="<?php echo e(route('web.notifications')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                                <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                    <i class="fa-solid fa-bell"></i>
                                </div>
                                <div class="flex-1">
                                    <div class="font-bold text-sm text-charcoal-gray">Notifications</div>
                                    <div class="text-[11px] text-cool-gray">Stay updated with alerts</div>
                                </div>
                                <i class="fa-solid fa-chevron-right text-cool-gray text-xs group-hover:translate-x-1 transition-transform"></i>
                            </a>
                            <a href="<?php echo e(route('web.membership.index')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                                <div class="w-10 h-10 rounded-xl bg-purple-50 flex items-center justify-center text-purple-600 group-hover:bg-purple-600 group-hover:text-white transition-all">
                                    <i class="fa-solid fa-crown"></i>
                                </div>
                                <div class="flex-1">
                                    <div class="font-bold text-sm text-charcoal-gray">Membership</div>
                                    <div class="text-[11px] text-cool-gray">Manage your subscription</div>
                                </div>
                                <i class="fa-solid fa-chevron-right text-cool-gray text-xs group-hover:translate-x-1 transition-transform"></i>
                            </a>
                            <a href="<?php echo e(env('AI_URL')); ?>" target="_blank" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                                <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                    <i class="fa-solid fa-robot"></i>
                                </div>
                                <div class="flex-1">
                                    <div class="font-bold text-sm text-charcoal-gray">Live AI Support</div>
                                    <div class="text-[11px] text-cool-gray">Instant help from our AI</div>
                                </div>
                                <i class="fa-solid fa-chevron-right text-cool-gray text-xs group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Settings & Feedback Card -->
                <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-2 grid grid-cols-1 md:grid-cols-2">
                        <a href="<?php echo e(route('web.settings')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                            <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-gears"></i>
                            </div>
                            <div class="flex-1">
                                <div class="font-bold text-sm text-charcoal-gray">Account Settings</div>
                                <div class="text-[11px] text-cool-gray">Manage your account & privacy</div>
                            </div>
                            <i class="fa-solid fa-chevron-right text-cool-gray/30 text-xs"></i>
                        </a>
                        <a href="#" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                            <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-message"></i>
                            </div>
                            <div class="flex-1">
                                <div class="font-bold text-sm text-charcoal-gray">Feedback</div>
                                <div class="text-[11px] text-cool-gray">Share your thoughts with us</div>
                            </div>
                            <i class="fa-solid fa-chevron-right text-cool-gray/30 text-xs"></i>
                        </a>
                    </div>
                </div>

                <!-- Hot Deals Banner -->
                <a href="<?php echo e(route('listing.hot-deals')); ?>" class="relative block overflow-hidden rounded-3xl shadow-xl shadow-emerald-500/20 group">
                    <div class="absolute inset-0 bg-gradient-to-br from-emerald-600 to-emerald-900 group-hover:scale-105 transition-transform duration-500"></div>
                    <div class="absolute -right-10 -bottom-10 opacity-10 group-hover:rotate-12 transition-transform duration-500">
                        <i class="fa-solid fa-fire text-[180px] text-white"></i>
                    </div>
                    <div class="relative p-8 flex items-center justify-between">
                        <div>
                            <div class="flex items-center gap-3 mb-2">
                                <span class="bg-white text-emerald-900 text-[9px] font-black px-2 py-0.5 rounded-md">HOT</span>
                                <span class="text-emerald-100 text-[10px] font-bold tracking-widest uppercase">NEW FEATURE</span>
                            </div>
                            <h3 class="text-white text-xl font-black italic tracking-tight">Hot Deals</h3>
                            <p class="text-emerald-100/80 text-xs mt-1">Discover hidden gems at unbeatable prices!</p>
                        </div>
                        <div class="w-12 h-12 bg-white/20 backdrop-blur-md rounded-2xl flex items-center justify-center text-white border border-white/30 group-hover:translate-x-2 transition-transform">
                            <i class="fa-solid fa-arrow-right"></i>
                        </div>
                    </div>
                </a>
<script>
    function openSupportModal() {
        // Implement support modal logic here if needed
        alert('Support modal coming soon!');
    }

    async function switchShop(businessId) {
        // Show Loader
        const loader = document.getElementById('shop-switch-loader');
        loader.classList.remove('hidden');
        loader.classList.add('flex');

        try {
            const response = await fetch('<?php echo e(route("web.switch-business")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ business_id: businessId })
            });

            const data = await response.json();

            if (data.success) {
                // Update UI without reload
                updateShopUI(businessId);
                
                // Update Stats
                document.getElementById('mobile-stats-count').textContent = data.listingsCount + ' Active';
                document.getElementById('desktop-stats-count').textContent = data.listingsCount;
                
                // Show brief success state before hiding loader
                await new Promise(r => setTimeout(r, 500)); // Minimum loading time for UX
            } else {
                alert('Failed to switch shop');
            }
        } catch (error) {
            console.error('Error switching shop:', error);
            alert('An error occurred. Please try again.');
        } finally {
            // Hide Loader
            loader.classList.add('hidden');
            loader.classList.remove('flex');
        }
    }

    function updateShopUI(businessId) {
        // Helper to reset and activate classes
        const resetClasses = (el, isDesktop) => {
            el.classList.remove('border-primary', 'bg-primary/5', 'shop-selected');
            if (isDesktop) el.classList.remove('ring-1', 'ring-primary/20');
            el.classList.add('border-gray-50', 'bg-gray-50/30');
            if (isDesktop) el.classList.add('border-gray-100');
        };

        const activateClasses = (el, isDesktop) => {
            el.classList.remove('border-gray-50', 'bg-gray-50/30', 'border-gray-100');
            el.classList.add('border-primary', 'bg-primary/5', 'shop-selected');
            if (isDesktop) el.classList.add('ring-1', 'ring-primary/20');
        };

        // Mobile Updates
        document.querySelectorAll('.shop-card-mobile').forEach(el => {
            resetClasses(el, false);
            // Hide check icons
            const check = el.querySelector('.fa-circle-check');
            if(check) check.classList.add('opacity-0');
        });

        const activeMobile = document.getElementById(`mobile-shop-card-${businessId}`);
        if(activeMobile) {
            activateClasses(activeMobile, false);
            // Show check icon
            const check = activeMobile.querySelector('.fa-circle-check');
            if(check) check.classList.remove('opacity-0');
        }

        // Desktop Updates
        document.querySelectorAll('.shop-card-desktop').forEach(el => {
            resetClasses(el, true);
            // Hide indicators
            const indicator = el.querySelector('[id^="desktop-indicator-"]');
            if(indicator) indicator.classList.add('hidden');
        });

        const activeDesktop = document.getElementById(`desktop-shop-card-${businessId}`);
        if(activeDesktop) {
            activateClasses(activeDesktop, true);
             // Show indicator
             const indicator = document.getElementById(`desktop-indicator-${businessId}`);
             if(indicator) indicator.classList.remove('hidden');
        }
    }
</script>
                <!-- Support & Others Card -->
                <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="px-6 py-5 border-b border-gray-50">
                        <h2 class="font-bold text-charcoal-gray tracking-tight">Support & Legal</h2>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 p-2">
                        <a href="<?php echo e(route('web.help-center')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                            <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-circle-question"></i>
                            </div>
                            <div class="flex-1">
                                <div class="font-bold text-sm text-charcoal-gray">Help Center</div>
                                <div class="text-[11px] text-cool-gray">FAQs and usage guides</div>
                            </div>
                            <i class="fa-solid fa-chevron-right text-cool-gray/30 text-xs"></i>
                        </a>
                        <button onclick="openSupportModal()" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group text-left w-full">
                            <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-headset"></i>
                            </div>
                            <div class="flex-1">
                                <div class="font-bold text-sm text-charcoal-gray">Contact Support</div>
                                <div class="text-[11px] text-cool-gray">We're here to help you</div>
                            </div>
                            <i class="fa-solid fa-chevron-right text-cool-gray/30 text-xs"></i>
                        </button>
                        <a href="<?php echo e(route('web.privacy')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                            <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-shield-halved"></i>
                            </div>
                            <div class="flex-1">
                                <div class="font-bold text-sm text-charcoal-gray">Privacy Policy</div>
                                <div class="text-[11px] text-cool-gray">How we handle your data</div>
                            </div>
                            <i class="fa-solid fa-chevron-right text-cool-gray/30 text-xs"></i>
                        </a>
                        <a href="<?php echo e(route('web.terms')); ?>" class="flex items-center gap-4 p-4 hover:bg-gray-50 rounded-2xl transition-colors group">
                            <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-file-contract"></i>
                            </div>
                            <div class="flex-1">
                                <div class="font-bold text-sm text-charcoal-gray">Terms of Service</div>
                                <div class="text-[11px] text-cool-gray">Rules for using Yilick</div>
                            </div>
                            <i class="fa-solid fa-chevron-right text-cool-gray/30 text-xs"></i>
                        </a>
                    </div>
                </div>

                <!-- Logout Section -->
                <div class="pt-4 flex flex-col items-center gap-6">
                    <form action="<?php echo e(route('logout')); ?>" method="POST" class="w-full max-w-xs">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full bg-white text-red-500 font-bold py-4 rounded-3xl border border-red-50 hover:bg-red-50 transition-all flex items-center justify-center gap-3 shadow-sm active:scale-95">
                            <i class="fa-solid fa-right-from-bracket"></i>
                            <span>Sign Out</span>
                        </button>
                    </form>
                    
                    <div class="text-center">
                        <p class="text-cool-gray/30 text-[10px] font-bold tracking-widest uppercase">Version 2.0.0 (Build 2025)</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- DESKTOP LAYOUT (hidden on mobile, shown on lg+) -->
    <div class="hidden lg:block">
        <!-- Hero Header with Gradient -->
        <div class="relative bg-gradient-to-br from-emerald-900 via-green-800 to-teal-900 overflow-hidden">
            <!-- Decorative Elements -->
            <div class="absolute inset-0 overflow-hidden pointer-events-none">
                <div class="absolute top-0 right-0 w-[600px] h-[600px] bg-gradient-to-bl from-primary/20 to-transparent rounded-full blur-3xl"></div>
                <div class="absolute bottom-0 left-0 w-[400px] h-[400px] bg-gradient-to-tr from-emerald-500/10 to-transparent rounded-full blur-3xl"></div>
                <!-- Grid Pattern -->
                <div class="absolute inset-0 opacity-[0.03]" style="background-image: radial-gradient(#fff 1px, transparent 1px); background-size: 32px 32px;"></div>
            </div>
            
            <div class="max-w-7xl mx-auto px-6 lg:px-8 pt-24 pb-32 relative">
                <div class="flex items-center gap-8">
                    <!-- Profile Photo -->
                    <div class="relative">
                        <div class="w-32 h-32 rounded-3xl bg-gradient-to-br from-primary to-emerald-400 p-1 shadow-2xl shadow-primary/30">
                            <div class="w-full h-full rounded-[22px] bg-white flex items-center justify-center overflow-hidden">
                                <?php if($user->profile_photo): ?>
                                    <img src="<?php echo e($user->profile_photo_url); ?>" onerror="this.src='<?php echo e(asset('assets/icons/favicon.png')); ?>'" class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="text-4xl font-black text-primary">
                                        <?php echo e(strtoupper(substr($user->full_name, 0, 1))); ?><?php echo e(strtoupper(substr(strrchr($user->full_name, " "), 1, 1)) ?: ''); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <!-- Status Indicator -->
                        <div class="absolute -bottom-1 -right-1 w-8 h-8 bg-emerald-500 rounded-xl border-4 border-green-800 flex items-center justify-center">
                            <i class="fa-solid fa-check text-white text-xs"></i>
                        </div>
                    </div>
                    
                    <!-- Profile Info -->
                    <div class="flex-1">
                        <div class="flex items-center gap-3 mb-2">
                            <span class="px-3 py-1 bg-primary/20 text-primary text-xs font-bold rounded-full border border-primary/30">
                                <?php echo e($user->role === 'seller' ? 'Seller Account' : 'Member'); ?>

                            </span>
                            <span class="text-white/30 text-xs">•</span>
                            <span class="text-white/60 text-sm">Joined <?php echo e($user->created_at->format('F Y')); ?></span>
                        </div>
                        <h1 class="text-4xl font-black text-white tracking-tight mb-2">
                            <?php echo e($user->full_name); ?>

                        </h1>
                        <p class="text-white/60 text-lg">
                            <?php echo e($user->email); ?>

                        </p>
                    </div>
                    
                    <!-- Quick Actions -->
                    <div class="flex items-center gap-3">
                        <a href="<?php echo e(route('web.settings.personal-details')); ?>" class="px-6 py-3 bg-white/10 hover:bg-white/20 backdrop-blur-sm rounded-xl text-white font-bold text-sm border border-white/10 transition-all duration-300 hover:scale-105 flex items-center gap-2">
                            <i class="fa-solid fa-pen-to-square"></i>
                            Edit Profile
                        </a>
                        <form action="<?php echo e(route('logout')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="px-6 py-3 bg-red-500/20 hover:bg-red-500/30 backdrop-blur-sm rounded-xl text-red-400 font-bold text-sm border border-red-500/20 transition-all duration-300 hover:scale-105 flex items-center gap-2">
                                <i class="fa-solid fa-right-from-bracket"></i>
                                Sign Out
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="max-w-7xl mx-auto px-6 lg:px-8 -mt-16 pb-16 relative z-10">
            <div class="grid grid-cols-12 gap-6">
                
                <!-- Left Sidebar - Stats & Quick Info -->
                <div class="col-span-3 space-y-6">
                    <!-- Stats Card -->
                    <div class="bg-white rounded-2xl shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
                        <div class="p-6 border-b border-gray-50">
                            <h3 class="font-bold text-gray-900">Account Overview</h3>
                        </div>
                        <div class="p-4 space-y-4">
                            <div class="flex items-center justify-between p-3 bg-emerald-50/50 rounded-xl">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-emerald-100 flex items-center justify-center text-emerald-600">
                                        <i class="fa-solid fa-rectangle-list"></i>
                                    </div>
                                    <span class="font-medium text-gray-700">Active Ads</span>
                                </div>
                                <span id="desktop-stats-count" class="text-2xl font-black text-emerald-600"><?php echo e($listingsCount); ?></span>
                            </div>
                            <div class="flex items-center justify-between p-3 bg-blue-50/50 rounded-xl">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-blue-100 flex items-center justify-center text-blue-600">
                                        <i class="fa-solid fa-store"></i>
                                    </div>
                                    <span class="font-medium text-gray-700">Shops</span>
                                </div>
                                <span class="text-2xl font-black text-blue-600"><?php echo e($businesses->count()); ?></span>
                            </div>
                            <div class="flex items-center justify-between p-3 bg-orange-50/50 rounded-xl">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-orange-100 flex items-center justify-center text-orange-600">
                                        <i class="fa-regular fa-heart"></i>
                                    </div>
                                    <span class="font-medium text-gray-700">Favorites</span>
                                </div>
                                <span class="text-2xl font-black text-orange-600"><?php echo e($favoritesCount ?? 0); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Hot Deals Card -->
                    <a href="<?php echo e(route('listing.hot-deals')); ?>" class="relative block overflow-hidden rounded-2xl shadow-xl shadow-emerald-500/20 group">
                        <div class="absolute inset-0 bg-gradient-to-br from-emerald-600 to-emerald-900 group-hover:scale-105 transition-transform duration-500"></div>
                        <div class="absolute -right-6 -bottom-6 opacity-10 group-hover:rotate-12 transition-transform duration-500">
                            <i class="fa-solid fa-fire text-[120px] text-white"></i>
                        </div>
                        <div class="relative p-6">
                            <div class="flex items-center gap-2 mb-3">
                                <span class="bg-white text-emerald-900 text-[9px] font-black px-2 py-0.5 rounded-md">HOT</span>
                            </div>
                            <h3 class="text-white text-xl font-black italic tracking-tight mb-1">Hot Deals</h3>
                            <p class="text-emerald-100/80 text-xs">Discover amazing prices!</p>
                            <div class="mt-4 flex items-center text-white text-sm font-bold">
                                <span>Explore</span>
                                <i class="fa-solid fa-arrow-right ml-2 group-hover:translate-x-1 transition-transform"></i>
                            </div>
                        </div>
                    </a>
                </div>
                
                <!-- Main Content Area -->
                <div class="col-span-6 space-y-6">
                    <!-- Welcome Banner -->
                    <!-- Welcome Banner -->
                    <div class="bg-white rounded-2xl p-6 shadow-xl shadow-gray-200/50 border border-gray-100 flex items-center gap-5 relative overflow-hidden group">
                        <div class="absolute left-0 top-0 bottom-0 w-1.5 bg-gradient-to-b from-primary to-emerald-400"></div>
                        <div class="w-14 h-14 rounded-2xl bg-primary/5 flex items-center justify-center text-primary text-2xl group-hover:scale-110 transition-transform duration-300">
                            <i class="fa-solid fa-hand-wave"></i>
                        </div>
                        <div>
                            <h3 class="font-bold text-gray-900 text-lg">Welcome back, <?php echo e(explode(' ', $user->full_name)[0]); ?>!</h3>
                            <p class="text-gray-500 text-sm">Explore the latest deals and manage your listings from your dashboard.</p>
                        </div>
                    </div>
                    
                    <!-- Business / Shop Section -->
                    <?php if($businesses->count() > 0): ?>
                        <div class="bg-white rounded-2xl shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
                            <div class="px-6 py-5 border-b border-gray-50 flex items-center justify-between">
                                <h3 class="font-bold text-gray-900">Your Shops</h3>
                                <a href="<?php echo e(route('business.create')); ?>" class="text-primary text-sm font-bold hover:underline">+ Add New Shop</a>
                            </div>
                            <div class="p-4 grid grid-cols-2 gap-4">
                                <?php $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $isSelected = session('selected_business_id') == $business->id || (!session('selected_business_id') && $loop->first); ?>
                                    <div onclick="switchShop(<?php echo e($business->id); ?>)" 
                                         id="desktop-shop-card-<?php echo e($business->id); ?>"
                                         class="flex items-start gap-4 p-4 rounded-xl border <?php echo e($isSelected ? 'border-primary bg-primary/5 ring-1 ring-primary/20 shop-selected' : 'border-gray-100 bg-gray-50/30'); ?> hover:border-primary/30 hover:bg-white hover:shadow-lg transition-all duration-300 cursor-pointer group relative shop-card-desktop">
                                        
                                        <!-- Selection Indicator -->
                                        <div id="desktop-indicator-<?php echo e($business->id); ?>" class="absolute top-3 right-3 w-2 h-2 rounded-full bg-emerald-500 <?php echo e($isSelected ? '' : 'hidden'); ?>"></div>

                                            <div class="w-14 h-14 rounded-xl bg-white flex items-center justify-center border border-gray-200 overflow-hidden shadow-sm group-hover:scale-105 transition-transform">
                                                <?php if($business->logo_url): ?>
                                                    <img src="<?php echo e($business->logo_url); ?>" class="w-full h-full object-cover">
                                                <?php else: ?>
                                                    <span class="text-sm font-black text-primary"><?php echo e(strtoupper(substr($business->name, 0, 2))); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="flex-1 min-w-0">
                                                <h4 class="font-bold text-gray-900 truncate <?php echo e($isSelected ? 'text-primary' : ''); ?>"><?php echo e($business->name); ?></h4>
                                                <p class="text-sm text-gray-500"><?php echo e(ucfirst($business->business_type)); ?></p>
                                                <span class="inline-flex items-center gap-1 text-xs font-bold mt-2 <?php echo e($business->verification_status === 'verified' ? 'text-emerald-600' : 'text-orange-500'); ?>">
                                                    <i class="fa-solid <?php echo e($business->verification_status === 'verified' ? 'fa-badge-check' : 'fa-clock'); ?>"></i>
                                                    <?php echo e(ucfirst($business->verification_status)); ?>

                                                </span>
                                            </div>
                                        </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="bg-white rounded-2xl shadow-xl shadow-gray-200/50 border border-gray-100 p-8 text-center">
                            <div class="w-20 h-20 rounded-2xl bg-primary/5 flex items-center justify-center text-primary text-3xl mx-auto mb-5">
                                <i class="fa-solid fa-store"></i>
                            </div>
                            <h3 class="font-black text-gray-900 text-xl mb-2">Create Your First Shop</h3>
                            <p class="text-gray-500 text-sm mb-6 max-w-sm mx-auto">Set up your storefront to start listing products and services and reach more customers.</p>
                            <a href="<?php echo e(route('business.create')); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white font-bold rounded-xl hover:bg-primary/90 transition-all hover:scale-105">
                                <i class="fa-solid fa-plus"></i>
                                Create Shop
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Quick Actions Grid -->
                    <div class="grid grid-cols-2 gap-4">
                        <a href="<?php echo e(route('web.my-ads')); ?>" class="bg-white rounded-2xl shadow-lg shadow-gray-200/50 border border-gray-100 p-6 hover:border-primary/30 hover:shadow-xl transition-all duration-300 group">
                            <div class="w-12 h-12 rounded-xl bg-primary/5 flex items-center justify-center text-primary text-xl mb-4 group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-rectangle-list"></i>
                            </div>
                            <h4 class="font-bold text-gray-900 mb-1">My Ads</h4>
                            <p class="text-gray-500 text-sm">Manage your published listings</p>
                        </a>
                        <a href="<?php echo e(route('web.favorites')); ?>" class="bg-white rounded-2xl shadow-lg shadow-gray-200/50 border border-gray-100 p-6 hover:border-primary/30 hover:shadow-xl transition-all duration-300 group">
                            <div class="w-12 h-12 rounded-xl bg-primary/5 flex items-center justify-center text-primary text-xl mb-4 group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-regular fa-heart"></i>
                            </div>
                            <h4 class="font-bold text-gray-900 mb-1">Favorites</h4>
                            <p class="text-gray-500 text-sm">View your saved items</p>
                        </a>
                        <a href="<?php echo e(route('web.notifications')); ?>" class="bg-white rounded-2xl shadow-lg shadow-gray-200/50 border border-gray-100 p-6 hover:border-primary/30 hover:shadow-xl transition-all duration-300 group">
                            <div class="w-12 h-12 rounded-xl bg-primary/5 flex items-center justify-center text-primary text-xl mb-4 group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-bell"></i>
                            </div>
                            <h4 class="font-bold text-gray-900 mb-1">Notifications</h4>
                            <p class="text-gray-500 text-sm">Stay updated with alerts</p>
                        </a>
                        <a href="<?php echo e(route('web.membership.index')); ?>" class="bg-white rounded-2xl shadow-lg shadow-gray-200/50 border border-gray-100 p-6 hover:border-primary/30 hover:shadow-xl transition-all duration-300 group">
                            <div class="w-12 h-12 rounded-xl bg-purple-50 flex items-center justify-center text-purple-600 text-xl mb-4 group-hover:bg-purple-600 group-hover:text-white transition-all">
                                <i class="fa-solid fa-crown"></i>
                            </div>
                            <h4 class="font-bold text-gray-900 mb-1">Membership</h4>
                            <p class="text-gray-500 text-sm">Manage your subscription</p>
                        </a>
                        <a href="<?php echo e(route('web.settings')); ?>" class="bg-white rounded-2xl shadow-lg shadow-gray-200/50 border border-gray-100 p-6 hover:border-primary/30 hover:shadow-xl transition-all duration-300 group">
                            <div class="w-12 h-12 rounded-xl bg-primary/5 flex items-center justify-center text-primary text-xl mb-4 group-hover:bg-primary group-hover:text-white transition-all">
                                <i class="fa-solid fa-gears"></i>
                            </div>
                            <h4 class="font-bold text-gray-900 mb-1">Settings</h4>
                            <p class="text-gray-500 text-sm">Account & privacy settings</p>
                        </a>
                    </div>
                </div>
                
                <!-- Right Sidebar - Support & Legal -->
                <div class="col-span-3 space-y-6">
                    <!-- AI Support Card -->
                    <a href="<?php echo e(env('AI_URL')); ?>" target="_blank" class="block bg-gradient-to-br from-violet-600 to-purple-700 rounded-2xl shadow-xl shadow-violet-500/20 p-6 text-white overflow-hidden relative group hover:scale-[1.02] transition-transform duration-300">
                        <div class="absolute -right-4 -bottom-4 opacity-10 group-hover:rotate-12 transition-transform duration-500">
                            <i class="fa-solid fa-robot text-[100px]"></i>
                        </div>
                        <div class="relative">
                            <div class="w-12 h-12 rounded-xl bg-white/20 backdrop-blur-sm flex items-center justify-center mb-4 group-hover:bg-white/30 transition-colors">
                                <i class="fa-solid fa-robot text-xl"></i>
                            </div>
                            <h3 class="font-bold text-lg mb-1">AI Support</h3>
                            <p class="text-white/70 text-sm mb-4">Get instant help from our intelligent assistant.</p>
                            <div class="w-full py-3 bg-white text-violet-700 font-bold rounded-xl text-center shadow-lg group-hover:shadow-xl transition-all">
                                Start Chat
                            </div>
                        </div>
                    </a>
                    
                    <!-- Support Links -->
                    <div class="bg-white rounded-2xl shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
                        <div class="px-6 py-5 border-b border-gray-50">
                            <h3 class="font-bold text-gray-900">Help & Support</h3>
                        </div>
                        <div class="p-3 space-y-1">
                            <a href="<?php echo e(route('web.help-center')); ?>" class="flex items-center gap-3 p-3 hover:bg-gray-50 rounded-xl transition-colors group">
                                <i class="fa-solid fa-circle-question text-primary w-5"></i>
                                <span class="font-medium text-gray-700 group-hover:text-primary transition-colors">Help Center</span>
                            </a>
                            <button onclick="openSupportModal()" class="flex items-center gap-3 p-3 hover:bg-gray-50 rounded-xl transition-colors group w-full text-left">
                                <i class="fa-solid fa-headset text-primary w-5"></i>
                                <span class="font-medium text-gray-700 group-hover:text-primary transition-colors">Contact Support</span>
                            </button>
                            <a href="#" class="flex items-center gap-3 p-3 hover:bg-gray-50 rounded-xl transition-colors group">
                                <i class="fa-solid fa-message text-primary w-5"></i>
                                <span class="font-medium text-gray-700 group-hover:text-primary transition-colors">Send Feedback</span>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Legal Links -->
                    <div class="bg-white rounded-2xl shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
                        <div class="px-6 py-5 border-b border-gray-50">
                            <h3 class="font-bold text-gray-900">Legal</h3>
                        </div>
                        <div class="p-3 space-y-1">
                            <a href="<?php echo e(route('web.privacy')); ?>" class="flex items-center gap-3 p-3 hover:bg-gray-50 rounded-xl transition-colors group">
                                <i class="fa-solid fa-shield-halved text-gray-400 w-5"></i>
                                <span class="font-medium text-gray-700 group-hover:text-primary transition-colors">Privacy Policy</span>
                            </a>
                            <a href="<?php echo e(route('web.terms')); ?>" class="flex items-center gap-3 p-3 hover:bg-gray-50 rounded-xl transition-colors group">
                                <i class="fa-solid fa-file-contract text-gray-400 w-5"></i>
                                <span class="font-medium text-gray-700 group-hover:text-primary transition-colors">Terms of Service</span>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Version Info -->
                    <div class="text-center py-4">
                        <p class="text-gray-300 text-xs font-medium">Version 2.0.0 (Build 2025)</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('web.partials.support-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/profile.blade.php ENDPATH**/ ?>