<?php $__env->startSection('title', 'Payment Failed'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex flex-col items-center justify-center min-h-[80vh] px-6 py-12 text-center">
    <!-- Error Icon -->
    <div class="w-20 h-20 bg-red-50 rounded-full flex items-center justify-center mb-8">
        <i class="fa-solid fa-circle-xmark text-4xl text-red-500"></i>
    </div>

    <!-- Message -->
    <h1 class="text-2xl font-bold text-gray-900 mb-4">Payment Failed</h1>
    <p class="text-gray-600 mb-12 max-w-xs mx-auto">
        Something went wrong while processing your payment. This could be due to insufficient funds, an incorrect PIN, or a network timeout.
    </p>

    <!-- Actions -->
    <div class="w-full max-w-xs space-y-4">
        <a href="<?php echo e(route('web.membership.index', ['mode' => 'mobile'])); ?>" 
           class="flex items-center justify-center w-full h-14 bg-emerald-600 text-white font-bold rounded-2xl shadow-lg shadow-emerald-200 active:scale-95 transition-all">
            Retry Payment
        </a>
        
        <a href="https://yilick.ug/help-center" 
           class="flex items-center justify-center w-full h-14 bg-white border border-gray-200 text-gray-700 font-bold rounded-2xl active:scale-95 transition-all leading-none">
            Contact Support
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.mobile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/mobile/membership/failed.blade.php ENDPATH**/ ?>