<?php $__env->startSection('title', 'Safety Center - Safe Buying & Selling in Uganda | Yilick'); ?>
<?php $__env->startSection('meta_description', 'Learn how to stay safe while shopping online in Uganda. Guidelines for secure transactions, public meeting spots, and protecting your Yilick account.'); ?>
<?php $__env->startSection('meta_keywords', 'safe shopping uganda, online security kampala, marketplace safety africa, secure buy and sell, verify sellers yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pb-20">
    <!-- Header -->
    <div class="bg-white border-b border-gray-100 pt-8 pb-8 sticky top-0 md:static z-30">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto flex items-center gap-4">
                <a href="<?php echo e(route('web.help-center')); ?>" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-cool-gray hover:text-primary transition-colors">
                    <i class="fa-solid fa-chevron-left"></i>
                </a>
                <h1 class="text-xl font-black text-charcoal-gray tracking-tight">Safety Center</h1>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-12">
        <div class="max-w-3xl mx-auto text-center mb-16">
            <div class="w-20 h-20 rounded-3xl bg-orange-100 text-orange-600 flex items-center justify-center mx-auto mb-6 shadow-lg shadow-orange-100/50">
                <i class="fa-solid fa-shield-halved text-4xl"></i>
            </div>
            <h2 class="text-3xl font-black text-charcoal-gray mb-4">Your safety is our priority</h2>
            <p class="text-cool-gray text-lg">We're committed to making Yilick the safest place to buy and sell in Uganda. Follow these guidelines to stay protected.</p>
        </div>

        <div class="max-w-4xl mx-auto space-y-12">
            <!-- Account Safety -->
            <section>
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 rounded-xl bg-blue-50 text-blue-600 flex items-center justify-center">
                        <i class="fa-solid fa-user-shield"></i>
                    </div>
                    <h3 class="text-2xl font-black text-charcoal-gray">Account Safety</h3>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="bg-white p-6 rounded-3xl shadow-sm border border-gray-100">
                        <i class="fa-solid fa-key text-blue-400 text-2xl mb-4"></i>
                        <h4 class="font-bold text-lg mb-2">Strong Passwords</h4>
                        <p class="text-cool-gray text-sm leading-relaxed">Use a unique combination of letters, numbers, and symbols. Never share your password with anyone.</p>
                    </div>
                    <div class="bg-white p-6 rounded-3xl shadow-sm border border-gray-100">
                        <i class="fa-solid fa-id-card text-blue-400 text-2xl mb-4"></i>
                        <h4 class="font-bold text-lg mb-2">Verify Identity</h4>
                        <p class="text-cool-gray text-sm leading-relaxed">Verified accounts build trust. Complete your profile verification to show buyers you're genuine.</p>
                    </div>
                    <div class="bg-white p-6 rounded-3xl shadow-sm border border-gray-100">
                        <i class="fa-solid fa-user-lock text-blue-400 text-2xl mb-4"></i>
                        <h4 class="font-bold text-lg mb-2">Private Info</h4>
                        <p class="text-cool-gray text-sm leading-relaxed">Be careful about sharing personal documents or sensitive information in public chats.</p>
                    </div>
                </div>
            </section>

            <!-- Transaction Safety -->
            <section>
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 rounded-xl bg-emerald-50 text-emerald-600 flex items-center justify-center">
                        <i class="fa-solid fa-hand-holding-dollar"></i>
                    </div>
                    <h3 class="text-2xl font-black text-charcoal-gray">Transaction Safety</h3>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-white p-8 rounded-3xl shadow-sm border border-gray-100 flex gap-6">
                        <div class="w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-location-dot"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-lg mb-2">Meet in Public</h4>
                            <p class="text-cool-gray leading-relaxed text-sm">Always arrange transactions in safe, public places like malls, gas stations, or busy cafes during daylight hours. Never go alone.</p>
                        </div>
                    </div>
                    <div class="bg-white p-8 rounded-3xl shadow-sm border border-gray-100 flex gap-6">
                        <div class="w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-magnifying-glass-dollar"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-lg mb-2">Inspect then Pay</h4>
                            <p class="text-cool-gray leading-relaxed text-sm">Carefully check the item before paying. If you're buying a car or electronics, test it thoroughly or bring a professional.</p>
                        </div>
                    </div>
                    <div class="bg-white p-8 rounded-3xl shadow-sm border border-gray-100 flex gap-6">
                        <div class="w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-credit-card"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-lg mb-2">Secure Payments</h4>
                            <p class="text-cool-gray leading-relaxed text-sm">Use mobile money or cash only after receiving the item. Avoid bank transfers or western union for people you haven't met.</p>
                        </div>
                    </div>
                    <div class="bg-white p-8 rounded-3xl shadow-sm border border-gray-100 flex gap-6">
                        <div class="w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-triangle-exclamation"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-lg mb-2">Avoid Pre-payments</h4>
                            <p class="text-cool-gray leading-relaxed text-sm">Yilick never asks for payments to "reserve" an item. Be wary of sellers who ask for shipping fees or deposits upfront.</p>
                        </div>
                    </div>
                </div>
            </section>
        </div>

        <!-- Help Banner -->
        <div class="max-w-4xl mx-auto mt-20 bg-charcoal-gray rounded-[40px] p-10 md:p-16 text-white text-center relative overflow-hidden shadow-2xl">
            <div class="absolute top-0 right-0 w-64 h-64 bg-primary/10 rounded-full -mr-32 -mt-32 blur-3xl"></div>
            <div class="relative z-10">
                <h3 class="text-3xl font-black mb-6">See something suspicious?</h3>
                <p class="text-white/60 mb-10 max-w-xl mx-auto">Help us keep Yilick safe by reporting fraudulent listings or suspicious behavior immediately.</p>
                <button onclick="openSupportModal('Safety & Security')" class="bg-primary hover:bg-emerald-600 text-white font-black px-10 py-4 rounded-2xl transition-all hover:scale-105 active:scale-95 shadow-xl shadow-primary/20">
                    Report an Issue
                </button>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('web.partials.support-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/safety-center.blade.php ENDPATH**/ ?>