<?php $__env->startSection('title', 'Notification Center'); ?>
<?php $__env->startSection('header_title', 'Notification Center'); ?>

<?php $__env->startSection('content'); ?>
<div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
    <!-- Individual Notification -->
    <div class="space-y-6">
        <div class="bg-white rounded-[2rem] border border-gray-100 shadow-sm p-8 h-full">
            <div class="flex items-center gap-4 mb-8">
                <div class="w-12 h-12 rounded-2xl bg-primary/10 text-primary flex items-center justify-center text-xl">
                    <i class="fa-solid fa-paper-plane"></i>
                </div>
                <div>
                    <h3 class="font-black text-gray-900 uppercase tracking-tighter text-lg leading-none">Individual Alert</h3>
                    <p class="text-[10px] font-bold text-gray-400 mt-1 uppercase tracking-widest">Targeted push notification</p>
                </div>
            </div>

            <form action="<?php echo e(route('admin.notifications.send')); ?>" method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Select Recipient</label>
                    <select name="user_id" required class="w-full px-4 py-4 rounded-2xl bg-gray-50 border border-gray-100 text-sm focus:bg-white focus:border-primary outline-none transition-all font-medium">
                        <option value="">Choose a user...</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->full_name); ?> (<?php echo e($user->email); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Notification Title</label>
                    <input type="text" name="title" required placeholder="e.g. Account Update" 
                           class="w-full px-4 py-4 rounded-2xl bg-gray-50 border border-gray-100 text-sm focus:bg-white focus:border-primary outline-none transition-all font-bold">
                </div>

                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Message Content</label>
                    <textarea name="body" rows="4" required placeholder="Type your message here..." 
                              class="w-full px-4 py-4 rounded-2xl bg-gray-50 border border-gray-100 text-sm focus:bg-white focus:border-primary outline-none transition-all leading-relaxed"></textarea>
                </div>

                <button type="submit" class="w-full py-4 bg-primary text-white font-bold rounded-2xl shadow-lg shadow-primary/20 hover:bg-emerald-600 transition-all flex items-center justify-center gap-3">
                    <span>Send Notification</span>
                    <i class="fa-solid fa-location-arrow text-sm"></i>
                </button>
            </form>
        </div>
    </div>

    <!-- Broadcast Notification -->
    <div class="space-y-6">
        <div class="bg-gray-800 rounded-[2rem] shadow-xl p-8 text-white relative overflow-hidden h-full">
            <div class="relative z-10">
                <div class="flex items-center gap-4 mb-8">
                    <div class="w-12 h-12 rounded-2xl bg-white/10 text-primary flex items-center justify-center text-xl">
                        <i class="fa-solid fa-tower-broadcast"></i>
                    </div>
                    <div>
                        <h3 class="font-black text-white uppercase tracking-tighter text-lg leading-none">Global Broadcast</h3>
                        <p class="text-[10px] font-bold text-white/40 mt-1 uppercase tracking-widest">Alerts all active devices</p>
                    </div>
                </div>

                <form action="<?php echo e(route('admin.notifications.broadcast')); ?>" method="POST" class="space-y-6">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-white/40 ml-1">Broadcast Title</label>
                        <input type="text" name="title" required placeholder="e.g. System Maintenance" 
                               class="w-full px-4 py-4 rounded-2xl bg-white/5 border border-white/10 text-sm focus:bg-white/10 focus:border-primary outline-none transition-all font-bold text-white">
                    </div>

                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-white/40 ml-1">Broadcast Message</label>
                        <textarea name="body" rows="4" required placeholder="This will be seen by all users..." 
                                  class="w-full px-4 py-4 rounded-2xl bg-white/5 border border-white/10 text-sm focus:bg-white/10 focus:border-primary outline-none transition-all leading-relaxed text-white"></textarea>
                    </div>

                    <div class="bg-vibrant-orange/10 border border-vibrant-orange/20 p-4 rounded-2xl flex items-start gap-3">
                        <i class="fa-solid fa-triangle-exclamation text-vibrant-orange mt-0.5"></i>
                        <p class="text-[10px] font-bold text-vibrant-orange uppercase leading-relaxed">
                            Warning: This will send a push notification to every user with an active FCM token. Use sparingly.
                        </p>
                    </div>

                    <button type="submit" onclick="return confirm('Are you absolutely sure you want to broadcast this message to ALL users?');" 
                            class="w-full py-4 bg-white text-gray-900 font-bold rounded-2xl shadow-lg shadow-white/5 hover:bg-gray-100 transition-all flex items-center justify-center gap-3">
                        <span>Initialize Broadcast</span>
                        <i class="fa-solid fa-bolt text-sm"></i>
                    </button>
                </form>
            </div>
            <i class="fa-solid fa-bullhorn absolute -right-8 -bottom-8 text-[12rem] text-white/5 -rotate-12"></i>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/admin/notifications/index.blade.php ENDPATH**/ ?>