<?php $__env->startSection('title', 'Create Account - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-[80vh] flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8 bg-gray-50/50 relative overflow-hidden">
    <!-- Decorative background elements -->
    <div class="absolute top-0 right-0 -translate-y-1/2 translate-x-1/2 w-96 h-96 bg-primary/5 rounded-full blur-3xl pointer-events-none"></div>
    <div class="absolute bottom-0 left-0 translate-y-1/2 -translate-x-1/2 w-80 h-80 bg-primary/5 rounded-full blur-3xl pointer-events-none"></div>

    <div class="w-full max-w-md relative">
        <!-- Main Card -->
        <div class="bg-white rounded-[2.5rem] shadow-xl shadow-gray-200/40 border border-gray-100 p-8 md:p-10 relative z-10">
            <!-- Logo & Header -->
            <div class="text-center mb-8">
                <div class="w-20 h-20 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-6 ring-4 ring-primary/5">
                    <img src="<?php echo e(asset('assets/icons/logo.png')); ?>" alt="Yilick" class="w-12 h-12 object-contain" onerror="this.outerHTML='<i class=\'fa-solid fa-store text-primary text-2xl\'></i>'">
                </div>
                <h1 class="text-3xl font-black text-gray-900 tracking-tight mb-2">Join Yilick</h1>
                <p class="text-gray-500 font-medium text-sm">Create an account to start trading</p>
            </div>

            <!-- Register Form -->
            <form action="<?php echo e(route('register')); ?>" method="POST" class="space-y-5">
                <?php echo csrf_field(); ?>
                
                <!-- Full Name -->
                <div class="space-y-1.5">
                    <label for="full_name" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Full Name</label>
                    <div class="relative group">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-primary transition-colors">
                            <i class="fa-regular fa-user text-lg"></i>
                        </div>
                        <input type="text" name="full_name" id="full_name" value="<?php echo e(old('full_name')); ?>" placeholder="Your full name" required
                               class="w-full pl-12 pr-4 py-3.5 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 text-sm">
                    </div>
                    <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-[10px] font-bold mt-1 ml-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Email -->
                <div class="space-y-1.5">
                    <label for="email" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Email Address</label>
                    <div class="relative group">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-primary transition-colors">
                            <i class="fa-regular fa-envelope text-lg"></i>
                        </div>
                        <input type="email" name="email" id="email" value="<?php echo e(old('email')); ?>" placeholder="your@email.com" required
                               class="w-full pl-12 pr-4 py-3.5 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 text-sm">
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-[10px] font-bold mt-1 ml-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Phone -->
                <div class="space-y-1.5">
                    <label for="phone" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Phone Number</label>
                    <div class="flex gap-2">
                        <div class="relative min-w-[90px]">
                            <div class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400">
                                <span class="text-sm font-bold">🇺🇬</span>
                            </div>
                            <select class="w-full pl-10 pr-2 py-3.5 rounded-2xl bg-gray-50 border border-gray-100 outline-none font-bold text-gray-700 text-sm appearance-none cursor-pointer">
                                <option>+256</option>
                            </select>
                            <div class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none">
                                <i class="fa-solid fa-chevron-down text-[10px]"></i>
                            </div>
                        </div>
                        <div class="relative group flex-1">
                            <input type="tel" name="phone" id="phone" value="<?php echo e(old('phone')); ?>" placeholder="712345678" required
                                   class="w-full px-4 py-3.5 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 text-sm">
                        </div>
                    </div>
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-[10px] font-bold mt-1 ml-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Passwords -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-1.5 text-left">
                        <label for="password" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Password</label>
                        <div class="relative group">
                            <input type="password" name="password" id="password" placeholder="••••••••" required
                                   class="w-full px-4 pr-12 py-3.5 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 text-sm">
                            <button type="button" onclick="togglePassword('password', this)" class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-primary transition-colors">
                                <i class="fa-regular fa-eye"></i>
                            </button>
                        </div>
                    </div>
                    <div class="space-y-1.5 text-left">
                        <label for="password_confirmation" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Confirm</label>
                        <div class="relative group">
                            <input type="password" name="password_confirmation" id="password_confirmation" placeholder="••••••••" required
                                   class="w-full px-4 pr-12 py-3.5 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 text-sm">
                            <button type="button" onclick="togglePassword('password_confirmation', this)" class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-primary transition-colors">
                                <i class="fa-regular fa-eye"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-[10px] font-bold mt-1 ml-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <script>
                    function togglePassword(id, btn) {
                        const input = document.getElementById(id);
                        const icon = btn.querySelector('i');
                        if (input.type === 'password') {
                            input.type = 'text';
                            icon.classList.remove('fa-eye');
                            icon.classList.add('fa-eye-slash');
                        } else {
                            input.type = 'password';
                            icon.classList.remove('fa-eye-slash');
                            icon.classList.add('fa-eye');
                        }
                    }
                </script>

                <!-- Referral Code -->
                <div class="space-y-1.5">
                    <div class="flex items-center justify-between ml-1">
                        <label for="referral_code" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest">Referral Code</label>
                        <span class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Optional</span>
                    </div>
                    <div class="relative group">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-primary transition-colors">
                            <i class="fa-solid fa-gift text-sm"></i>
                        </div>
                        <input type="text" name="referral_code" id="referral_code" value="<?php echo e(old('referral_code')); ?>" placeholder="Enter code"
                               class="w-full pl-12 pr-4 py-3.5 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 text-sm uppercase tracking-widest">
                    </div>
                </div>

                <!-- Terms -->
                <p class="text-center text-[10px] text-gray-400 font-bold leading-relaxed px-4">
                    By registering, you agree to our 
                    <a href="<?php echo e(route('web.terms')); ?>" class="text-primary hover:underline">Terms of Service</a> and 
                    <a href="<?php echo e(route('web.privacy')); ?>" class="text-primary hover:underline">Privacy Policy</a>
                </p>

                <!-- Submit Button -->
                <button type="submit" 
                        class="w-full py-4 bg-primary hover:bg-emerald-600 text-white font-bold rounded-2xl shadow-lg shadow-primary/20 hover:shadow-primary/30 transform hover:-translate-y-0.5 active:scale-[0.98] transition-all flex items-center justify-center gap-3 mt-4">
                    <span>Create Account</span>
                    <i class="fa-solid fa-arrow-right text-sm"></i>
                </button>
            </form>

            <!-- Divider -->
            <div class="relative my-8">
                <div class="absolute inset-0 flex items-center">
                    <div class="w-full border-t border-gray-100"></div>
                </div>
                <div class="relative flex justify-center text-sm">
                    <span class="px-4 bg-white text-gray-400 font-bold uppercase tracking-widest text-[10px]">Or</span>
                </div>
            </div>

            <!-- Login Link -->
            <div class="text-center">
                <a href="<?php echo e(route('login')); ?>" class="inline-flex items-center gap-2 text-gray-600 hover:text-primary transition-all font-bold px-8 py-4 rounded-2xl border border-gray-200 hover:border-primary hover:bg-primary/5 w-full justify-center group">
                    <i class="fa-solid fa-right-to-bracket group-hover:scale-110 transition-transform"></i>
                    <span>Already have an account?</span>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/auth/register.blade.php ENDPATH**/ ?>