<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('header_title', 'User Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Filters & Search -->
    <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm">
        <form action="<?php echo e(route('admin.users.index')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div class="md:col-span-2">
                <div class="relative">
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search by name, email, or phone..." 
                           class="w-full pl-10 pr-4 py-2.5 rounded-xl border border-gray-200 focus:border-primary focus:ring-2 focus:ring-primary/10 outline-none text-sm transition-all">
                    <i class="fa-solid fa-search absolute left-3.5 top-1/2 -translate-y-1/2 text-gray-400"></i>
                </div>
            </div>
            
            <div>
                <select name="role" class="w-full px-4 py-2.5 rounded-xl border border-gray-200 focus:border-primary outline-none text-sm bg-white">
                    <option value="">All Roles</option>
                    <option value="user" <?php echo e(request('role') == 'user' ? 'selected' : ''); ?>>User</option>
                    <option value="seller" <?php echo e(request('role') == 'seller' ? 'selected' : ''); ?>>Seller</option>
                    <option value="admin" <?php echo e(request('role') == 'admin' ? 'selected' : ''); ?>>Admin</option>
                </select>
            </div>
            
            <div class="flex gap-2">
                <button type="submit" class="flex-1 bg-primary text-white py-2.5 rounded-xl font-bold text-sm hover:bg-emerald-600 transition-all flex items-center justify-center gap-2">
                    <i class="fa-solid fa-filter"></i>
                    Filter
                </button>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="px-4 py-2.5 bg-gray-100 text-gray-600 rounded-xl font-bold text-sm hover:bg-gray-200 transition-all flex items-center justify-center">
                    <i class="fa-solid fa-rotate-left"></i>
                </a>
            </div>
        </form>
    </div>

    <!-- Users Table -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left text-sm">
                <thead class="bg-gray-50 text-[10px] font-black uppercase text-gray-400">
                    <tr>
                        <th class="px-6 py-4">User</th>
                        <th class="px-6 py-4">Contact</th>
                        <th class="px-6 py-4">Role & Status</th>
                        <th class="px-6 py-4">Joined</th>
                        <th class="px-6 py-4 text-right">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 transition-all">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center text-gray-400 font-bold overflow-hidden">
                                        <?php if($user->profile_photo): ?>
                                            <img src="<?php echo e($user->profile_photo_url); ?>" class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <?php echo e(substr($user->full_name, 0, 1)); ?>

                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800"><?php echo e($user->full_name); ?></div>
                                        <div class="text-[10px] font-medium text-gray-400 uppercase">UID: <?php echo e($user->uuid); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-medium text-gray-700"><?php echo e($user->email); ?></div>
                                <div class="text-[10px] text-gray-400 font-bold"><?php echo e($user->phone); ?></div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-2 mb-1">
                                    <span class="px-2 py-0.5 rounded text-[10px] font-black uppercase <?php echo e($user->role === 'admin' ? 'bg-purple-50 text-purple-600' : ($user->role === 'seller' ? 'bg-blue-50 text-blue-600' : 'bg-gray-50 text-gray-600')); ?>">
                                        <?php echo e($user->role); ?>

                                    </span>
                                </div>
                                <span class="flex items-center gap-1.5 text-[11px] font-bold <?php echo e($user->status === 'active' ? 'text-emerald-500' : 'text-red-500'); ?>">
                                    <i class="fa-solid fa-circle text-[6px]"></i>
                                    <?php echo e(ucfirst($user->status)); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 text-gray-500 font-medium whitespace-nowrap">
                                <?php echo e($user->created_at->format('M d, Y')); ?>

                            </td>
                            <td class="px-6 py-4 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="p-2 text-gray-400 hover:text-primary hover:bg-primary/5 rounded-lg transition-all" title="View Details">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-gray-400">
                                <i class="fa-solid fa-users text-4xl mb-4 opacity-20"></i>
                                <p class="text-sm font-medium">No users found matching your criteria.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <?php if($users->hasPages()): ?>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-100">
                <?php echo e($users->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/admin/users/index.blade.php ENDPATH**/ ?>