<?php $__env->startSection('title', 'Download Yilick App - Mobile Business Tools for Uganda'); ?>
<?php $__env->startSection('meta_description', 'Get the Yilick mobile app for Android and iOS. Access professional business management tools, AI insights, and the fastest marketplace in Uganda.'); ?>

<?php $__env->startSection('header_meta'); ?>
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "SoftwareApplication",
    "name": "Yilick",
    "operatingSystem": "Android, iOS",
    "applicationCategory": "BusinessApplication, ShoppingApplication",
    "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "4.9",
        "ratingCount": "12000"
    },
    "offers": {
        "@type": "Offer",
        "price": "0",
        "priceCurrency": "UGX"
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-white font-sans selection:bg-primary/20">
    <!-- Hero Section -->
    <div class="relative overflow-hidden bg-gray-900 pt-16 pb-20 lg:pt-24 lg:pb-32">
        <!-- Abstract Background -->
        <div class="absolute inset-0 overflow-hidden">
            <div class="absolute top-0 left-1/2 -translate-x-1/2 w-[1000px] h-[600px] bg-gradient-to-b from-primary/20 to-transparent opacity-40 blur-[100px]"></div>
            <div class="absolute bottom-0 right-0 w-[800px] h-[800px] bg-gradient-to-t from-vibrant-orange/10 to-transparent opacity-30 blur-[120px]"></div>
        </div>

        <div class="container mx-auto px-4 relative z-10">
            <div class="flex flex-col lg:flex-row items-center gap-10 lg:gap-16">
                <!-- Content -->
                <div class="flex-1 text-center lg:text-left">
                    <div class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/5 border border-white/10 text-white/90 text-xs font-medium mb-6 backdrop-blur-md animate-in slide-in-from-bottom-4 duration-700">
                        <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                        <span>Version 2.0 Now Available</span>
                    </div>
                    
                    <h1 class="text-4xl lg:text-5xl font-bold text-white mb-4 tracking-tight leading-tight animate-in slide-in-from-bottom-8 duration-700 delay-100">
                        Run Your Business <br/>
                        <span class="text-transparent bg-clip-text bg-gradient-to-r from-emerald-400 to-emerald-600">From Your Pocket</span>
                    </h1>
                    
                    <p class="text-lg text-gray-400 mb-8 max-w-xl mx-auto lg:mx-0 leading-relaxed animate-in slide-in-from-bottom-8 duration-700 delay-200">
                        Transform your smartphone into a powerful business command center. Access exclusive mobile-first tools designed to scale your operations.
                    </p>

                   <div class="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-3 animate-in slide-in-from-bottom-8 duration-700 delay-300">
                          <a href="https://play.google.com/store/apps/details?id=xyz.xperbyte.yilick" class="w-full sm:w-auto flex items-center gap-3 bg-white text-gray-900 px-6 py-3 rounded-xl hover:scale-105 transition-all duration-300 group">
                            <i class="fa-brands fa-google-play text-2xl text-emerald-600 group-hover:text-emerald-700 transition-colors"></i>
                            <div class="text-left">
                                <div class="text-[9px] font-bold text-gray-500 uppercase tracking-wider mb-0.5">Get it on</div>
                                <div class="text-sm font-bold leading-none">Google Play</div>
                            </div>
                        </a>
                        
                        <a href="https://apps.apple.com/ug/app/yilick/id6757166167" class="w-full sm:w-auto flex items-center gap-3 bg-white/10 text-white px-6 py-3 rounded-xl backdrop-blur-sm border border-white/10 hover:bg-white/20 transition-all duration-300">
                            <i class="fa-brands fa-apple text-2xl"></i>
                            <div class="text-left">
                                <div class="text-[9px] font-bold text-white/60 uppercase tracking-wider mb-0.5">Download on</div>
                                <div class="text-sm font-bold leading-none">App Store</div>
                            </div>
                        </a>
                    </div>
                    
                    <div class="mt-6 flex items-center justify-center lg:justify-start gap-4 text-gray-500 text-xs font-medium animate-in slide-in-from-bottom-8 duration-700 delay-400">
                        <a href="https://m.yilick.ug" class="hover:text-white transition-colors flex items-center gap-2">
                            <i class="fas fa-globe"></i> Web App
                        </a>
                        <span class="text-gray-700">•</span>
                        <button onclick="addToHomeScreen()" class="hover:text-white transition-colors flex items-center gap-2">
                            <i class="fa-solid fa-cloud-arrow-down"></i> Install PWA
                        </button>
                    </div>
                </div>

                <!-- Phone Visual -->
                <div class="flex-1 w-full max-w-[240px] lg:max-w-[280px] relative lg:translate-y-4 animate-in fade-in slide-in-from-right-8 duration-1000 delay-200">
                    <div class="relative z-10 w-full aspect-[9/18] bg-[#111] rounded-[2.5rem] border-[6px] border-[#222] shadow-2xl overflow-hidden ring-1 ring-white/10">
                         <!-- Screen Content Simulation -->
                        <div class="absolute inset-0 bg-gray-50 flex flex-col">
                            <!-- Header -->
                            <div class="bg-white p-5 pb-3 border-b border-gray-100 pt-10">
                                <div class="flex items-center justify-between mb-4">
                                    <div>
                                        <div class="text-[10px] text-gray-500 font-medium">Good Morning,</div>
                                        <div class="text-lg font-bold text-gray-900">Kampala Electronics</div>
                                    </div>
                                    <div class="w-8 h-8 bg-gray-100 rounded-full flex items-center justify-center">
                                        <i class="fa-regular fa-bell text-gray-600 text-xs"></i>
                                    </div>
                                </div>
                                <div class="flex gap-2 overflow-x-auto pb-2 scrollbar-hide">
                                    <div class="flex-shrink-0 px-3 py-1.5 bg-gray-900 text-white rounded-full text-[10px] font-medium">Overview</div>
                                    <div class="flex-shrink-0 px-3 py-1.5 bg-white border border-gray-200 text-gray-600 rounded-full text-[10px] font-medium">Orders</div>
                                    <div class="flex-shrink-0 px-3 py-1.5 bg-white border border-gray-200 text-gray-600 rounded-full text-[10px] font-medium">Products</div>
                                </div>
                            </div>
                            
                            <!-- Stats -->
                            <div class="p-4 grid grid-cols-2 gap-3">
                                <div class="bg-emerald-50 p-3 rounded-xl">
                                    <div class="text-emerald-600 text-sm mb-1"><i class="fa-solid fa-chart-pie"></i></div>
                                    <div class="text-lg font-bold text-gray-900">UGX 2.4M</div>
                                    <div class="text-[9px] text-emerald-700 font-medium">+12% this week</div>
                                </div>
                                <div class="bg-orange-50 p-3 rounded-xl">
                                    <div class="text-orange-600 text-sm mb-1"><i class="fa-solid fa-bag-shopping"></i></div>
                                    <div class="text-lg font-bold text-gray-900">142</div>
                                    <div class="text-[9px] text-orange-700 font-medium">New Orders</div>
                                </div>
                            </div>

                            <!-- List -->
                            <div class="flex-1 bg-white rounded-t-3xl p-4 shadow-[-4px_0_24px_rgba(0,0,0,0.04)]">
                                <div class="flex items-center justify-between mb-3">
                                    <div class="font-bold text-gray-900 text-sm">Recent Activity</div>
                                    <div class="text-[10px] text-emerald-600 font-bold">See All</div>
                                </div>
                                <div class="space-y-3">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-blue-50 flex items-center justify-center text-blue-600 text-xs"><i class="fa-solid fa-file-invoice"></i></div>
                                        <div class="flex-1">
                                            <div class="text-xs font-bold text-gray-900">Invoice #1024</div>
                                            <div class="text-[10px] text-gray-400">Sent to John Doe</div>
                                        </div>
                                        <div class="text-[10px] font-bold text-gray-900">1m ago</div>
                                    </div>
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-purple-50 flex items-center justify-center text-purple-600 text-xs"><i class="fa-solid fa-wand-magic-sparkles"></i></div>
                                        <div class="flex-1">
                                            <div class="text-xs font-bold text-gray-900">AI Insight</div>
                                            <div class="text-[10px] text-gray-400">Stock running low on...</div>
                                        </div>
                                        <div class="text-[10px] font-bold text-gray-900">15m ago</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                     <!-- Floating Badges -->
                    <div class="absolute top-[20%] -left-4 bg-white p-3 rounded-xl shadow-lg animate-bounce [animation-duration:4s] z-20">
                        <div class="flex items-center gap-2">
                             <div class="w-8 h-8 rounded-full bg-emerald-100 flex items-center justify-center text-emerald-600 text-sm">
                                <i class="fa-solid fa-robot"></i>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-900">AI Assistant</div>
                                <div class="text-[9px] text-gray-500">Restock suggestion</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Features Grid -->
    <div class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="text-center max-w-2xl mx-auto mb-12">
                <span class="text-emerald-600 font-bold text-xs tracking-wider uppercase mb-2 block">Premium Features</span>
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">Everything You Need to Scale</h2>
                <p class="text-gray-600 text-sm md:text-base leading-relaxed">We've packed the mobile app with power-user tools that aren't available anywhere else.</p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-5">
                
                <!-- Inventory Management -->
                <div class="bg-white p-5 rounded-2xl border border-gray-100 hover:shadow-lg hover:-translate-y-1 transition-all duration-300 group">
                    <div class="w-10 h-10 rounded-xl bg-blue-50 flex items-center justify-center text-blue-600 text-lg mb-4 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-boxes-stacked"></i>
                    </div>
                    <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-blue-600 transition-colors">Inventory Management</h3>
                    <p class="text-gray-500 leading-relaxed text-xs">Advanced stock control with real-time tracking, multi-location support, and AI-powered stock predictions.</p>
                </div>

                <!-- Point of Sale -->
                <div class="bg-white p-5 rounded-2xl border border-gray-100 hover:shadow-lg hover:-translate-y-1 transition-all duration-300 relative overflow-hidden group">
                     <div class="absolute top-3 right-3 bg-gray-900 text-white text-[9px] font-bold px-2 py-0.5 rounded-full uppercase tracking-wider">Mobile Exclusive</div>
                    <div class="w-10 h-10 rounded-xl bg-emerald-50 flex items-center justify-center text-emerald-600 text-lg mb-4 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-cash-register"></i>
                    </div>
                    <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-emerald-600 transition-colors">Point of Sale</h3>
                    <p class="text-gray-500 leading-relaxed text-xs">Complete POS system with offline support, customer management, and detailed sales analytics.</p>
                </div>

                <!-- Business Analytics -->
                <div class="bg-white p-5 rounded-2xl border border-gray-100 hover:shadow-lg hover:-translate-y-1 transition-all duration-300 relative overflow-hidden group">
                    <div class="absolute top-3 right-3 bg-gray-900 text-white text-[9px] font-bold px-2 py-0.5 rounded-full uppercase tracking-wider">Mobile Exclusive</div>
                    <div class="w-10 h-10 rounded-xl bg-orange-50 flex items-center justify-center text-orange-600 text-lg mb-4 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-chart-line"></i>
                    </div>
                    <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-orange-600 transition-colors">Business Analytics</h3>
                    <p class="text-gray-500 leading-relaxed text-xs">Comprehensive analytics dashboard with real-time metrics, custom reports, and performance tracking.</p>
                </div>

                <!-- AI Insights -->
                <div class="bg-white p-5 rounded-2xl border border-gray-100 hover:shadow-lg hover:-translate-y-1 transition-all duration-300 relative overflow-hidden group">
                     <div class="absolute top-3 right-3 bg-gray-900 text-white text-[9px] font-bold px-2 py-0.5 rounded-full uppercase tracking-wider">Mobile Exclusive</div>
                    <div class="w-10 h-10 rounded-xl bg-purple-50 flex items-center justify-center text-purple-600 text-lg mb-4 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-wand-magic-sparkles"></i>
                    </div>
                    <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-purple-600 transition-colors">AI-Powered Insights</h3>
                    <p class="text-gray-500 leading-relaxed text-xs">Advanced AI algorithms analyze your data to provide actionable insights and growth recommendations.</p>
                </div>

                <!-- Business Cards -->
                <div class="bg-white p-5 rounded-2xl border border-gray-100 hover:shadow-lg hover:-translate-y-1 transition-all duration-300 relative overflow-hidden group">
                     <div class="absolute top-3 right-3 bg-gray-900 text-white text-[9px] font-bold px-2 py-0.5 rounded-full uppercase tracking-wider">Mobile Exclusive</div>
                    <div class="w-10 h-10 rounded-xl bg-pink-50 flex items-center justify-center text-pink-600 text-lg mb-4 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-id-card"></i>
                    </div>
                    <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-pink-600 transition-colors">Digital Business Cards</h3>
                    <p class="text-gray-500 leading-relaxed text-xs">Digital business card creator with custom templates, QR codes, and instant sharing capabilities.</p>
                </div>

                <!-- Invoice Generator -->
                <div class="bg-white p-5 rounded-2xl border border-gray-100 hover:shadow-lg hover:-translate-y-1 transition-all duration-300 relative overflow-hidden group">
                     <div class="absolute top-3 right-3 bg-gray-900 text-white text-[9px] font-bold px-2 py-0.5 rounded-full uppercase tracking-wider">Mobile Exclusive</div>
                    <div class="w-10 h-10 rounded-xl bg-teal-50 flex items-center justify-center text-teal-600 text-lg mb-4 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-file-invoice-dollar"></i>
                    </div>
                    <h3 class="text-base font-bold text-gray-900 mb-2 group-hover:text-teal-600 transition-colors">Invoice Generator</h3>
                    <p class="text-gray-500 leading-relaxed text-xs">Professional invoice creation with automated numbering, multiple currencies, and instant delivery.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="py-16 bg-white relative overflow-hidden">
        <div class="absolute top-0 left-1/2 -translate-x-1/2 w-[1200px] h-full bg-gradient-to-r from-gray-50 via-white to-gray-50 -skew-y-3 -z-10"></div>
        <div class="container mx-auto px-4 text-center">
            <h2 class="text-3xl md:text-4xl font-black text-gray-900 mb-4">Transform Your Business Operations</h2>
            <p class="text-lg text-gray-500 mb-8 max-w-xl mx-auto leading-normal">
                Join thousands of businesses using Yilick's mobile-first tools to streamline operations and drive growth.
            </p>
            <div class="flex flex-col sm:flex-row items-center justify-center gap-3">
                 <a href="#" class="px-6 py-3 bg-primary text-white rounded-xl font-bold text-base hover:bg-emerald-700 hover:shadow-lg hover:-translate-y-0.5 transition-all w-full sm:w-auto">
                    Get Started Today
                </a>
                 <a href="<?php echo e(route('web.home')); ?>" class="px-6 py-3 bg-gray-100 text-gray-900 rounded-xl font-bold text-base hover:bg-gray-200 transition-all w-full sm:w-auto">
                    Continue to Website
                </a>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    let deferredPrompt;

    window.addEventListener('beforeinstallprompt', (e) => {
        e.preventDefault();
        deferredPrompt = e;
    });

    async function addToHomeScreen() {
        if (deferredPrompt) {
            deferredPrompt.prompt();
            const { outcome } = await deferredPrompt.userChoice;
            deferredPrompt = null;
        } else {
             alert('To install the app:\n1. Open this page in Chrome/Safari\n2. Tap "Add to Home Screen" in the menu');
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/download.blade.php ENDPATH**/ ?>