<?php if($paginator->hasPages()): ?>
    <nav role="navigation" aria-label="<?php echo e(__('Pagination Navigation')); ?>" class="flex items-center justify-between">
        
        <div class="flex justify-between flex-1 sm:hidden">
            <?php if($paginator->onFirstPage()): ?>
                <span class="relative inline-flex items-center px-6 py-3 text-xs font-black text-gray-300 bg-white border border-gray-100 cursor-default leading-5 rounded-2xl uppercase tracking-widest italic">
                    <?php echo __('pagination.previous'); ?>

                </span>
            <?php else: ?>
                <a href="<?php echo e($paginator->previousPageUrl()); ?>" class="relative inline-flex items-center px-6 py-3 text-xs font-black text-primary bg-white border border-primary/20 leading-5 rounded-2xl hover:bg-primary hover:text-white transition-all duration-300 shadow-sm active:scale-95 uppercase tracking-widest italic">
                    <?php echo __('pagination.previous'); ?>

                </a>
            <?php endif; ?>

            <?php if($paginator->hasMorePages()): ?>
                <a href="<?php echo e($paginator->nextPageUrl()); ?>" class="relative inline-flex items-center px-6 py-3 ml-3 text-xs font-black text-primary bg-white border border-primary/20 leading-5 rounded-2xl hover:bg-primary hover:text-white transition-all duration-300 shadow-sm active:scale-95 uppercase tracking-widest italic">
                    <?php echo __('pagination.next'); ?>

                </a>
            <?php else: ?>
                <span class="relative inline-flex items-center px-6 py-3 ml-3 text-xs font-black text-gray-300 bg-white border border-gray-100 cursor-default leading-5 rounded-2xl uppercase tracking-widest italic">
                    <?php echo __('pagination.next'); ?>

                </span>
            <?php endif; ?>
        </div>

        
        <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
            <div>
                <p class="text-xs text-gray-400 font-bold uppercase tracking-widest">
                    Showing <span class="text-gray-900"><?php echo e($paginator->firstItem() ?? 0); ?></span> to <span class="text-gray-900"><?php echo e($paginator->lastItem() ?? 0); ?></span> of <span class="text-primary"><?php echo e($paginator->total()); ?></span> results
                </p>
            </div>

            <div>
                <span class="relative z-0 inline-flex items-center gap-2">
                    
                    <?php if($paginator->onFirstPage()): ?>
                        <span aria-disabled="true" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-300 border border-gray-100 cursor-not-allowed">
                            <i class="fa-solid fa-chevron-left text-xs"></i>
                        </span>
                    <?php else: ?>
                        <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" class="w-10 h-10 rounded-xl bg-white flex items-center justify-center text-primary border border-primary/20 hover:bg-primary hover:text-white hover:border-primary transition-all duration-300 shadow-sm hover:shadow-primary/20 active:scale-90" aria-label="<?php echo e(__('pagination.previous')); ?>">
                            <i class="fa-solid fa-chevron-left text-xs"></i>
                        </a>
                    <?php endif; ?>

                    
                    <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if(is_string($element)): ?>
                            <span aria-disabled="true" class="w-10 h-10 flex items-center justify-center text-gray-400 font-bold">
                                <?php echo e($element); ?>

                            </span>
                        <?php endif; ?>

                        
                        <?php if(is_array($element)): ?>
                            <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($page == $paginator->currentPage()): ?>
                                    <span aria-current="page" class="w-10 h-10 rounded-xl bg-primary flex items-center justify-center text-white font-black text-sm shadow-lg shadow-primary/30 z-10">
                                        <?php echo e($page); ?>

                                    </span>
                                <?php else: ?>
                                    <a href="<?php echo e($url); ?>" class="w-10 h-10 rounded-xl bg-white flex items-center justify-center text-gray-600 font-bold text-sm border border-gray-100 hover:border-primary/50 hover:text-primary transition-all duration-300 shadow-sm active:scale-90" aria-label="<?php echo e(__('Go to page :page', ['page' => $page])); ?>">
                                        <?php echo e($page); ?>

                                    </a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    
                    <?php if($paginator->hasMorePages()): ?>
                        <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" class="w-10 h-10 rounded-xl bg-white flex items-center justify-center text-primary border border-primary/20 hover:bg-primary hover:text-white hover:border-primary transition-all duration-300 shadow-sm hover:shadow-primary/20 active:scale-90" aria-label="<?php echo e(__('pagination.next')); ?>">
                            <i class="fa-solid fa-chevron-right text-xs"></i>
                        </a>
                    <?php else: ?>
                        <span aria-disabled="true" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-300 border border-gray-100 cursor-not-allowed">
                            <i class="fa-solid fa-chevron-right text-xs"></i>
                        </span>
                    <?php endif; ?>
                </span>
            </div>
        </div>
    </nav>
<?php endif; ?>
<?php /**PATH /home/yilickapp/website/resources/views/vendor/pagination/yilick.blade.php ENDPATH**/ ?>