<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Batch;

class AgentTask extends \Google\Model
{
  /**
   * Unspecified state.
   */
  public const INTENDED_STATE_INTENDED_STATE_UNSPECIFIED = 'INTENDED_STATE_UNSPECIFIED';
  /**
   * Assigned state (includes running and finished).
   */
  public const INTENDED_STATE_ASSIGNED = 'ASSIGNED';
  /**
   * The agent should cancel the execution of this task.
   */
  public const INTENDED_STATE_CANCELLED = 'CANCELLED';
  /**
   * Delete task from agent storage, stop reporting its state.
   */
  public const INTENDED_STATE_DELETED = 'DELETED';
  /**
   * Unspecified task source.
   */
  public const TASK_SOURCE_TASK_SOURCE_UNSPECIFIED = 'TASK_SOURCE_UNSPECIFIED';
  /**
   * The AgentTask from this source is generated by Batch server. E.g. all the
   * VMActions are from this source. When Batch Agent execute AgentTask from
   * BATCH_INTERNAL, it will log stdout/err with "batch_agent_logs" log name.
   */
  public const TASK_SOURCE_BATCH_INTERNAL = 'BATCH_INTERNAL';
  /**
   * The AgentTask from this source is provided by Batch users. When Batch Agent
   * execute AgentTask from USER, it will log stdout/err with "batch_task_logs"
   * log name.
   */
  public const TASK_SOURCE_USER = 'USER';
  protected $agentTaskSpecType = AgentTaskSpec::class;
  protected $agentTaskSpecDataType = '';
  /**
   * The intended state of the task.
   *
   * @var string
   */
  public $intendedState;
  /**
   * The highest barrier reached by all tasks in the task's TaskGroup.
   *
   * @var string
   */
  public $reachedBarrier;
  protected $specType = TaskSpec::class;
  protected $specDataType = '';
  protected $statusType = TaskStatus::class;
  protected $statusDataType = '';
  /**
   * Task name.
   *
   * @var string
   */
  public $task;
  /**
   * TaskSource represents the source of the task.
   *
   * @var string
   */
  public $taskSource;

  /**
   * AgentTaskSpec is the taskSpec representation between Agent and CLH
   * communication. This field will replace the TaskSpec field above in future
   * to have a better separation between user-facaing API and internal API.
   *
   * @param AgentTaskSpec $agentTaskSpec
   */
  public function setAgentTaskSpec(AgentTaskSpec $agentTaskSpec)
  {
    $this->agentTaskSpec = $agentTaskSpec;
  }
  /**
   * @return AgentTaskSpec
   */
  public function getAgentTaskSpec()
  {
    return $this->agentTaskSpec;
  }
  /**
   * The intended state of the task.
   *
   * Accepted values: INTENDED_STATE_UNSPECIFIED, ASSIGNED, CANCELLED, DELETED
   *
   * @param self::INTENDED_STATE_* $intendedState
   */
  public function setIntendedState($intendedState)
  {
    $this->intendedState = $intendedState;
  }
  /**
   * @return self::INTENDED_STATE_*
   */
  public function getIntendedState()
  {
    return $this->intendedState;
  }
  /**
   * The highest barrier reached by all tasks in the task's TaskGroup.
   *
   * @param string $reachedBarrier
   */
  public function setReachedBarrier($reachedBarrier)
  {
    $this->reachedBarrier = $reachedBarrier;
  }
  /**
   * @return string
   */
  public function getReachedBarrier()
  {
    return $this->reachedBarrier;
  }
  /**
   * Task Spec. This field will be replaced by agent_task_spec below in future.
   *
   * @param TaskSpec $spec
   */
  public function setSpec(TaskSpec $spec)
  {
    $this->spec = $spec;
  }
  /**
   * @return TaskSpec
   */
  public function getSpec()
  {
    return $this->spec;
  }
  /**
   * Task status.
   *
   * @param TaskStatus $status
   */
  public function setStatus(TaskStatus $status)
  {
    $this->status = $status;
  }
  /**
   * @return TaskStatus
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * Task name.
   *
   * @param string $task
   */
  public function setTask($task)
  {
    $this->task = $task;
  }
  /**
   * @return string
   */
  public function getTask()
  {
    return $this->task;
  }
  /**
   * TaskSource represents the source of the task.
   *
   * Accepted values: TASK_SOURCE_UNSPECIFIED, BATCH_INTERNAL, USER
   *
   * @param self::TASK_SOURCE_* $taskSource
   */
  public function setTaskSource($taskSource)
  {
    $this->taskSource = $taskSource;
  }
  /**
   * @return self::TASK_SOURCE_*
   */
  public function getTaskSource()
  {
    return $this->taskSource;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AgentTask::class, 'Google_Service_Batch_AgentTask');
