<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DeploymentManager;

class Deployment extends \Google\Collection
{
  protected $collection_key = 'labels';
  /**
   * An optional user-provided description of the deployment.
   *
   * @var string
   */
  public $description;
  /**
   * Provides a fingerprint to use in requests to modify a deployment, such as
   * `update()`, `stop()`, and `cancelPreview()` requests. A fingerprint is a
   * randomly generated value that must be provided with `update()`, `stop()`,
   * and `cancelPreview()` requests to perform optimistic locking. This ensures
   * optimistic concurrency so that only one request happens at a time. The
   * fingerprint is initially generated by Deployment Manager and changes after
   * every request to modify data. To get the latest fingerprint value, perform
   * a `get()` request to a deployment.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * @var string
   */
  public $id;
  /**
   * Output only. Creation timestamp in RFC3339 text format.
   *
   * @var string
   */
  public $insertTime;
  protected $labelsType = DeploymentLabelEntry::class;
  protected $labelsDataType = 'array';
  /**
   * Output only. URL of the manifest representing the last manifest that was
   * successfully deployed. If no manifest has been successfully deployed, this
   * field will be absent.
   *
   * @var string
   */
  public $manifest;
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  protected $operationType = Operation::class;
  protected $operationDataType = '';
  /**
   * Output only. Server defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  protected $targetType = TargetConfiguration::class;
  protected $targetDataType = '';
  protected $updateType = DeploymentUpdate::class;
  protected $updateDataType = '';
  /**
   * Output only. Update timestamp in RFC3339 text format.
   *
   * @var string
   */
  public $updateTime;

  /**
   * An optional user-provided description of the deployment.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Provides a fingerprint to use in requests to modify a deployment, such as
   * `update()`, `stop()`, and `cancelPreview()` requests. A fingerprint is a
   * randomly generated value that must be provided with `update()`, `stop()`,
   * and `cancelPreview()` requests to perform optimistic locking. This ensures
   * optimistic concurrency so that only one request happens at a time. The
   * fingerprint is initially generated by Deployment Manager and changes after
   * every request to modify data. To get the latest fingerprint value, perform
   * a `get()` request to a deployment.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Output only. Creation timestamp in RFC3339 text format.
   *
   * @param string $insertTime
   */
  public function setInsertTime($insertTime)
  {
    $this->insertTime = $insertTime;
  }
  /**
   * @return string
   */
  public function getInsertTime()
  {
    return $this->insertTime;
  }
  /**
   * Map of One Platform labels; provided by the client when the resource is
   * created or updated. Specifically: Label keys must be between 1 and 63
   * characters long and must conform to the following regular expression:
   * `[a-z]([-a-z0-9]*[a-z0-9])?` Label values must be between 0 and 63
   * characters long and must conform to the regular expression
   * `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   *
   * @param DeploymentLabelEntry[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return DeploymentLabelEntry[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Output only. URL of the manifest representing the last manifest that was
   * successfully deployed. If no manifest has been successfully deployed, this
   * field will be absent.
   *
   * @param string $manifest
   */
  public function setManifest($manifest)
  {
    $this->manifest = $manifest;
  }
  /**
   * @return string
   */
  public function getManifest()
  {
    return $this->manifest;
  }
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. The Operation that most recently ran, or is currently running,
   * on this deployment.
   *
   * @param Operation $operation
   */
  public function setOperation(Operation $operation)
  {
    $this->operation = $operation;
  }
  /**
   * @return Operation
   */
  public function getOperation()
  {
    return $this->operation;
  }
  /**
   * Output only. Server defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * [Input Only] The parameters that define your deployment, including the
   * deployment configuration and relevant templates.
   *
   * @param TargetConfiguration $target
   */
  public function setTarget(TargetConfiguration $target)
  {
    $this->target = $target;
  }
  /**
   * @return TargetConfiguration
   */
  public function getTarget()
  {
    return $this->target;
  }
  /**
   * Output only. If Deployment Manager is currently updating or previewing an
   * update to this deployment, the updated configuration appears here.
   *
   * @param DeploymentUpdate $update
   */
  public function setUpdate(DeploymentUpdate $update)
  {
    $this->update = $update;
  }
  /**
   * @return DeploymentUpdate
   */
  public function getUpdate()
  {
    return $this->update;
  }
  /**
   * Output only. Update timestamp in RFC3339 text format.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Deployment::class, 'Google_Service_DeploymentManager_Deployment');
